/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import de.micromata.opengis.kml.v_2_2_0.AbstractView;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.LookAt;
import de.micromata.opengis.kml.v_2_2_0.NetworkLink;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.utils.LookAtOptions;
import org.geoserver.wms.WMSInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class LookAtDecoratorFactory
implements KmlDecoratorFactory {
    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (!(context.getService() instanceof WMSInfo)) {
            return null;
        }
        if (Placemark.class.isAssignableFrom(featureClass)) {
            return new PlacemarkLookAtDecorator();
        }
        if (Folder.class.isAssignableFrom(featureClass) || NetworkLink.class.isAssignableFrom(featureClass)) {
            return new LayerLookAtDecorator();
        }
        if (Document.class.isAssignableFrom(featureClass)) {
            return new DocumentLookAtDecorator();
        }
        return null;
    }

    public LookAt buildLookAt(Envelope bounds, LookAtOptions options, boolean forceBounds) {
        Envelope lookAtEnvelope = bounds;
        Geometry lookAtGeometry = options.getLookAt();
        if (!forceBounds && lookAtGeometry != null) {
            lookAtEnvelope = lookAtGeometry.getEnvelopeInternal();
        }
        if (lookAtEnvelope == null || lookAtEnvelope.isNull()) {
            return null;
        }
        double lon1 = lookAtEnvelope.getMinX();
        double lat1 = lookAtEnvelope.getMinY();
        double lon2 = lookAtEnvelope.getMaxX();
        double lat2 = lookAtEnvelope.getMaxY();
        double R_EARTH = 6371000.0;
        double VIEWER_WIDTH = 0.3839724354387525;
        double[] p1 = this.getRect(lon1, lat1, R_EARTH);
        double[] p2 = this.getRect(lon2, lat2, R_EARTH);
        double[] midpoint = new double[]{(p1[0] + p2[0]) / 2.0, (p1[1] + p2[1]) / 2.0, (p1[2] + p2[2]) / 2.0};
        midpoint = this.getGeographic(midpoint[0], midpoint[1], midpoint[2]);
        Double distance = options.getRange();
        if (null == distance) {
            distance = this.distance(p1, p2);
        }
        double height = distance / (2.0 * Math.tan(VIEWER_WIDTH));
        Double tilt = options.getTilt() == null ? Double.valueOf(0.0) : options.getTilt();
        Double heading = options.getHeading() == null ? Double.valueOf(0.0) : options.getHeading();
        Double altitude = options.getAltitude() == null ? Double.valueOf(height) : options.getAltitude();
        LookAt lookAt = new LookAt();
        lookAt.setLongitude(midpoint[0]);
        lookAt.setLatitude(midpoint[1]);
        lookAt.setAltitude(altitude.doubleValue());
        lookAt.setRange(distance.doubleValue());
        lookAt.setTilt(tilt.doubleValue());
        lookAt.setHeading(heading.doubleValue());
        lookAt.setAltitudeMode(options.getAltitudeMode());
        return lookAt;
    }

    private double[] getRect(double lat, double lon, double radius) {
        double theta = (90.0 - lat) * Math.PI / 180.0;
        double phi = (90.0 - lon) * Math.PI / 180.0;
        double x = radius * Math.sin(phi) * Math.cos(theta);
        double y = radius * Math.sin(phi) * Math.sin(theta);
        double z = radius * Math.cos(phi);
        return new double[]{x, y, z};
    }

    private double[] getGeographic(double x, double y, double z) {
        double radius = this.distance(new double[]{x, y, z}, new double[]{0.0, 0.0, 0.0});
        double theta = Math.atan2(Math.sqrt(x * x + y * y), z);
        double phi = Math.atan2(y, x);
        double lat = 90.0 - theta * 180.0 / Math.PI;
        double lon = 90.0 - phi * 180.0 / Math.PI;
        return new double[]{lon > 180.0 ? lon - 360.0 : lon, lat, radius};
    }

    private double distance(double[] p1, double[] p2) {
        double dx = p1[0] - p2[0];
        double dy = p1[1] - p2[1];
        double dz = p1[2] - p2[2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    class PlacemarkLookAtDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        PlacemarkLookAtDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            Placemark pm = (Placemark)feature;
            Geometry geometry = (Geometry)context.getCurrentFeature().getDefaultGeometry();
            Envelope bounds = null;
            if (geometry != null) {
                bounds = geometry.getEnvelopeInternal();
            }
            LookAt lookAt = LookAtDecoratorFactory.this.buildLookAt(bounds, context.getLookAtOptions(), true);
            pm.setAbstractView((AbstractView)lookAt);
            return pm;
        }
    }

    class LayerLookAtDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        LayerLookAtDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            ReferencedEnvelope bounds = context.getCurrentLayer().getBounds();
            LookAt lookAt = LookAtDecoratorFactory.this.buildLookAt((Envelope)bounds, context.getLookAtOptions(), false);
            feature.setAbstractView((AbstractView)lookAt);
            return feature;
        }
    }

    class DocumentLookAtDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        DocumentLookAtDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            Document document = (Document)feature;
            ReferencedEnvelope bounds = context.getMapContent().getRenderingArea();
            LookAt lookAt = LookAtDecoratorFactory.this.buildLookAt((Envelope)bounds, context.getLookAtOptions(), false);
            document.setAbstractView((AbstractView)lookAt);
            return document;
        }
    }
}

