/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.builder;

import de.micromata.opengis.kml.v_2_2_0.AbstractView;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Link;
import de.micromata.opengis.kml.v_2_2_0.LookAt;
import de.micromata.opengis.kml.v_2_2_0.NetworkLink;
import de.micromata.opengis.kml.v_2_2_0.RefreshMode;
import de.micromata.opengis.kml.v_2_2_0.ViewRefreshMode;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.builder.AbstractNetworkLinkBuilder;
import org.geoserver.kml.decorator.LookAtDecoratorFactory;
import org.geoserver.kml.utils.LookAtOptions;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSRequests;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class SimpleNetworkLinkBuilder
extends AbstractNetworkLinkBuilder {
    static final Logger LOGGER = Logging.getLogger(SimpleNetworkLinkBuilder.class);
    static final String REFRESH_KEY = "kmlrefresh";
    static final String VISIBLE_KEY = "kmlvisible";

    public SimpleNetworkLinkBuilder(KmlEncodingContext context) {
        super(context);
    }

    @Override
    void encodeDocumentContents(Document container) {
        WMSMapContent mapContent = this.context.getMapContent();
        GetMapRequest request = this.context.getRequest();
        Map formatOptions = request.getFormatOptions();
        LookAtDecoratorFactory lookAtFactory = new LookAtDecoratorFactory();
        LookAtOptions lookAtOptions = new LookAtOptions(formatOptions);
        ArrayList<ReferencedEnvelope> layerBounds = new ArrayList<ReferencedEnvelope>(mapContent.layers().size());
        ReferencedEnvelope aggregatedBounds = this.computePerLayerQueryBounds(mapContent, layerBounds, null);
        if (aggregatedBounds != null) {
            LookAt la = lookAtFactory.buildLookAt((Envelope)aggregatedBounds, lookAtOptions, false);
            container.setAbstractView((AbstractView)la);
        }
        List layers = request.getLayers();
        List styles = request.getStyles();
        for (int i = 0; i < layers.size(); ++i) {
            MapLayerInfo layerInfo = (MapLayerInfo)layers.get(i);
            NetworkLink nl = container.createAndAddNetworkLink();
            nl.setName(layerInfo.getLabel());
            if (layerInfo.getDescription() != null && layerInfo.getDescription().length() > 0) {
                nl.setDescription(layerInfo.getDescription());
            }
            if (formatOptions.get(VISIBLE_KEY) != null) {
                boolean visible = Boolean.parseBoolean(formatOptions.get(VISIBLE_KEY).toString());
                nl.setVisibility(Boolean.valueOf(visible));
            } else {
                nl.setVisibility(Boolean.valueOf(true));
            }
            nl.setOpen(Boolean.valueOf(true));
            Envelope requestBox = this.context.getRequestBoxWGS84();
            if (requestBox != null) {
                LookAt la = lookAtFactory.buildLookAt(requestBox, lookAtOptions, false);
                nl.setAbstractView((AbstractView)la);
            }
            GetMapRequest requestCopy = (GetMapRequest)request.clone();
            requestCopy.setBbox(null);
            String style = i < styles.size() ? ((Style)styles.get(i)).getName() : null;
            String href = WMSRequests.getGetMapUrl((GetMapRequest)requestCopy, (String)((MapLayerInfo)layers.get(i)).getName(), (int)i, (String)style, null, null);
            try {
                href = URLDecoder.decode(href, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            Link url = nl.createAndSetUrl();
            url.setHref(href);
            url.setViewRefreshMode(ViewRefreshMode.ON_STOP);
            url.setViewRefreshTime(1.0);
            url.setViewBoundScale(1.0);
            if (formatOptions.get(REFRESH_KEY) == null) continue;
            String refreshValue = formatOptions.get(REFRESH_KEY).toString();
            if (refreshValue.equalsIgnoreCase("expires")) {
                url.setRefreshMode(RefreshMode.ON_EXPIRE);
                continue;
            }
            int interval = Integer.parseInt(refreshValue);
            url.setRefreshInterval((double)interval);
            url.setRefreshMode(RefreshMode.ON_INTERVAL);
        }
    }
}

