/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.kml.KMLEncoder;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.iterator.IteratorList;
import org.geoserver.kml.iterator.WFSFeatureIteratorFactory;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSKMLOutputFormat
extends WFSGetFeatureOutputFormat {
    private KMLEncoder encoder;

    public WFSKMLOutputFormat(KMLEncoder encoder, GeoServer gs) {
        super(gs, new HashSet<String>(Arrays.asList("KML", "application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kml+xml".replace('+', ' '))));
        this.encoder = encoder;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/vnd.google-earth.kml+xml";
    }

    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        List<SimpleFeatureCollection> collections = this.getFeatureCollections(featureCollection);
        WFSKmlEncodingContext context = new WFSKmlEncodingContext(this.gs.getService(WFSInfo.class), collections);
        Kml kml = new Kml();
        Document document = kml.createAndSetDocument();
        List<KmlDecoratorFactory.KmlDecorator> docDecorators = context.getDecoratorsForClass(Document.class);
        for (KmlDecoratorFactory.KmlDecorator decorator : docDecorators) {
            document = (Document)decorator.decorate((Feature)document, context);
            if (document != null) continue;
            throw new ServiceException("Coding error in decorator " + decorator + ", document objects cannot be set to null");
        }
        Iterator<KmlDecoratorFactory.KmlDecorator> iterator = collections.iterator();
        while (iterator.hasNext()) {
            KmlDecoratorFactory.KmlDecorator decorator;
            SimpleFeatureCollection collection;
            SimpleFeatureCollection fc = collection = (SimpleFeatureCollection)iterator.next();
            Folder folder = document.createAndAddFolder();
            folder.setName(((SimpleFeatureType)fc.getSchema()).getTypeName());
            List<KmlDecoratorFactory.KmlDecorator> folderDecorators = context.getDecoratorsForClass(Folder.class);
            Iterator<KmlDecoratorFactory.KmlDecorator> iterator2 = folderDecorators.iterator();
            while (iterator2.hasNext() && (folder = (Folder)(decorator = iterator2.next()).decorate((Feature)folder, context)) != null) {
            }
            if (folder == null) continue;
            ((KmlEncodingContext)context).setCurrentFeatureCollection(fc);
            IteratorList<Feature> features = new IteratorList<Feature>(new WFSFeatureIteratorFactory(context));
            context.addFeatures(folder, features);
        }
        this.encoder.encode(kml, output, context);
    }

    private List<SimpleFeatureCollection> getFeatureCollections(FeatureCollectionResponse featureCollection) {
        List inputs = featureCollection.getFeatures();
        ArrayList<SimpleFeatureCollection> result = new ArrayList<SimpleFeatureCollection>();
        for (FeatureCollection fc : inputs) {
            if (!(fc instanceof SimpleFeatureCollection)) {
                throw new ServiceException("The KML output format can only be applied to simple features");
            }
            SimpleFeatureCollection sfc = (SimpleFeatureCollection)fc;
            CoordinateReferenceSystem sourceCRS = ((SimpleFeatureType)sfc.getSchema()).getCoordinateReferenceSystem();
            if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)DefaultGeographicCRS.WGS84)) {
                sfc = new ReprojectingFeatureCollection(sfc, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            result.add(sfc);
        }
        return result;
    }

    protected String getExtension(FeatureCollectionResponse response) {
        return "kml";
    }

    public String getCapabilitiesElementName() {
        return "KML";
    }

    static class WFSKmlEncodingContext
    extends KmlEncodingContext {
        private List<SimpleFeatureCollection> collections;
        private SimpleFeatureType featureType;

        public WFSKmlEncodingContext(ServiceInfo si, List<SimpleFeatureCollection> collections) {
            this.service = this.getService();
            this.collections = collections;
            this.descriptionEnabled = false;
            this.kmScore = 100;
            this.extendedDataEnabled = true;
            this.kmz = false;
        }

        @Override
        public List<SimpleFeatureType> getFeatureTypes() {
            ArrayList<SimpleFeatureType> results = new ArrayList<SimpleFeatureType>();
            for (SimpleFeatureCollection fc : this.collections) {
                results.add((SimpleFeatureType)fc.getSchema());
            }
            return results;
        }

        @Override
        public void setCurrentFeatureCollection(SimpleFeatureCollection currentFeatureCollection) {
            super.setCurrentFeatureCollection(currentFeatureCollection);
            ++this.layerIndex;
            this.featureType = (SimpleFeatureType)currentFeatureCollection.getSchema();
        }

        @Override
        public SimpleFeatureType getCurrentFeatureType() {
            return this.featureType;
        }
    }
}

