/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.ServiceInfo;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.iterator.CompositeList;
import org.geoserver.kml.utils.LookAtOptions;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.featureinfo.FeatureTemplate;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapViewport;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class KmlEncodingContext {
    static final Logger LOGGER = Logging.getLogger(KmlEncodingContext.class);
    protected boolean kmz;
    protected WMSMapContent mapContent;
    protected GetMapRequest request;
    protected List<Symbolizer> currentSymbolizers;
    protected Layer currentLayer;
    protected SimpleFeatureCollection currentFeatureCollection;
    protected SimpleFeature currentFeature;
    protected Map<String, Object> metadata = new HashMap<String, Object>();
    protected boolean descriptionEnabled;
    protected FeatureTemplate template = new FeatureTemplate();
    protected LookAtOptions lookAtOptions;
    protected WMS wms;
    protected Map<String, Layer> kmzGroundOverlays = new LinkedHashMap<String, Layer>();
    protected boolean placemarkForced;
    protected String superOverlayMode;
    protected boolean superOverlayEnabled;
    protected boolean networkLinksFormat;
    protected boolean extendedDataEnabled;
    protected int kmScore;
    protected ServiceInfo service;
    protected int layerIndex;
    protected String mode;
    protected IdentityHashMap<FeatureIterator, FeatureIterator> iterators = new IdentityHashMap();
    public static final ReferencedEnvelope WORLD_BOUNDS_WGS84 = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    protected boolean liveIcons;
    protected Map<String, Style> iconStyles;

    public KmlEncodingContext(WMSMapContent mapContent, WMS wms, boolean kmz) {
        this.mapContent = this.fixViewport(mapContent);
        this.request = mapContent.getRequest();
        this.wms = wms;
        this.mode = this.computeModeOption(this.request.getFormatOptions());
        this.descriptionEnabled = this.computeKMAttr();
        this.lookAtOptions = new LookAtOptions(this.request.getFormatOptions());
        this.placemarkForced = this.computeKmplacemark();
        this.superOverlayMode = this.computeSuperOverlayMode();
        this.superOverlayEnabled = this.computeSuperOverlayEnabled();
        this.extendedDataEnabled = this.computeExtendedDataEnabled();
        this.kmScore = this.computeKmScore();
        this.networkLinksFormat = "application/vnd.google-earth.kml+xml;mode=networklink".equals(this.request.getFormat()) || "application/vnd.google-earth.kmz;mode=networklink".equals(this.request.getFormat());
        this.kmz = kmz;
        this.service = wms.getServiceInfo();
        this.liveIcons = true;
        this.iconStyles = new HashMap<String, Style>();
        Boolean autofit = (Boolean)Converters.convert(this.request.getFormatOptions().get("autofit"), Boolean.class);
        if (autofit != null && ((Boolean)Converters.convert((Object)autofit, Boolean.class)).booleanValue()) {
            double width = mapContent.getMapWidth();
            double height = mapContent.getMapHeight();
            ReferencedEnvelope bbox = mapContent.getViewport().getBounds();
            double bbox_width = bbox.getWidth();
            double bbox_height = bbox.getHeight();
            if (bbox_width > 0.0 && bbox_height > 0.0 & width > 0.0 & height > 0.0) {
                double ratio = bbox_width / bbox_height;
                if (bbox_width > bbox_height) {
                    height = width / ratio;
                    int h = (int)Math.ceil(height);
                    mapContent.setMapHeight(h);
                    mapContent.getRequest().setHeight(h);
                } else {
                    width = height * ratio;
                    int w = (int)Math.ceil(width);
                    mapContent.setMapWidth(w);
                    mapContent.getRequest().setWidth(w);
                }
            }
        }
    }

    private String computeModeOption(Map<String, Object> rawKvp) {
        String mode = KvpUtils.caseInsensitiveParam(rawKvp, (String)"mode", null);
        return mode;
    }

    private WMSMapContent fixViewport(WMSMapContent mc) {
        MapViewport viewport = mc.getViewport();
        if (!CRS.equalsIgnoreMetadata((Object)viewport.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84)) {
            viewport.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            GetMapRequest req = mc.getRequest();
            req.setSRS("EPSG:4326");
            req.setBbox((Envelope)viewport.getBounds());
        }
        return mc;
    }

    protected KmlEncodingContext() {
    }

    boolean computeKmplacemark() {
        Object kmplacemark = this.request.getFormatOptions().get("kmplacemark");
        if (kmplacemark != null) {
            return (Boolean)Converters.convert(kmplacemark, Boolean.class);
        }
        return this.wms.getKmlPlacemark();
    }

    boolean computeKMAttr() {
        Object kmattr = this.request.getFormatOptions().get("kmattr");
        if (kmattr == null) {
            kmattr = this.request.getRawKvp().get("kmattr");
        }
        if (kmattr != null) {
            return (Boolean)Converters.convert(kmattr, Boolean.class);
        }
        return this.wms.getKmlKmAttr();
    }

    private int computeKmScore() {
        int kmScore = this.wms.getKmScore();
        Map fo = this.request.getFormatOptions();
        Object kmScoreObj = fo.get("kmscore");
        if (kmScoreObj != null) {
            kmScore = (Integer)kmScoreObj;
        }
        return kmScore;
    }

    boolean computeExtendedDataEnabled() {
        Map formatOptions = this.request.getFormatOptions();
        Boolean extendedData = (Boolean)Converters.convert(formatOptions.get("extendedData"), Boolean.class);
        if (extendedData == null) {
            extendedData = Boolean.FALSE;
        }
        return extendedData;
    }

    boolean computeSuperOverlayEnabled() {
        Map formatOptions = this.request.getFormatOptions();
        Boolean superoverlay = (Boolean)formatOptions.get("superoverlay");
        if (superoverlay == null) {
            superoverlay = Boolean.FALSE;
        }
        return superoverlay;
    }

    String computeSuperOverlayMode() {
        String overlayMode = (String)this.request.getFormatOptions().get("superoverlay_mode");
        if (overlayMode != null) {
            return overlayMode;
        }
        overlayMode = (String)this.request.getFormatOptions().get("overlayMode");
        if (overlayMode != null) {
            return overlayMode;
        }
        return this.wms.getKmlSuperoverlayMode();
    }

    public List<KmlDecoratorFactory.KmlDecorator> getDecoratorsForClass(Class<? extends Feature> clazz) {
        List factories = GeoServerExtensions.extensions(KmlDecoratorFactory.class);
        ArrayList<KmlDecoratorFactory.KmlDecorator> result = new ArrayList<KmlDecoratorFactory.KmlDecorator>();
        for (KmlDecoratorFactory factory : factories) {
            KmlDecoratorFactory.KmlDecorator decorator = factory.getDecorator(clazz, this);
            if (decorator == null) continue;
            result.add(decorator);
        }
        return result;
    }

    public void addFeatures(Folder folder, List<Feature> features) {
        List originalFeatures = folder.getFeature();
        if (originalFeatures == null || originalFeatures.isEmpty()) {
            folder.setFeature(features);
        } else {
            folder.setFeature(new CompositeList(originalFeatures, features));
        }
    }

    public void addFeatures(Document document, List<Feature> features) {
        List originalFeatures = document.getFeature();
        if (originalFeatures == null || originalFeatures.isEmpty()) {
            document.setFeature(features);
        } else {
            document.setFeature(new CompositeList(originalFeatures, features));
        }
    }

    public WMSMapContent getMapContent() {
        return this.mapContent;
    }

    public void setMapContent(WMSMapContent mapContent) {
        this.mapContent = mapContent;
    }

    public GetMapRequest getRequest() {
        return this.request;
    }

    public void setRequest(GetMapRequest request) {
        this.request = request;
    }

    public List<Symbolizer> getCurrentSymbolizers() {
        return this.currentSymbolizers;
    }

    public void setCurrentSymbolizers(List<Symbolizer> symbolizers) {
        this.currentSymbolizers = symbolizers;
    }

    public Layer getCurrentLayer() {
        return this.currentLayer;
    }

    public void setCurrentLayer(Layer currentLayer) {
        this.currentLayer = currentLayer;
        ++this.layerIndex;
    }

    public SimpleFeature getCurrentFeature() {
        return this.currentFeature;
    }

    public void setCurrentFeature(SimpleFeature currentFeature) {
        this.currentFeature = currentFeature;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isDescriptionEnabled() {
        return this.descriptionEnabled;
    }

    public void setDescriptionEnabled(boolean descriptionEnabled) {
        this.descriptionEnabled = descriptionEnabled;
    }

    public FeatureTemplate getTemplate() {
        return this.template;
    }

    public LookAtOptions getLookAtOptions() {
        return this.lookAtOptions;
    }

    public WMS getWms() {
        return this.wms;
    }

    public SimpleFeatureCollection getCurrentFeatureCollection() {
        return this.currentFeatureCollection;
    }

    public void setCurrentFeatureCollection(SimpleFeatureCollection currentFeatureCollection) {
        this.currentFeatureCollection = currentFeatureCollection;
    }

    public boolean isKmz() {
        return this.kmz;
    }

    public void addKmzGroundOverlay(String imagePath, Layer layer) {
        if (!this.kmz) {
            throw new IllegalStateException("Cannot add ground overlay layers, the output is not supposed to be a KMZ");
        }
        this.kmzGroundOverlays.put(imagePath, layer);
    }

    public Map<String, Layer> getKmzGroundOverlays() {
        return this.kmzGroundOverlays;
    }

    public boolean isPlacemarkForced() {
        return this.placemarkForced;
    }

    public void setPlacemarkForced(boolean placemarkForced) {
        this.placemarkForced = placemarkForced;
    }

    public boolean isSuperOverlayEnabled() {
        return this.superOverlayEnabled;
    }

    public String getSuperOverlayMode() {
        return this.superOverlayMode;
    }

    public boolean isNetworkLinksFormat() {
        return this.networkLinksFormat;
    }

    public boolean isExtendedDataEnabled() {
        return this.extendedDataEnabled;
    }

    public int getKmScore() {
        return this.kmScore;
    }

    public ServiceInfo getService() {
        return this.service;
    }

    public List<SimpleFeatureType> getFeatureTypes() {
        ArrayList<SimpleFeatureType> results = new ArrayList<SimpleFeatureType>();
        for (Layer layer : this.mapContent.layers()) {
            if (layer instanceof FeatureLayer) {
                results.add((SimpleFeatureType)layer.getFeatureSource().getSchema());
                continue;
            }
            results.add(null);
        }
        return results;
    }

    public SimpleFeatureType getCurrentFeatureType() {
        if (this.currentLayer instanceof FeatureLayer) {
            FeatureLayer fl = (FeatureLayer)this.currentLayer;
            return (SimpleFeatureType)fl.getFeatureSource().getSchema();
        }
        return null;
    }

    public int getCurrentLayerIndex() {
        return this.layerIndex;
    }

    public boolean isLiveIcons() {
        return this.liveIcons;
    }

    public void setLiveIcons(boolean liveIcons) {
        this.liveIcons = liveIcons;
    }

    public Map<String, Style> getIconStyles() {
        return this.iconStyles;
    }

    public String getMode() {
        return this.mode;
    }

    public FeatureIterator openIterator(FeatureCollection fc) {
        FeatureIterator fi = fc.features();
        this.iterators.put(fi, fi);
        return fi;
    }

    public void closeIterator(FeatureIterator fi) {
        try {
            fi.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "An exception occurred while closing a feature iterator during the cleanup phases of the KML encoding", e);
        }
        finally {
            this.iterators.remove(fi);
        }
    }

    public void closeIterators() {
        for (FeatureIterator fi : this.iterators.keySet()) {
            try {
                fi.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "An exception occurred while closing a feature iterator during the cleanup phases of the KML encoding", e);
            }
        }
        this.iterators.clear();
    }

    public Envelope getRequestBoxWGS84() {
        try {
            ReferencedEnvelope re;
            Envelope env = this.request.getBbox();
            if (env instanceof ReferencedEnvelope) {
                re = (ReferencedEnvelope)env;
                if (re.getCoordinateReferenceSystem() == null) {
                    re = new ReferencedEnvelope((Envelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                }
            } else if (this.request.getCrs() != null) {
                re = new ReferencedEnvelope(env, this.request.getCrs());
            } else if (this.request.getSRS() != null) {
                CoordinateReferenceSystem crs = CRS.decode((String)this.request.getSRS());
                re = new ReferencedEnvelope(env, crs);
            } else {
                re = new ReferencedEnvelope(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            if (!CRS.equalsIgnoreMetadata((Object)re.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84)) {
                return re.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            }
            return re;
        }
        catch (Exception e) {
            throw new ServiceException("Requested bounding box " + this.request.getBbox() + " could not be tranformed to WGS84", (Throwable)e);
        }
    }
}

