/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.geoserver.kml.KMLEncoder;
import org.geoserver.kml.KMLMap;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.icons.IconRenderer;
import org.geoserver.wms.map.AbstractMapResponse;
import org.geoserver.wms.map.PNGMapResponse;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.map.Layer;
import org.geotools.styling.Style;

public class KMLMapResponse
extends AbstractMapResponse {
    private WMS wms;
    private KMLEncoder encoder;

    public KMLMapResponse(KMLEncoder encoder, WMS wms) {
        super(KMLMap.class, (Set)null);
        this.wms = wms;
        this.encoder = encoder;
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        return "attachment";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        KMLMap kmlMap = (KMLMap)((Object)value);
        try {
            KmlEncodingContext context = kmlMap.getKmlEncodingContext();
            Kml kml = kmlMap.getKml();
            if (context != null && context.isKmz()) {
                this.encodeAsKmz(kml, context, operation, output);
            } else {
                this.encoder.encode(kml, output, context);
            }
        }
        finally {
            kmlMap.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAsKmz(Kml kml, KmlEncodingContext context, Operation operation, OutputStream output) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(output);
        ZipEntry entry = new ZipEntry("wms.kml");
        zip.putNextEntry(entry);
        this.encoder.encode(kml, zip, context);
        RenderedImageMapOutputFormat pngProducer = new RenderedImageMapOutputFormat("image/png", this.wms);
        PNGMapResponse pngEncoder = new PNGMapResponse(this.wms);
        ZipEntry images = new ZipEntry("images/");
        zip.putNextEntry(images);
        WMSMapContent mapContent = context.getMapContent();
        for (Map.Entry<String, Layer> goEntry : context.getKmzGroundOverlays().entrySet()) {
            String path = goEntry.getKey();
            Layer mapLayer = goEntry.getValue();
            WMSMapContent subContext = new WMSMapContent();
            subContext.addLayer(mapLayer);
            subContext.setRequest(mapContent.getRequest());
            subContext.setMapHeight(mapContent.getMapHeight());
            subContext.setMapWidth(mapContent.getMapWidth());
            subContext.getViewport().setBounds(mapContent.getRenderingArea());
            subContext.setBgColor(mapContent.getBgColor());
            subContext.setBuffer(mapContent.getBuffer());
            subContext.setContactInformation(mapContent.getContactInformation());
            subContext.setKeywords(mapContent.getKeywords());
            subContext.setAbstract(mapContent.getAbstract());
            subContext.setTransparent(true);
            try {
                RenderedImageMap imageMap = pngProducer.produceMap(subContext);
                entry = new ZipEntry(path);
                zip.putNextEntry(entry);
                pngEncoder.write((Object)imageMap, (OutputStream)zip, operation);
                zip.closeEntry();
            }
            finally {
                subContext.dispose();
            }
        }
        zip.closeEntry();
        Map<String, Style> embeddedIcons = context.getIconStyles();
        if (!embeddedIcons.isEmpty()) {
            ZipEntry icons = new ZipEntry("icons/");
            zip.putNextEntry(icons);
            for (Map.Entry<String, Style> namedStyle : embeddedIcons.entrySet()) {
                String name = namedStyle.getKey();
                Style style = namedStyle.getValue();
                BufferedImage icon = IconRenderer.renderIcon((Style)style);
                entry = new ZipEntry("icons/" + name + ".png");
                zip.putNextEntry(entry);
                ImageIO.write((RenderedImage)icon, "PNG", zip);
            }
            zip.closeEntry();
        }
        zip.finish();
        zip.flush();
    }
}

