/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.platform.ServiceException;

public class KMLEncoder {
    private JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Kml.class});
    private Templates templates;

    public KMLEncoder() throws JAXBException, TransformerException {
        String xslt = this.getClass().getResource("icon_style_patch.xsl").toString();
        this.templates = TransformerFactory.newInstance().newTemplates(new StreamSource(xslt));
    }

    public void encode(Kml kml, OutputStream output, KmlEncodingContext context) {
        try {
            if (context != null && context.getWms() == null) {
                this.createMarshaller().marshal((Object)kml, output);
            } else {
                Transformer transformer = this.templates.newTransformer();
                JAXBSource source = new JAXBSource(this.createMarshaller(), (Object)kml);
                transformer.transform((Source)source, new StreamResult(output));
            }
        }
        catch (JAXBException | TransformerException e) {
            throw new ServiceException(e);
        }
        finally {
            if (context != null) {
                context.closeIterators();
            }
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller m = this.context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        return m;
    }
}

