/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class StyleProvider
extends GeoServerDataProvider<StyleInfo> {
    public static GeoServerDataProvider.Property<StyleInfo> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    public static GeoServerDataProvider.Property<StyleInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty("workspace", "workspace.name");
    static final GeoServerDataProvider.Property<StyleInfo> MODIFIED_TIMESTAMP = new GeoServerDataProvider.BeanProperty("datemodfied", "dateModified");
    static final GeoServerDataProvider.Property<StyleInfo> CREATED_TIMESTAMP = new GeoServerDataProvider.BeanProperty("datecreated", "dateCreated");
    static final GeoServerDataProvider.Property<StyleInfo> FORMAT = new GeoServerDataProvider.BeanProperty("format", "format");
    static final GeoServerDataProvider.Property<StyleInfo> FORMAT_VERSION = new GeoServerDataProvider.BeanProperty("formatversion", "formatVersion");
    static List<GeoServerDataProvider.Property<StyleInfo>> PROPERTIES = Arrays.asList(NAME, FORMAT, WORKSPACE);

    public StyleProvider() {
        this.setSort(new SortParam((Object)NAME.getName(), true));
    }

    protected List<StyleInfo> getItems() {
        throw new UnsupportedOperationException("This method should not be being called! We use the catalog streaming API");
    }

    protected List<GeoServerDataProvider.Property<StyleInfo>> getProperties() {
        List<GeoServerDataProvider.Property<StyleInfo>> modifiedPropertiesList = PROPERTIES.stream().map(c -> c).collect(Collectors.toList());
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowCreatedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(CREATED_TIMESTAMP);
        }
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(MODIFIED_TIMESTAMP);
        }
        return modifiedPropertiesList;
    }

    public IModel<StyleInfo> newModel(StyleInfo object) {
        return new StyleDetachableModel(object);
    }

    public long size() {
        Filter filter = this.getFilter();
        int count = this.getCatalog().count(StyleInfo.class, filter);
        return count;
    }

    public int fullSize() {
        Filter filter = Predicates.acceptAll();
        int count = this.getCatalog().count(StyleInfo.class, filter);
        return count;
    }

    public Iterator<StyleInfo> iterator(long first, long count) {
        try (CloseableIterator<StyleInfo> iterator = this.filteredItems((int)first, (int)count);){
            Iterator<StyleInfo> iterator2 = Lists.newArrayList(iterator).iterator();
            return iterator2;
        }
    }

    private CloseableIterator<StyleInfo> filteredItems(Integer first, Integer count) {
        Catalog catalog = this.getCatalog();
        SortParam sort = this.getSort();
        GeoServerDataProvider.Property property = this.getProperty(sort);
        SortBy sortOrder = null;
        if (sort != null && property instanceof GeoServerDataProvider.BeanProperty) {
            String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
            sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
        }
        Filter filter = this.getFilter();
        return catalog.list(StyleInfo.class, filter, first, count, sortOrder);
    }
}

