/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.WicketRuntimeException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geotools.util.Version;

public class StyleNewPage
extends AbstractStylePage {
    private static final long serialVersionUID = -6137191207739266238L;

    public StyleNewPage() {
        this.initUI(null);
        this.initPreviewLayer(null);
    }

    @Override
    protected void initUI(StyleInfo style) {
        List ws;
        super.initUI(style);
        if (!this.isAuthenticatedAsAdmin() && !(ws = this.getCatalog().getWorkspaces()).isEmpty()) {
            ((StyleInfo)this.styleModel.getObject()).setWorkspace((WorkspaceInfo)ws.get(0));
        }
    }

    @Override
    protected void onStyleFormSubmit() {
        Catalog catalog = this.getCatalog();
        StyleInfo model = (StyleInfo)this.styleForm.getModelObject();
        StyleInfo s = catalog.getFactory().createStyle();
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.updateStyle(s, model);
        StyleHandler styleHandler = this.styleHandler();
        if (null == s.getLegend() || null == s.getLegend().getOnlineResource() || s.getLegend().getOnlineResource().isEmpty()) {
            s.setLegend(null);
        }
        try {
            if (s.getFilename() == null) {
                s.setFilename(s.getName() + "." + styleHandler.getFileExtension());
            }
            catalog.getResourcePool().writeStyle(s, (InputStream)new ByteArrayInputStream(this.rawStyle.getBytes()));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        try {
            Version version = styleHandler.version((Object)this.rawStyle);
            s.setFormatVersion(version);
            catalog.add(s);
            this.styleForm.info((Serializable)((Object)"Style saved"));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred saving the style", e);
            this.error((Serializable)((Object)e.getMessage()));
            return;
        }
    }
}

