/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.StyleGenerator;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.StyleType;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.data.workspace.WorkspaceChoiceRenderer;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphicBuilder;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.ExternalGraphicPanel;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geoserver.wms.web.data.StyleEditTabPanel;
import org.geoserver.wms.web.data.StyleFormatsModel;
import org.geoserver.wms.web.data.StylePage;
import org.geoserver.wms.web.publish.StyleChoiceRenderer;
import org.geoserver.wms.web.publish.StyleTypeChoiceRenderer;
import org.geoserver.wms.web.publish.StyleTypeModel;
import org.geoserver.wms.web.publish.StylesModel;
import org.geotools.styling.Style;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

public class StyleAdminPanel
extends StyleEditTabPanel {
    private static final long serialVersionUID = -2443344473474977026L;
    private static final Logger LOGGER = Logging.getLogger(StyleAdminPanel.class);
    protected TextField<String> nameTextField;
    protected DropDownChoice<WorkspaceInfo> wsChoice;
    protected DropDownChoice<String> formatChoice;
    protected MarkupContainer formatReadOnlyMessage;
    protected WebMarkupContainer legendContainer;
    protected ExternalGraphicPanel legendPanel;
    protected Image legendImg;
    protected DropDownChoice<StyleType> templates;
    protected AjaxSubmitLink generateLink;
    protected DropDownChoice<StyleInfo> styles;
    protected AjaxSubmitLink copyLink;
    protected FileUploadField fileUploadField;
    protected AjaxSubmitLink uploadLink;
    transient BufferedImage legendImage;

    public StyleAdminPanel(String id, AbstractStylePage parent) {
        super(id, parent);
        this.initUI(parent.getStyleModel());
        if (this.stylePage instanceof StyleEditPage) {
            if (!this.stylePage.isAuthenticatedAsAdmin() && parent.getStyleInfo().getWorkspace() == null) {
                this.nameTextField.setEnabled(false);
                this.uploadLink.setEnabled(false);
            }
            if (StylePage.isDefaultStyle((CatalogInfo)this.getStylePage().getStyleInfo())) {
                this.nameTextField.setEnabled(false);
                this.wsChoice.setEnabled(false);
            }
            this.formatChoice.setEnabled(false);
            this.formatReadOnlyMessage.setVisible(true);
        }
    }

    public void initUI(CompoundPropertyModel<StyleInfo> styleModel) {
        final StyleInfo style = this.getStylePage().getStyleInfo();
        IModel nameBinding = styleModel.bind("name");
        Component[] componentArray = new Component[1];
        this.nameTextField = new TextField("name", nameBinding);
        componentArray[0] = this.nameTextField;
        this.add(componentArray);
        this.nameTextField.setRequired(true);
        IModel wsBinding = styleModel.bind("workspace");
        this.wsChoice = new Select2DropDownChoice("workspace", wsBinding, (IModel)new WorkspacesModel(), (IChoiceRenderer)new WorkspaceChoiceRenderer());
        this.wsChoice.setNullValid(true);
        if (!this.stylePage.isAuthenticatedAsAdmin()) {
            this.wsChoice.setNullValid(false);
            this.wsChoice.setRequired(true);
        }
        if (StylePage.isDefaultStyle((CatalogInfo)style)) {
            this.nameTextField.add((IValidator)new IValidator<String>(){
                String originalName;
                {
                    this.originalName = style.getName();
                }

                public void validate(IValidatable<String> validatable) {
                    if (this.originalName != null && !this.originalName.equals(validatable.getValue())) {
                        ValidationError error = new ValidationError();
                        error.setMessage("Can't change the name of default styles.");
                        error.addKey("editDefaultStyleNameDisallowed");
                        validatable.error((IValidationError)error);
                    }
                }
            });
            this.wsChoice.add((IValidator & Serializable)validatable -> {
                if (validatable.getValue() != null) {
                    ValidationError error = new ValidationError();
                    error.setMessage("Can't change the workspace of default styles.");
                    error.addKey("editDefaultStyleWorkspaceDisallowed");
                    validatable.error((IValidationError)error);
                }
            });
        }
        this.add(new Component[]{this.wsChoice});
        if (this.stylePage instanceof StyleEditPage && !this.stylePage.isAuthenticatedAsAdmin()) {
            this.wsChoice.setEnabled(false);
        }
        IModel formatBinding = styleModel.bind("format");
        this.formatChoice = new Select2DropDownChoice("format", formatBinding, (IModel)new StyleFormatsModel(), (IChoiceRenderer)new ChoiceRenderer<String>(){
            private static final long serialVersionUID = 2064887235303504013L;

            public String getIdValue(String object, int index) {
                return object;
            }

            public Object getDisplayValue(String object) {
                return Styles.handler((String)object).getName();
            }
        });
        this.formatChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -8372146231225388561L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.appendJavaScript((CharSequence)String.format("if (document.gsEditors) { document.gsEditors.editor.setOption('mode', '%s'); }", StyleAdminPanel.this.stylePage.styleHandler().getCodeMirrorEditMode()));
            }
        }});
        this.add(new Component[]{this.formatChoice});
        this.formatReadOnlyMessage = new WebMarkupContainer("formatReadOnly", (IModel)new Model());
        this.formatReadOnlyMessage.setVisible(false);
        this.add(new Component[]{this.formatReadOnlyMessage});
        this.legendPanel = new ExternalGraphicPanel("legendPanel", styleModel, this.stylePage.styleForm, this.getStylePage());
        this.legendPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.legendPanel});
        if (style.getId() != null) {
            try {
                this.stylePage.setRawStyle(this.stylePage.readFile(style));
            }
            catch (IOException e) {
                Session.get().error((Serializable)((Object)new ParamResourceModel("styleNotFound", (Component)this, new Object[]{style.getFilename()}).getString()));
            }
        }
        this.templates = new Select2DropDownChoice("templates", (IModel)new Model(), (IModel)new StyleTypeModel(), (IChoiceRenderer)new StyleTypeChoiceRenderer());
        this.templates.setOutputMarkupId(true);
        this.templates.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -6649152103570059645L;

            protected void onUpdate(AjaxRequestTarget target) {
                StyleAdminPanel.this.templates.validate();
                StyleAdminPanel.this.generateLink.setEnabled(StyleAdminPanel.this.templates.getConvertedInput() != null);
                target.add(new Component[]{StyleAdminPanel.this.generateLink});
            }
        }});
        this.add(new Component[]{this.templates});
        this.generateLink = this.generateLink();
        this.generateLink.setEnabled(false);
        this.add(new Component[]{this.generateLink});
        this.styles = new Select2DropDownChoice("existingStyles", (IModel)new Model(), (IModel)new StylesModel(), (IChoiceRenderer)new StyleChoiceRenderer());
        this.styles.setOutputMarkupId(true);
        this.styles.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 8098121930876372129L;

            protected void onUpdate(AjaxRequestTarget target) {
                StyleAdminPanel.this.styles.validate();
                StyleAdminPanel.this.copyLink.setEnabled(StyleAdminPanel.this.styles.getConvertedInput() != null);
                target.add(new Component[]{StyleAdminPanel.this.copyLink});
            }
        }});
        this.add(new Component[]{this.styles});
        this.copyLink = this.copyLink();
        this.copyLink.setEnabled(false);
        this.add(new Component[]{this.copyLink});
        this.uploadLink = this.uploadLink();
        this.add(new Component[]{this.uploadLink});
        this.fileUploadField = new FileUploadField("filename");
        this.fileUploadField.setDefaultModel((IModel)new Model((Serializable)((Object)"")));
        this.add(new Component[]{this.fileUploadField});
        this.add(new Component[]{this.previewLink()});
        this.legendContainer = new WebMarkupContainer("legendContainer");
        this.legendContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.legendContainer});
        this.legendImg = new Image("legendImg", (IResource)new AbstractResource(){
            private static final long serialVersionUID = -6932528694575832606L;

            protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
                AbstractResource.ResourceResponse rr = new AbstractResource.ResourceResponse();
                rr.setContentType("image/png");
                rr.setWriteCallback(new AbstractResource.WriteCallback(){

                    public void writeData(IResource.Attributes attributes) throws IOException {
                        ImageIO.write((RenderedImage)StyleAdminPanel.this.legendImage, "PNG", attributes.getResponse().getOutputStream());
                    }
                });
                return rr;
            }
        }, new IResource[0]);
        this.legendContainer.add(new Component[]{this.legendImg});
        this.legendImg.setVisible(false);
        this.legendImg.setOutputMarkupId(true);
    }

    protected void clearFeedbackMessages() {
        this.nameTextField.getFeedbackMessages().clear();
        this.wsChoice.getFeedbackMessages().clear();
        this.formatChoice.getFeedbackMessages().clear();
        this.stylePage.editor.getFeedbackMessages().clear();
    }

    protected Component previewLink() {
        return new GeoServerAjaxFormLink("preview", this.stylePage.styleForm){
            private static final long serialVersionUID = 7404304424029960594L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                StyleAdminPanel.this.stylePage.editor.processInput();
                StyleAdminPanel.this.wsChoice.processInput();
                StyleAdminPanel.this.clearFeedbackMessages();
                StyleAdminPanel.this.legendImg.setVisible(false);
                URLConnection conn = StyleAdminPanel.this.legendPanel.getExternalGraphic(target, form);
                String onlineResource = StyleAdminPanel.this.legendPanel.getOnlineResource();
                if (onlineResource != null && !onlineResource.isEmpty()) {
                    if (conn != null) {
                        try {
                            StyleAdminPanel.this.legendImage = ImageIO.read(conn.getInputStream());
                            StyleAdminPanel.this.legendImg.setVisible(true);
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Failed to render external legend graphic", e);
                            StyleAdminPanel.this.legendContainer.error((Serializable)((Object)"Failed to render external legend graphic"));
                        }
                    }
                } else {
                    GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerExtensions.bean(GeoServerDataDirectory.class, (ApplicationContext)StyleAdminPanel.this.stylePage.getGeoServerApplication().getApplicationContext());
                    StyleInfoImpl si = new StyleInfoImpl(StyleAdminPanel.this.stylePage.getCatalog());
                    String format = StyleAdminPanel.this.stylePage.getStyleInfo().getFormat();
                    si.setFormat(format);
                    String styleName = "tmp" + UUID.randomUUID().toString();
                    String styleFileName = styleName + '.' + Styles.handler((String)si.getFormat()).getFileExtension();
                    si.setFilename(styleFileName);
                    si.setName(styleName);
                    si.setWorkspace(((StyleInfo)StyleAdminPanel.this.stylePage.styleModel.getObject()).getWorkspace());
                    Resource styleResource = null;
                    try {
                        styleResource = dd.style((StyleInfo)si);
                        try (OutputStream os = styleResource.out();){
                            IOUtils.write((String)StyleAdminPanel.this.stylePage.editor.getInput(), (OutputStream)os, (String)"UTF-8");
                        }
                        Version version = Styles.handler((String)format).version((Object)StyleAdminPanel.this.stylePage.editor.getInput());
                        si.setFormatVersion(version);
                        Style style = dd.parsedStyle((StyleInfo)si);
                        if (style != null) {
                            GetLegendGraphicRequest request = new GetLegendGraphicRequest();
                            request.setLayer(null);
                            request.setStyle(style);
                            request.setStrict(false);
                            HashMap<String, String> legendOptions = new HashMap<String, String>();
                            legendOptions.put("forceLabels", "on");
                            legendOptions.put("fontAntiAliasing", "true");
                            request.setLegendOptions(legendOptions);
                            BufferedImageLegendGraphicBuilder builder = new BufferedImageLegendGraphicBuilder();
                            StyleAdminPanel.this.legendImage = builder.buildLegendGraphic(request);
                            StyleAdminPanel.this.legendImg.setVisible(true);
                        }
                    }
                    catch (IOException e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                    catch (Exception e) {
                        StyleAdminPanel.this.legendImg.setVisible(false);
                        StyleAdminPanel.this.legendContainer.error((Serializable)((Object)"Failed to build legend preview. Check to see if the style is valid."));
                        LOGGER.log(Level.WARNING, "Failed to build legend preview", e);
                    }
                    finally {
                        if (styleResource != null) {
                            styleResource.delete();
                        }
                    }
                }
                target.add(new Component[]{StyleAdminPanel.this.legendContainer});
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(StyleAdminPanel.this.stylePage.editor.getSaveDecorator());
            }
        };
    }

    protected AjaxSubmitLink generateLink() {
        return new ConfirmOverwriteSubmitLink("generate"){
            private static final long serialVersionUID = 55921414750155395L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                StyleAdminPanel.this.templates.processInput();
                StyleAdminPanel.this.nameTextField.processInput();
                StyleAdminPanel.this.wsChoice.processInput();
                StyleType template = (StyleType)StyleAdminPanel.this.templates.getConvertedInput();
                StyleGenerator styleGen = new StyleGenerator(StyleAdminPanel.this.stylePage.getCatalog());
                styleGen.setWorkspace(StyleAdminPanel.this.getStylePage().getStyleInfo().getWorkspace());
                if (template != null) {
                    try {
                        StyleAdminPanel.this.stylePage.editor.reset();
                        StyleAdminPanel.this.stylePage.setRawStyle(new StringReader(styleGen.generateStyle(StyleAdminPanel.this.stylePage.styleHandler(), template, StyleAdminPanel.this.getStylePage().getStyleInfo().getName())));
                        target.appendJavaScript((CharSequence)String.format("if (document.gsEditors) { document.gsEditors.editor.setOption('mode', '%s'); }", StyleAdminPanel.this.stylePage.styleHandler().getCodeMirrorEditMode()));
                        StyleAdminPanel.this.clearFeedbackMessages();
                    }
                    catch (Exception e) {
                        StyleAdminPanel.this.clearFeedbackMessages();
                        StyleAdminPanel.this.stylePage.editor.getFeedbackMessages().clear();
                        StyleAdminPanel.this.stylePage.error((Serializable)((Object)"Errors occurred generating the style"));
                        LOGGER.log(Level.WARNING, "Errors occured generating the style", e);
                    }
                    target.add(new Component[]{StyleAdminPanel.this.stylePage});
                }
            }
        };
    }

    protected AjaxSubmitLink copyLink() {
        return new ConfirmOverwriteSubmitLink("copy"){
            private static final long serialVersionUID = -6388040033082157163L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                StyleAdminPanel.this.styles.processInput();
                StyleInfo style = (StyleInfo)StyleAdminPanel.this.styles.getConvertedInput();
                if (style != null) {
                    try {
                        StyleAdminPanel.this.stylePage.editor.reset();
                        StyleAdminPanel.this.stylePage.setRawStyle(StyleAdminPanel.this.stylePage.readFile(style));
                        if (StyleAdminPanel.this.formatChoice.isEnabled()) {
                            StyleAdminPanel.this.formatChoice.setModelObject((Object)style.getFormat());
                        }
                        target.appendJavaScript((CharSequence)String.format("if (document.gsEditors) { document.gsEditors.editor.setOption('mode', '%s'); }", StyleAdminPanel.this.stylePage.styleHandler().getCodeMirrorEditMode()));
                        StyleAdminPanel.this.clearFeedbackMessages();
                    }
                    catch (Exception e) {
                        StyleAdminPanel.this.clearFeedbackMessages();
                        StyleAdminPanel.this.stylePage.error((Serializable)((Object)("Errors occurred loading the '" + style.getName() + "' style")));
                        LOGGER.log(Level.WARNING, "Errors occurred loading the '" + style.getName() + "' style", e);
                    }
                    target.add(new Component[]{StyleAdminPanel.this.stylePage});
                }
            }
        };
    }

    AjaxSubmitLink uploadLink() {
        return new ConfirmOverwriteSubmitLink("upload", (Form)this.stylePage.styleForm){
            private static final long serialVersionUID = 658341311654601761L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                FileUpload upload = StyleAdminPanel.this.fileUploadField.getFileUpload();
                if (upload == null) {
                    this.warn((Serializable)((Object)"No file selected."));
                    return;
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)upload.getInputStream(), (OutputStream)bout);
                    StyleAdminPanel.this.stylePage.editor.reset();
                    StyleAdminPanel.this.stylePage.setRawStyle(new InputStreamReader((InputStream)new ByteArrayInputStream(bout.toByteArray()), StandardCharsets.UTF_8));
                    target.appendJavaScript((CharSequence)String.format("if (document.gsEditors) { document.gsEditors.editor.setOption('mode', '%s'); }", StyleAdminPanel.this.stylePage.styleHandler().getCodeMirrorEditMode()));
                    StyleAdminPanel.this.clearFeedbackMessages();
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                catch (Exception e) {
                    StyleAdminPanel.this.clearFeedbackMessages();
                    StyleAdminPanel.this.stylePage.error((Serializable)((Object)("Errors occurred uploading the '" + upload.getClientFileName() + "' style")));
                    LOGGER.log(Level.WARNING, "Errors occurred uploading the '" + upload.getClientFileName() + "' style", e);
                }
                StyleInfo s = StyleAdminPanel.this.getStylePage().getStyleInfo();
                if (s.getName() == null || "".equals(s.getName().trim())) {
                    StyleAdminPanel.this.nameTextField.setModelValue(new String[]{ResponseUtils.stripExtension((String)upload.getClientFileName())});
                    StyleAdminPanel.this.nameTextField.modelChanged();
                }
                target.add(new Component[]{StyleAdminPanel.this.stylePage});
            }
        };
    }

    class ConfirmOverwriteSubmitLink
    extends AjaxSubmitLink {
        private static final long serialVersionUID = 2673499149884774636L;

        public ConfirmOverwriteSubmitLink(String id) {
            super(id);
        }

        public ConfirmOverwriteSubmitLink(String id, Form<?> form) {
            super(id, form);
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.getAjaxCallListeners().add(new AjaxCallListener(){
                private static final long serialVersionUID = 8637613472102572505L;

                public CharSequence getPrecondition(Component component) {
                    CharSequence message = new ParamResourceModel("confirmOverwrite", (Component)StyleAdminPanel.this.stylePage, new Object[0]).getString();
                    message = JavaScriptUtils.escapeQuotes((CharSequence)message);
                    return "var val = attrs.event.view.document.gsEditors ? attrs.event.view.document.gsEditors." + StyleAdminPanel.this.stylePage.editor.getTextAreaMarkupId() + ".getValue() : attrs.event.view.document.getElementById(\"" + StyleAdminPanel.this.stylePage.editor.getTextAreaMarkupId() + "\").value; if(val != '' &&!confirm('" + message + "')) return false;";
                }
            });
        }

        public boolean getDefaultFormProcessing() {
            return false;
        }
    }
}

