/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssUrlReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptUrlReferenceHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.template.TemplateUtils;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.LayerChooser;
import org.geoserver.wms.web.data.StyleEditTabPanel;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;

public class OpenLayersPreviewPanel
extends StyleEditTabPanel
implements IHeaderContributor {
    private static final long serialVersionUID = -8742721113748106000L;
    static final Logger LOGGER = Logging.getLogger(OpenLayersPreviewPanel.class);
    static final Configuration templates = TemplateUtils.getSafeConfiguration();
    final Random rand = new Random();
    final Component olPreview = new WebMarkupContainer("olPreview").setOutputMarkupId(true);
    boolean isPreviewStyleGroup;
    GeoServerDialog dialog;

    public OpenLayersPreviewPanel(String id, final AbstractStylePage parent) {
        super(id, parent);
        PropertyModel layerNameModel = new PropertyModel(parent.getLayerModel(), "prefixedName");
        this.add(new Component[]{new SimpleAjaxLink<String>("change.layer", (IModel)layerNameModel){
            private static final long serialVersionUID = 7341058018479354596L;

            public void onClick(AjaxRequestTarget target) {
                ModalWindow popup = parent.getPopup();
                popup.setInitialHeight(400);
                popup.setInitialWidth(600);
                popup.setTitle((IModel)new Model((Serializable)((Object)"Choose layer to preview")));
                popup.setContent((Component)new LayerChooser(popup.getContentId(), parent));
                popup.show((IPartialPageRequestHandler)target);
            }
        }});
        this.add(new Component[]{this.olPreview});
        this.olPreview.setMarkupId("olPreview");
        this.setOutputMarkupId(true);
        CheckBox previewStyleGroup = new CheckBox("previewStyleGroup", (IModel)new PropertyModel((Object)this, "isPreviewStyleGroup"));
        previewStyleGroup.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){

            protected void onUpdate(AjaxRequestTarget target) {
                parent.configurationChanged();
                parent.addFeedbackPanels(target);
                target.add(new Component[]{parent.styleForm});
            }
        }});
        this.add(new Component[]{previewStyleGroup});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.add(new Component[]{new HelpLink("styleGroupHelp").setDialog(this.dialog)});
        try {
            this.ensureLegendDecoration();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to put legend layout file in the data directory, the legend decoration will not appear", e);
        }
    }

    private void ensureLegendDecoration() throws IOException {
        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerApplication.get().getBeanOfType(GeoServerDataDirectory.class);
        Resource layouts = dd.get(new String[]{"layouts"});
        Resource legend = layouts.get("style-editor-legend.xml");
        if (!Resources.exists((Resource)legend)) {
            String legendLayout = IOUtils.toString((InputStream)OpenLayersPreviewPanel.class.getResourceAsStream("style-editor-legend.xml"), (Charset)StandardCharsets.UTF_8);
            try (OutputStream os = legend.out();){
                IOUtils.write((String)legendLayout, (OutputStream)os, (String)"UTF-8");
            }
        }
    }

    public void renderHead(IHeaderResponse header) {
        super.renderHead(header);
        try {
            this.renderHeaderCss(header);
            this.renderHeaderScript(header);
        }
        catch (TemplateException | IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    private void renderHeaderCss(IHeaderResponse header) throws IOException, TemplateException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("id", this.olPreview.getMarkupId());
        Template template = templates.getTemplate("ol-style.ftl");
        StringWriter css = new StringWriter();
        template.process(context, (Writer)css);
        header.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)css.toString(), null));
    }

    private void renderHeaderScript(IHeaderResponse header) throws IOException, TemplateException {
        String styleUrl;
        HashMap<String, Object> context = new HashMap<String, Object>();
        ReferencedEnvelope bbox = this.getStylePage().getLayerInfo().getResource().getLatLonBoundingBox();
        WorkspaceInfo workspace = this.getStylePage().getStyleInfo().getWorkspace();
        context.put("minx", bbox.getMinX());
        context.put("miny", bbox.getMinY());
        context.put("maxx", bbox.getMaxX());
        context.put("maxy", bbox.getMaxY());
        context.put("id", this.olPreview.getMarkupId());
        context.put("layer", this.getStylePage().getLayerInfo().prefixedName());
        context.put("style", this.getStylePage().getStyleInfo().prefixedName());
        String proxyBaseUrl = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL");
        if (StringUtils.isEmpty((CharSequence)proxyBaseUrl)) {
            GeoServer gs = this.stylePage.getGeoServer();
            proxyBaseUrl = gs.getGlobal().getSettings().getProxyBaseUrl();
            if (StringUtils.isEmpty((CharSequence)proxyBaseUrl)) {
                Request r = this.getRequest();
                Url clientUrl = r.getClientUrl();
                styleUrl = clientUrl.getProtocol() + "://" + clientUrl.getHost() + ":" + clientUrl.getPort() + r.getContextPath();
            } else {
                styleUrl = proxyBaseUrl;
            }
        } else {
            styleUrl = proxyBaseUrl;
        }
        styleUrl = styleUrl + "/styles";
        if (workspace != null) {
            context.put("styleWorkspace", workspace.getName());
            styleUrl = styleUrl + "/" + workspace.getName();
        }
        String styleFile = this.getStylePage().getStyleInfo().getFilename();
        styleFile = styleFile.substring(0, styleFile.lastIndexOf(".")) + ".sld";
        styleUrl = styleUrl + "/" + styleFile;
        context.put("styleUrl", styleUrl);
        context.put("previewStyleGroup", this.isPreviewStyleGroup);
        context.put("cachebuster", this.rand.nextInt());
        context.put("resolution", Math.max(bbox.getSpan(0), bbox.getSpan(1)) / 256.0);
        HttpServletRequest req = GeoServerApplication.get().servletRequest();
        String base = ResponseUtils.baseURL((HttpServletRequest)req);
        String baseUrl = ResponseUtils.buildURL((String)base, (String)"/", null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
        context.put("baseUrl", this.canonicUrl(baseUrl));
        Template template = templates.getTemplate("ol-load.ftl");
        StringWriter script = new StringWriter();
        template.process(context, (Writer)script);
        header.render((HeaderItem)new CssUrlReferenceHeaderItem(ResponseUtils.buildURL((String)base, (String)"/openlayers3/ol.css", null, (URLMangler.URLType)URLMangler.URLType.RESOURCE), null, null));
        header.render((HeaderItem)new JavaScriptUrlReferenceHeaderItem(ResponseUtils.buildURL((String)base, (String)"/openlayers3/ol.js", null, (URLMangler.URLType)URLMangler.URLType.RESOURCE), null, false, "UTF-8", null));
        header.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)script.toString()));
    }

    private String canonicUrl(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    public String getUpdateCommand() throws IOException, TemplateException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("id", this.olPreview.getMarkupId());
        context.put("cachebuster", this.rand.nextInt());
        Template template = templates.getTemplate("ol-update.ftl");
        StringWriter script = new StringWriter();
        template.process(context, (Writer)script);
        return script.toString();
    }

    static {
        templates.setClassForTemplateLoading(OpenLayersPreviewPanel.class, "");
        templates.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(TemplateUtils.FM_VERSION));
    }
}

