/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.wms.web.data.AbstractStylePage;

public class LayerChooser
extends Panel {
    private static final long serialVersionUID = -127345071729297975L;

    public LayerChooser(String id, final AbstractStylePage parent) {
        super(id);
        LayerProvider provider = new LayerProvider(parent);
        GeoServerTablePanel<LayerInfo> table = new GeoServerTablePanel<LayerInfo>("layer.table", (GeoServerDataProvider)provider){
            private static final long serialVersionUID = 1196129584558094662L;

            public Component getComponentForProperty(String id, IModel<LayerInfo> value, GeoServerDataProvider.Property<LayerInfo> property) {
                final LayerInfo layer = (LayerInfo)value.getObject();
                final String text = property.getPropertyValue((Object)layer).toString();
                if (property == LayerProvider.name) {
                    return new Fragment(id, "layer.link", (MarkupContainer)LayerChooser.this){
                        private static final long serialVersionUID = -7619814477490657757L;
                        {
                            super(x0, x1, x2);
                            this.add(new Component[]{new GeoServerAjaxFormLink("link", parent.styleForm){
                                private static final long serialVersionUID = 8020574396677784792L;
                                {
                                    this.add(new Component[]{new Label("layer.name", (IModel)new Model((Serializable)((Object)text)))});
                                }

                                protected void onClick(AjaxRequestTarget target, Form<?> form) {
                                    parent.getLayerModel().setObject((Object)layer);
                                    parent.getPopup().close((IPartialPageRequestHandler)target);
                                    parent.configurationChanged();
                                    parent.addFeedbackPanels(target);
                                    target.add(new Component[]{parent.styleForm});
                                }

                                public boolean getDefaultFormProcessing() {
                                    return false;
                                }
                            }});
                        }
                    };
                }
                return new Label(id, (Serializable)((Object)text));
            }
        };
        this.add(new Component[]{table});
    }

    private static class LayerProvider
    extends GeoServerDataProvider<LayerInfo> {
        private static final long serialVersionUID = -2117784735301652240L;
        private AbstractStylePage parent;
        public static GeoServerDataProvider.Property<LayerInfo> workspace = new GeoServerDataProvider.AbstractProperty<LayerInfo>("Workspace"){
            private static final long serialVersionUID = -7055816211775541759L;

            public Object getPropertyValue(LayerInfo x) {
                return x.getResource().getStore().getWorkspace().getName();
            }
        };
        public static GeoServerDataProvider.Property<LayerInfo> store = new GeoServerDataProvider.AbstractProperty<LayerInfo>("Store"){
            private static final long serialVersionUID = -4021230907568644439L;

            public Object getPropertyValue(LayerInfo x) {
                return x.getResource().getStore().getName();
            }
        };
        public static GeoServerDataProvider.Property<LayerInfo> name = new GeoServerDataProvider.AbstractProperty<LayerInfo>("Layer"){
            private static final long serialVersionUID = 8913729089849537790L;

            public Object getPropertyValue(LayerInfo x) {
                return x.getName();
            }
        };

        public LayerProvider(AbstractStylePage parent) {
            this.parent = parent;
        }

        public List<LayerInfo> getItems() {
            ArrayList<LayerInfo> items = new ArrayList<LayerInfo>();
            for (LayerInfo l : this.parent.getCatalog().getLayers()) {
                if (l.getResource() instanceof FeatureTypeInfo) {
                    items.add(l);
                }
                if (!(l.getResource() instanceof CoverageInfo)) continue;
                items.add(l);
            }
            return items;
        }

        public List<GeoServerDataProvider.Property<LayerInfo>> getProperties() {
            return Arrays.asList(workspace, store, name);
        }
    }
}

