/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WebMapService;
import org.geotools.util.logging.Logging;

public class WMSServiceDescriptionProvider
extends ServiceDescriptionProvider {
    static final Logger LOGGER = Logging.getLogger(WMSServiceDescriptionProvider.class);
    public static final String SERVICE_TYPE = "WMS";
    GeoServer geoserver;
    Catalog catalog;

    public WMSServiceDescriptionProvider(GeoServer gs) {
        this.geoserver = gs;
        this.catalog = gs.getCatalog();
    }

    protected WMSInfo info(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        WMSInfo info = null;
        if (workspaceInfo != null) {
            info = (WMSInfo)this.geoserver.getService(workspaceInfo, WMSInfo.class);
        }
        if (info == null) {
            info = (WMSInfo)this.geoserver.getService(WMSInfo.class);
        }
        return info;
    }

    public List<ServiceDescription> getServices(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceDescription> descriptions = new ArrayList<ServiceDescription>();
        WMSInfo info = this.info(workspaceInfo, layerInfo);
        if (workspaceInfo != null || this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            descriptions.add(this.description(SERVICE_TYPE, (ServiceInfo)info, workspaceInfo, layerInfo));
        }
        return descriptions;
    }

    public List<ServiceLinkDescription> getServiceLinks(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceLinkDescription> links = new ArrayList<ServiceLinkDescription>();
        if (workspaceInfo == null && !this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            return links;
        }
        List extensions = GeoServerExtensions.extensions(Service.class);
        for (Service service : extensions) {
            if (!(service.getService() instanceof WebMapService)) continue;
            String link = null;
            if (service.getOperations().contains("GetCapabilities")) {
                link = this.getCapabilitiesURL(workspaceInfo, layerInfo, service);
            } else if (service.getCustomCapabilitiesLink() != null) {
                link = service.getCustomCapabilitiesLink();
            }
            if (link == null) continue;
            links.add(new ServiceLinkDescription(SERVICE_TYPE, service.getVersion(), link, workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null));
        }
        return links;
    }
}

