/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;

public class LoggingContextListener
implements ServletContextListener {
    private static Logger LOGGER;
    public static final String LOGGER_POLICY = "org.geowebcache.util.logging.policy";

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        String policyName = LoggingContextListener.getProperty(context, LOGGER_POLICY, "Log4J2");
        Policy policy = Policy.find(policyName);
        if (policy != Policy.PROVIDED) {
            Throwable troubleSettingUpLogging = null;
            try {
                if (Logging.ALL.getLoggerFactory() == null) {
                    Logging.ALL.setLoggerFactory(policy.getFactoryName());
                }
            }
            catch (Throwable trouble) {
                troubleSettingUpLogging = trouble;
            }
            this.log().config("GeoWebCache Logger:" + this.log());
            if (troubleSettingUpLogging != null) {
                this.log().log(Level.WARNING, "Unable to use org.geowebcache.util.logging.policy property '" + (Object)((Object)policy) + "' to configure logging:" + troubleSettingUpLogging, troubleSettingUpLogging);
            }
        }
        LoggerFactory loggerFactory = Logging.getLogging((String)LoggingContextListener.class.getName()).getLoggerFactory();
        if (this.log().isLoggable(Level.CONFIG)) {
            if (loggerFactory != null) {
                String config = loggerFactory.lookupConfiguration();
                this.log().config(loggerFactory.getClass().getSimpleName() + " config: " + config);
            } else {
                this.log().config("java.util.logging config: " + this.julLoggingConfiguration());
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        GeoTools.setLoggerFactory(null);
        if (LOGGER != null) {
            LOGGER = null;
        }
    }

    public static String getProperty(ServletContext context, String name) {
        return LoggingContextListener.getProperty(context, name, null);
    }

    public static String getProperty(ServletContext context, String name, String defaultProperty) {
        String variable;
        String parameter;
        String property;
        if (name == null) {
            return null;
        }
        if (System.getProperties().containsKey(name) && (property = System.getProperty(name)) != null && !property.isEmpty()) {
            return property;
        }
        if (context != null && (parameter = context.getInitParameter(name)) != null && !parameter.isEmpty()) {
            return parameter;
        }
        if (System.getenv().containsKey(name) && (variable = System.getenv(name)) != null && !variable.isEmpty()) {
            return variable;
        }
        return defaultProperty;
    }

    String julLoggingConfiguration() {
        String configClass = System.getProperty("java.util.logging.config.class");
        String configFile = System.getProperty("java.util.logging.config.file");
        String javaHome = System.getProperty("java.home");
        if (configClass != null) {
            return configClass;
        }
        if (configFile != null) {
            return configFile;
        }
        if (javaHome != null) {
            return javaHome + "/lib/logging.properties";
        }
        return "java.util.logging";
    }

    private Logger log() {
        if (LOGGER == null) {
            LOGGER = Logging.getLogger((String)LoggingContextListener.class.getName());
        }
        return LOGGER;
    }

    public static enum Policy {
        LOG4J2("org.geotools.util.logging.Log4J2LoggerFactory"),
        LOG4J1("org.geotools.util.logging.Log4JLoggerFactory"),
        LOGBACK("org.geotools.util.logging.LogbackLoggerFactory"),
        COMMONSLOGGING("org.geotools.util.logging.CommonsLoggerFactory"),
        JAVALOGGING(null),
        PROVIDED("Provided");

        private final String factoryName;

        private Policy(String factoryName) {
            this.factoryName = factoryName;
        }

        public static Policy find(String policyName) {
            if (policyName == null) {
                return null;
            }
            for (Policy policy : Policy.values()) {
                if (!policy.name().equalsIgnoreCase(policyName)) continue;
                return policy;
            }
            return null;
        }

        public String getFactoryName() {
            return this.factoryName;
        }
    }
}

