/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

public class ApplicationContextProvider
implements ApplicationContextAware {
    private static Logger log = Logging.getLogger((String)ApplicationContextProvider.class.toString());
    WebApplicationContext ctx;

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = (WebApplicationContext)arg0;
    }

    public WebApplicationContext getApplicationContext() {
        return this.ctx;
    }

    public String getSystemVar(String varName, String defaultValue) {
        if (this.ctx == null) {
            String msg = "Application context was not set yet! Damn you Spring Framework :( ";
            log.log(Level.SEVERE, msg);
            throw new RuntimeException(msg);
        }
        String tmpVar = Optional.ofNullable(this.ctx.getServletContext()).map(sc -> sc.getInitParameter(varName)).orElse(null);
        if (tmpVar != null && tmpVar.length() > 7) {
            log.info("Using servlet init context parameter to configure " + varName + " to " + tmpVar);
            return tmpVar;
        }
        tmpVar = System.getProperty(varName);
        if (tmpVar != null && tmpVar.length() > 7) {
            log.info("Using Java environment variable to configure " + varName + " to " + tmpVar);
            return tmpVar;
        }
        tmpVar = System.getenv(varName);
        if (tmpVar != null && tmpVar.length() > 7) {
            log.info("Using System environment variable to configure " + varName + " to " + tmpVar);
            return tmpVar;
        }
        log.info("No context parameter, system or Java environment variables found for " + varName);
        log.info("Reverting to " + defaultValue);
        return defaultValue;
    }
}

