/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TransientCache;

public class DefaultStorageBroker
implements StorageBroker {
    private static Logger log = Logging.getLogger((String)DefaultStorageBroker.class.getName());
    private BlobStore blobStore;
    private TransientCache transientCache;

    public DefaultStorageBroker(BlobStore blobStore, TransientCache transientCache) {
        this.blobStore = blobStore;
        this.transientCache = transientCache;
    }

    @Override
    public void addBlobStoreListener(BlobStoreListener listener) {
        this.blobStore.addListener(listener);
    }

    @Override
    public boolean removeBlobStoreListener(BlobStoreListener listener) {
        return this.blobStore.removeListener(listener);
    }

    @Override
    public boolean delete(String layerName) throws StorageException {
        return this.blobStore.delete(layerName);
    }

    @Override
    public boolean deleteByGridSetId(String layerName, String gridSetId) throws StorageException {
        return this.blobStore.deleteByGridsetId(layerName, gridSetId);
    }

    @Override
    public boolean deleteByParameters(String layerName, Map<String, String> parameters) throws StorageException {
        return this.blobStore.deleteByParameters(layerName, parameters);
    }

    @Override
    public boolean deleteByParametersId(String layerName, String parametersId) throws StorageException {
        return this.blobStore.deleteByParametersId(layerName, parametersId);
    }

    @Override
    public boolean purgeOrphans(TileLayer layer) throws StorageException {
        return this.blobStore.purgeOrphans(layer);
    }

    @Override
    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        return this.blobStore.rename(oldLayerName, newLayerName);
    }

    @Override
    public boolean delete(TileRange trObj) throws StorageException {
        return this.blobStore.delete(trObj);
    }

    @Override
    public boolean get(TileObject tileObj) throws StorageException {
        return this.blobStore.get(tileObj);
    }

    @Override
    public boolean put(TileObject tileObj) throws StorageException {
        this.blobStore.put(tileObj);
        return true;
    }

    @Override
    public void destroy() {
        log.fine("Destroying StorageBroker");
    }

    @Override
    public String getLayerMetadata(String layerName, String key) {
        return this.blobStore.getLayerMetadata(layerName, key);
    }

    @Override
    public void putLayerMetadata(String layerName, String key, String value) {
        this.blobStore.putLayerMetadata(layerName, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getTransient(TileObject tile) {
        Resource resource;
        String key = TransientCache.computeTransientKey(tile);
        TransientCache transientCache = this.transientCache;
        synchronized (transientCache) {
            resource = this.transientCache.get(key);
        }
        tile.setBlob(resource);
        return resource != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putTransient(TileObject tile) {
        String key = TransientCache.computeTransientKey(tile);
        TransientCache transientCache = this.transientCache;
        synchronized (transientCache) {
            this.transientCache.put(key, tile.getBlob());
        }
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    @Override
    public Set<String> getCachedParameterIds(String layerName) throws StorageException {
        return this.blobStore.getParameterIds(layerName);
    }

    @Override
    public Set<Map<String, String>> getCachedParameters(String layerName) throws StorageException {
        return this.blobStore.getParameters(layerName);
    }
}

