/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import com.google.common.base.Optional;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.UncheckedGeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.MassTruncateRequest;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;

@XStreamAlias(value="truncateExtent")
public class TruncateBboxRequest
implements MassTruncateRequest {
    String layerName;
    private BoundingBox bounds;
    private String gridSetId;

    public TruncateBboxRequest(String layerName, BoundingBox bounds, String gridSetId) {
        this.layerName = layerName;
        this.bounds = bounds;
        this.gridSetId = gridSetId;
    }

    @Override
    public boolean doTruncate(StorageBroker sb, TileBreeder breeder) throws StorageException, GeoWebCacheException {
        Set<Map<String, String>> allParams = sb.getCachedParameters(this.layerName);
        TileLayer tileLayer = breeder.findTileLayer(this.layerName);
        List<MimeType> allFormats = tileLayer.getMimeTypes();
        GridSubset subSet = tileLayer.getGridSubset(this.gridSetId);
        int minZ = (Integer)Optional.fromNullable((Object)subSet.getMinCachedZoom()).or((Object)subSet.getZoomStart());
        int maxZ = (Integer)Optional.fromNullable((Object)subSet.getMaxCachedZoom()).or((Object)subSet.getZoomStop());
        Function<Map, Stream> seedRequestMapper = params -> allFormats.stream().map(format -> new SeedRequest(this.layerName, this.bounds, this.gridSetId, 1, minZ, maxZ, format.getMimeType(), GWCTask.TYPE.TRUNCATE, (Map<String, String>)params));
        try {
            int taskCount = Stream.concat(allParams.stream(), Stream.of((Map)null)).flatMap(seedRequestMapper).map(request -> {
                try {
                    breeder.seed(this.layerName, (SeedRequest)request);
                    return 1;
                }
                catch (GeoWebCacheException e) {
                    throw new UncheckedGeoWebCacheException(e);
                }
            }).reduce((x, y) -> x + y).orElse(0);
            return taskCount > 0;
        }
        catch (UncheckedGeoWebCacheException e) {
            throw e.getCause();
        }
    }
}

