/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.Serializable;
import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.seed.MassTruncateRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.util.ServletUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

@XStreamAlias(value="truncateAll")
public class TruncateAllRequest
implements MassTruncateRequest,
Serializable {
    private static final long serialVersionUID = -4730372010898498464L;
    private static final Logger log = Logging.getLogger((String)TruncateAllRequest.class.getName());
    @XStreamOmitField
    private StringBuilder trucatedLayers = new StringBuilder();

    @Override
    public boolean doTruncate(StorageBroker sb, TileBreeder breeder) throws StorageException, GeoWebCacheException {
        Iterator<TileLayer> iterator = breeder.getLayers().iterator();
        String gridSetId2 = "";
        boolean truncated = false;
        while (iterator.hasNext()) {
            TileLayer toTruncate = iterator.next();
            for (String gridSetId2 : toTruncate.getGridSubsets()) {
                truncated = sb.deleteByGridSetId(toTruncate.getName(), gridSetId2);
                log.info("Layer: " + toTruncate.getName() + ",Truncated Gridset :" + gridSetId2);
            }
            if (!truncated) continue;
            if (this.getTrucatedLayers().length() > 0) {
                this.trucatedLayers.append(",");
            }
            this.getTrucatedLayers().append(toTruncate.getName());
        }
        return true;
    }

    @Override
    public ResponseEntity<String> getResponse(String contentType) {
        if (contentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            return new ResponseEntity((Object)this.getResponsePage().toString(), HttpStatus.OK);
        }
        return MassTruncateRequest.super.getResponse(contentType);
    }

    public StringBuilder getTrucatedLayers() {
        if (this.trucatedLayers == null) {
            this.trucatedLayers = new StringBuilder();
        }
        return this.trucatedLayers;
    }

    public String getTrucatedLayersList() {
        if (this.getTrucatedLayers().length() == 0) {
            return "No Layers were truncated";
        }
        return this.getTrucatedLayers().toString();
    }

    private StringBuilder getResponsePage() {
        StringBuilder doc = new StringBuilder();
        String content = "<p>Truncated All Layers</p>\n<p>Truncated Layers:" + this.getTrucatedLayersList().toString() + "</p>";
        doc.append("<html>\n" + ServletUtils.gwcHtmlHeader("../", "GWC Seed Form") + "<body>\n" + ServletUtils.gwcHtmlLogoLink("../"));
        doc.append("<p>" + content + "</p> ");
        doc.append("<p><a href=\"../demo\">Go back</a></p>");
        return doc;
    }
}

