/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.TextMime;
import org.geowebcache.mime.XMLMime;

public class MimeType {
    protected String mimeType;
    protected String format;
    protected String fileExtension;
    protected String internalName;
    protected boolean supportsTiling;
    private static Logger log = Logging.getLogger((String)MimeType.class.getName());

    protected MimeType(String mimeType, String fileExtension, String internalName, String format, boolean supportsTiling) {
        this.mimeType = mimeType;
        this.fileExtension = fileExtension;
        this.internalName = internalName;
        this.format = format;
        this.supportsTiling = supportsTiling;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMimeType(Resource resource) throws IOException {
        return this.mimeType;
    }

    public String getFormat() {
        if (this.format != null) {
            return this.format;
        }
        return this.mimeType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public boolean supportsTiling() {
        return this.supportsTiling;
    }

    public boolean isVector() {
        return false;
    }

    public static MimeType createFromFormat(String formatStr) throws MimeException {
        if (formatStr == null) {
            throw new MimeException("formatStr was not set");
        }
        MimeType mimeType = ImageMime.checkForFormat(formatStr);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = XMLMime.checkForFormat(formatStr);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = TextMime.checkForFormat(formatStr);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = ApplicationMime.checkForFormat(formatStr);
        if (mimeType != null) {
            return mimeType;
        }
        throw new MimeException("Unsupported format request: " + formatStr);
    }

    public static MimeType createFromExtension(String fileExtension) throws MimeException {
        MimeType mimeType = ImageMime.checkForExtension(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = XMLMime.checkForExtension(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = TextMime.checkForExtension(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = ApplicationMime.checkForExtension(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        log.fine("Unsupported MIME type: " + fileExtension + ", returning null");
        return null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            MimeType mimeObj = (MimeType)obj;
            if (this.format.equalsIgnoreCase(mimeObj.format)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.format.hashCode();
    }

    public boolean isCompatible(String otherMimeType) {
        return this.mimeType.equalsIgnoreCase(otherMimeType) || otherMimeType != null && otherMimeType.toLowerCase().startsWith(this.mimeType.toLowerCase());
    }

    public String toString() {
        return this.mimeType;
    }
}

