/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.locks;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.locks.LockProvider;

public class MemoryLockProvider
implements LockProvider {
    private static Logger LOGGER = Logging.getLogger((String)MemoryLockProvider.class.getName());
    Lock[] locks;

    public MemoryLockProvider() {
        this(1024);
    }

    public MemoryLockProvider(int concurrency) {
        this.locks = new Lock[concurrency];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public LockProvider.Lock getLock(final String lockKey) {
        final int idx = this.getIndex(lockKey);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Mapped lock key " + lockKey + " to index " + idx + ". Acquiring lock.");
        }
        this.locks[idx].lock();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Mapped lock key " + lockKey + " to index " + idx + ". Lock acquired");
        }
        return new LockProvider.Lock(){
            boolean released = false;

            @Override
            public void release() throws GeoWebCacheException {
                if (!this.released) {
                    this.released = true;
                    MemoryLockProvider.this.locks[idx].unlock();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Released lock key " + lockKey + " mapped to index " + idx);
                    }
                }
            }
        };
    }

    private int getIndex(String lockKey) {
        int idx = Math.abs(DigestUtils.sha1Hex((String)lockKey).hashCode() % this.locks.length);
        return idx;
    }
}

