/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.ErrorMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.ServiceException;
import org.geowebcache.util.HttpClientBuilder;
import org.geowebcache.util.ServletUtils;
import org.springframework.util.Assert;

public class WMSHttpHelper
extends WMSSourceHelper {
    private static final Logger log = Logging.getLogger((String)WMSHttpHelper.class.getName());
    private final URL proxyUrl;
    private final String httpUsername;
    private final String httpPassword;
    protected volatile HttpClient client;

    public WMSHttpHelper() {
        this(null, null, null);
    }

    public WMSHttpHelper(String httpUsername, String httpPassword, URL proxyUrl) {
        this.httpUsername = httpUsername;
        this.httpPassword = httpPassword;
        this.proxyUrl = proxyUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpClient getHttpClient() {
        if (this.client == null) {
            WMSHttpHelper wMSHttpHelper = this;
            synchronized (wMSHttpHelper) {
                if (this.client != null) {
                    return this.client;
                }
                HttpClientBuilder builder = new HttpClientBuilder(null, this.getBackendTimeout(), this.httpUsername, this.httpPassword, this.proxyUrl, this.getConcurrency());
                this.client = builder.buildClient();
            }
        }
        return this.client;
    }

    @Override
    protected void makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, Map<String, String> wmsParams, MimeType expectedMimeType, Resource target) throws GeoWebCacheException {
        int backendTries;
        Assert.notNull((Object)target, (String)"Target resource can't be null");
        Assert.isTrue((target.getSize() == 0L ? 1 : 0) != 0, (String)"Target resource is not empty");
        URL wmsBackendUrl = null;
        Integer backendTimeout = layer.getBackendTimeout();
        GeoWebCacheException fetchException = null;
        for (backendTries = 0; target.getSize() == 0L && backendTries < layer.getWMSurl().length; ++backendTries) {
            String requestUrl = layer.nextWmsURL();
            try {
                wmsBackendUrl = new URL(requestUrl);
            }
            catch (MalformedURLException maue) {
                throw new GeoWebCacheException("Malformed URL: " + requestUrl + " " + maue.getMessage());
            }
            try {
                this.connectAndCheckHeaders(tileRespRecv, wmsBackendUrl, wmsParams, expectedMimeType, backendTimeout, target, layer.getHttpRequestMode());
                continue;
            }
            catch (GeoWebCacheException e) {
                fetchException = e;
            }
        }
        if (target.getSize() == 0L) {
            String msg = "All backends (" + backendTries + ") failed.";
            if (fetchException != null) {
                msg = msg + " Reason: " + fetchException.getMessage() + ". ";
            }
            msg = msg + " Last request: '" + wmsBackendUrl.toString() + "'. " + (tileRespRecv.getErrorMessage() == null ? "" : tileRespRecv.getErrorMessage());
            tileRespRecv.setError();
            tileRespRecv.setErrorMessage(msg);
            throw new GeoWebCacheException(msg);
        }
    }

    private void connectAndCheckHeaders(TileResponseReceiver tileRespRecv, URL wmsBackendUrl, Map<String, String> wmsParams, MimeType requestMimeType, Integer backendTimeout, Resource target, WMSLayer.HttpRequestMode httpRequestMode) throws GeoWebCacheException {
        String expireValue;
        long expire;
        int responseCode;
        int responseLength;
        HttpResponse method;
        block70: {
            method = null;
            responseLength = 0;
            try {
                method = this.executeRequest(wmsBackendUrl, wmsParams, backendTimeout, httpRequestMode);
                responseCode = method.getStatusLine().getStatusCode();
                if (responseCode != 200) break block70;
                if (method.getFirstHeader("length") != null) {
                    responseLength = Integer.parseInt(method.getFirstHeader("length").getValue());
                    break block70;
                }
                if (method.getFirstHeader("Content-Length") != null) {
                    responseLength = Integer.parseInt(method.getFirstHeader("Content-Length").getValue());
                    break block70;
                }
                if (method.getEntity() != null) {
                    responseLength = Math.toIntExact(method.getEntity().getContentLength());
                    break block70;
                }
                throw new ServiceException("Unable to determine response length from: " + wmsBackendUrl.toString());
            }
            catch (IOException ce) {
                if (log.isLoggable(Level.FINE)) {
                    String message = "Error forwarding request " + wmsBackendUrl.toString();
                    log.log(Level.FINE, message, ce);
                }
                throw new GeoWebCacheException(ce);
            }
        }
        tileRespRecv.setStatus(responseCode);
        if (responseCode != 200 && responseCode != 204) {
            tileRespRecv.setError();
            throw new ServiceException("Unexpected response code from backend: " + responseCode + " for " + wmsBackendUrl.toString());
        }
        String responseMime = method.getFirstHeader("Content-Type").getValue();
        if (responseCode != 204 && responseMime != null && !requestMimeType.isCompatible(responseMime)) {
            Throwable throwable;
            InputStream stream2;
            String message = null;
            if (responseMime.equalsIgnoreCase(ErrorMime.vnd_ogc_se_inimage.getFormat())) {
                try {
                    stream2 = method.getEntity().getContent();
                    throwable = null;
                    try {
                        byte[] error = IOUtils.toByteArray((InputStream)stream2);
                        message = new String(error);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream2 != null) {
                            if (throwable != null) {
                                try {
                                    stream2.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                stream2.close();
                            }
                        }
                    }
                }
                catch (IOException stream2) {}
            } else if (responseMime != null && responseMime.toLowerCase().startsWith("application/vnd.ogc.se_xml")) {
                try {
                    stream2 = method.getEntity().getContent();
                    throwable = null;
                    try {
                        message = IOUtils.toString((InputStream)stream2, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (stream2 != null) {
                            if (throwable != null) {
                                try {
                                    stream2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stream2.close();
                            }
                        }
                    }
                }
                catch (IOException stream3) {
                    // empty catch block
                }
            }
            String msg = "MimeType mismatch, expected " + requestMimeType + " but got " + responseMime + " from " + wmsBackendUrl.toString() + (message == null ? "" : ":\n" + message);
            tileRespRecv.setError();
            tileRespRecv.setErrorMessage(msg);
            log.warning(msg);
        }
        if (tileRespRecv.getExpiresHeader() == -4L && (expire = ServletUtils.parseExpiresHeader(expireValue = method.getFirstHeader("Expires").getValue())) != -1L) {
            tileRespRecv.setExpiresHeader(expire / 1000L);
        }
        if (responseCode != 204) {
            try (InputStream inStream = method.getEntity().getContent();){
                int readAccu;
                if (inStream == null) {
                    log.severe("No response for " + method);
                } else {
                    try (ReadableByteChannel channel = Channels.newChannel(inStream);){
                        target.transferFrom(channel);
                    }
                }
                if (responseLength > 0 && (readAccu = (int)target.getSize()) != responseLength) {
                    tileRespRecv.setError();
                    throw new GeoWebCacheException("Responseheader advertised " + responseLength + " bytes, but only received " + readAccu + " from " + wmsBackendUrl.toString());
                }
            }
            catch (IOException ioe) {
                tileRespRecv.setError();
                log.severe("Caught IO exception, " + wmsBackendUrl.toString() + " " + ioe.getMessage());
            }
        }
    }

    public HttpResponse executeRequest(URL url, Map<String, String> queryParams, Integer backendTimeout, WMSLayer.HttpRequestMode httpRequestMode) throws IOException {
        HttpGet method;
        NameValuePair[] params = null;
        if (queryParams != null) {
            params = new NameValuePair[queryParams.size()];
            int i = 0;
            for (Map.Entry<String, String> e : queryParams.entrySet()) {
                params[i] = new BasicNameValuePair(e.getKey(), e.getValue());
                ++i;
            }
        }
        String urlString = url.toString();
        if (httpRequestMode == WMSLayer.HttpRequestMode.FormPost) {
            HttpPost pm = new HttpPost(urlString);
            if (queryParams != null && !queryParams.isEmpty()) {
                StringEntity requestEntity = new StringEntity(this.processRequestParameters(queryParams));
                pm.setEntity((HttpEntity)requestEntity);
            }
            method = pm;
        } else {
            if (queryParams != null && !queryParams.isEmpty()) {
                String qs = this.processRequestParameters(queryParams);
                urlString = urlString.contains("?") ? urlString + "&" + qs : (urlString.endsWith("?") ? urlString + qs : urlString + "?" + qs);
            }
            method = new HttpGet(urlString);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(method.toString());
        }
        return this.getHttpClient().execute((HttpUriRequest)method);
    }

    private String processRequestParameters(Map<String, String> parameters) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (String parameterName : parameters.keySet()) {
            sb.append(parameterName).append('=').append(URLEncoder.encode(parameters.get(parameterName), StandardCharsets.UTF_8.toString())).append('&');
        }
        return sb.substring(0, sb.length() - 1);
    }
}

