/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.geowebcache.io.Resource;
import org.springframework.util.Assert;

public class ByteArrayResource
implements Resource,
Serializable {
    private byte[] data;
    private int offset;
    private int length;
    private long lastModified = System.currentTimeMillis();

    public ByteArrayResource() {
        this(null);
    }

    public ByteArrayResource(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.length = data == null ? 0 : data.length;
    }

    public ByteArrayResource(byte[] data, int offset, int length) {
        this.data = data;
        if (data == null) {
            this.data = null;
            this.offset = 0;
            this.length = 0;
        } else {
            this.data = data;
            Assert.isTrue((offset < data.length ? 1 : 0) != 0, (String)"Offset should be less than data length");
            Assert.isTrue((offset + length <= data.length ? 1 : 0) != 0, (String)"Offset + length should be less than length");
            this.offset = offset;
            this.length = length;
        }
    }

    public ByteArrayResource(int initialCapacity) {
        this(new byte[initialCapacity], 0, 0);
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getSize() {
        return this.length;
    }

    @Override
    public long transferTo(WritableByteChannel channel) throws IOException {
        if (this.length > 0) {
            ByteBuffer buffer = ByteBuffer.wrap(this.data, this.offset, this.length);
            long written = 0L;
            while ((written += (long)channel.write(buffer)) < (long)this.length) {
            }
        }
        return this.length;
    }

    @Override
    public long transferFrom(ReadableByteChannel channel) throws IOException {
        if (channel instanceof FileChannel) {
            FileChannel fc = (FileChannel)channel;
            this.offset = 0;
            this.length = (int)fc.size();
            if (this.data == null || this.data.length < this.length) {
                this.data = new byte[this.length];
            }
            ByteBuffer buffer = ByteBuffer.wrap(this.data);
            int read = 0;
            while ((read += channel.read(buffer)) < this.length) {
            }
        } else {
            this.offset = 0;
            this.length = 0;
            if (this.data == null) {
                this.data = new byte[4096];
            }
            ByteBuffer buffer = ByteBuffer.wrap(this.data);
            int numRead = 0;
            while ((numRead = channel.read(buffer)) > -1) {
                this.length += numRead;
                if (buffer.position() != buffer.capacity()) continue;
                int position = buffer.position();
                this.expand();
                buffer = ByteBuffer.wrap(this.data);
                buffer.position(position);
            }
        }
        return this.length;
    }

    @Override
    public SeekableInputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new SeekableInputStream(this);
    }

    public byte[] getContents() {
        if (this.data == null || this.length == 0) {
            return null;
        }
        if (this.offset == 0 && this.data.length == this.length) {
            return this.data;
        }
        byte[] buff = new byte[this.length];
        System.arraycopy(this.data, this.offset, buff, 0, this.length);
        return buff;
    }

    public void truncate() {
        this.offset = 0;
        this.length = 0;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new SeekableOutputStream(this);
    }

    private void expand() {
        if (this.data == null) {
            this.data = new byte[4096];
            this.length = 0;
            this.offset = 0;
        } else {
            byte[] newdata = new byte[(int)((double)this.data.length * 1.5)];
            System.arraycopy(this.data, 0, newdata, 0, this.data.length);
            this.data = newdata;
        }
    }

    public static final class SeekableOutputStream
    extends OutputStream {
        private ByteArrayResource res;
        private int remaining;

        public SeekableOutputStream(ByteArrayResource res) {
            this.res = res;
            this.remaining = res.data == null ? 0 : res.data.length;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.remaining == 0) {
                this.res.expand();
                this.remaining = this.res.data.length - this.res.length;
            }
            ((ByteArrayResource)this.res).data[((ByteArrayResource)this.res).length++] = (byte)b;
            --this.remaining;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            if (this.remaining < len) {
                while (this.remaining < len) {
                    this.res.expand();
                    this.remaining = this.res.data.length - this.res.length;
                }
            }
            System.arraycopy(buff, off, this.res.data, this.res.length, len);
            ByteArrayResource byteArrayResource = this.res;
            byteArrayResource.length = byteArrayResource.length + len;
            this.remaining -= len;
        }
    }

    public static final class SeekableInputStream
    extends ByteArrayInputStream {
        private final long lower;

        public SeekableInputStream(ByteArrayResource res) {
            super(res.data == null ? new byte[]{} : res.data, res.offset, res.length);
            this.lower = res.offset;
        }

        public void seek(long pos) throws IOException {
            if (pos < 0L || pos > (long)this.count) {
                throw new IOException("Can't seek to pos " + pos + ". buffer is 0.." + (this.count - 1));
            }
            this.pos = (int)(this.lower + pos);
        }

        public int length() {
            return this.count;
        }
    }
}

