/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geowebcache.GeoWebCacheException;

public class SRS
implements Comparable<SRS>,
Serializable {
    private static Map<Integer, SRS> list = new ConcurrentHashMap<Integer, SRS>();
    private static final SRS EPSG4326 = new SRS(4326);
    private static final SRS EPSG3857 = new SRS(3857, new ArrayList<Integer>(Arrays.asList(900913, 102113, 102100)));
    private static final SRS EPSG900913 = new SRS(900913, new ArrayList<Integer>(Arrays.asList(3857, 102113, 102100)));
    private int number;
    private transient List<Integer> aliases;

    private SRS() {
    }

    private SRS(int epsgNumber) {
        this(epsgNumber, null);
    }

    private SRS(int epsgNumber, List<Integer> aliases) {
        this.number = epsgNumber;
        this.aliases = aliases;
        this.readResolve();
    }

    private Object readResolve() {
        if (!list.containsKey(this.number)) {
            list.put(this.number, this);
        }
        return this;
    }

    public static SRS getSRS(int epsgCode) {
        Integer code = epsgCode;
        SRS existing = list.get(code);
        if (existing != null) {
            return existing;
        }
        for (SRS candidate : new ArrayList<SRS>(list.values())) {
            if (candidate.aliases == null || !candidate.aliases.contains((int)code)) continue;
            list.put(code, candidate);
            return candidate;
        }
        return new SRS(epsgCode);
    }

    public static SRS getSRS(String epsgStr) throws GeoWebCacheException {
        String crsAuthPrefix = "EPSG:";
        if (epsgStr.substring(0, 5).equalsIgnoreCase("EPSG:")) {
            int epsgNumber = Integer.parseInt(epsgStr.substring(5, epsgStr.length()));
            return SRS.getSRS(epsgNumber);
        }
        throw new GeoWebCacheException("Can't parse " + epsgStr + " as SRS string.");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SRS)) {
            return false;
        }
        boolean equivalent = false;
        SRS other = (SRS)obj;
        if (other.number == this.number) {
            equivalent = true;
        } else if (this.aliases != null && other.aliases != null) {
            equivalent = this.aliases.contains(other.number) || other.aliases.contains(this.number);
        }
        return equivalent;
    }

    public int getNumber() {
        return this.number;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        return "EPSG:" + Integer.toString(this.number);
    }

    public static SRS getEPSG4326() {
        return EPSG4326;
    }

    public static SRS getEPSG3857() {
        return EPSG3857;
    }

    public static SRS getEPSG900913() {
        return EPSG900913;
    }

    @Override
    public int compareTo(SRS other) {
        return this.number - other.number;
    }
}

