/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;

public class BlankTileException
extends RequestFilterException {
    private static final long serialVersionUID = 6910805463474341350L;
    private static Logger log = Logging.getLogger((String)BlankTileException.class.getName());
    private static volatile Resource blankTile;

    public BlankTileException(RequestFilter reqFilter) {
        super(reqFilter, 200, "image/png");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Resource getBlankTile() {
        try (InputStream is = GeoWebCacheDispatcher.class.getResourceAsStream("blank.png");){
            byte[] blankTile = new byte[425];
            int ret = is.read(blankTile);
            log.info("Read " + ret + " from blank PNG file (expected 425).");
            ByteArrayResource byteArrayResource = new ByteArrayResource(blankTile);
            return byteArrayResource;
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, ioe.getMessage(), ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resource getResponse() {
        Resource ret = blankTile;
        if (ret != null) return ret;
        Class<BlankTileException> clazz = BlankTileException.class;
        synchronized (BlankTileException.class) {
            ret = blankTile;
            if (ret != null) return ret;
            blankTile = ret = this.getBlankTile();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }
}

