/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class ParametersUtils {
    public static String getLegacyParametersKvp(Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(parameters);
        for (Map.Entry e : sorted.entrySet()) {
            if (sb.length() == 0) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append((String)e.getKey()).append('=').append((String)e.getValue());
        }
        String paramtersKvp = sb.toString();
        return paramtersKvp;
    }

    private static String encUTF8(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Standard encoding UTF-8 is missing");
        }
    }

    private static String decUTF8(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Standard encoding UTF-8 is missing");
        }
    }

    static <T, U extends Comparable<U>> Comparator<T> derivedComparator(Function<T, U> derivation) {
        return (t1, t2) -> ((Comparable)derivation.apply(t1)).compareTo(derivation.apply(t2));
    }

    public static String getKvp(Map<String, String> parameters) {
        return parameters.entrySet().stream().sorted(ParametersUtils.derivedComparator(Map.Entry::getKey)).map(e -> String.join((CharSequence)"=", ParametersUtils.encUTF8((String)e.getKey()), ParametersUtils.encUTF8((String)e.getValue()))).collect(Collectors.joining("&"));
    }

    public static Map<String, String> getMap(String kvp) {
        return Arrays.stream(kvp.split("&")).filter(((Predicate<String>)String::isEmpty).negate()).map(pair -> pair.split("=", 2)).collect(Collectors.toMap(p -> ParametersUtils.decUTF8(p[0]), p -> ParametersUtils.decUTF8(p[1])));
    }

    public static String getId(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        String parametersKvp = ParametersUtils.getLegacyParametersKvp(parameters);
        return ParametersUtils.buildKey(parametersKvp);
    }

    public static String buildKey(String parametersKvp) {
        return DigestUtils.sha1Hex((String)parametersKvp);
    }
}

