/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}"})
public class GeoWebCacheDispatcherController {
    @Value(value="${gwc.context.suffix:}")
    String prefix;
    @Autowired
    @Qualifier(value="geowebcacheDispatcher")
    private GeoWebCacheDispatcher gwcDispatcher;

    @RequestMapping(path={"", "/home", "/service/**", "/demo/**", "/proxy/**"})
    public void handleRestApiRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.gwcDispatcher.handleRequest((HttpServletRequest)new HttpServletRequestWrapper(request){

            public String getContextPath() {
                return super.getContextPath() + ("".equals(GeoWebCacheDispatcherController.this.prefix) ? "" : "/" + GeoWebCacheDispatcherController.this.prefix);
            }
        }, response);
    }
}

