/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.grid.GridSet;

public abstract class SimpleGridSetConfiguration
implements GridSetConfiguration {
    private Map<String, GridSet> gridSets = new HashMap<String, GridSet>();

    @Override
    public Optional<GridSet> getGridSet(String name) {
        return Optional.ofNullable(this.gridSets.get(name)).map(GridSet::new);
    }

    @Override
    public Collection<GridSet> getGridSets() {
        return this.gridSets.values().stream().map(GridSet::new).collect(Collectors.toList());
    }

    @Override
    public void addGridSet(GridSet gridSet) throws UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeGridSet(String gridSetName) throws NoSuchElementException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyGridSet(GridSet gridSet) throws NoSuchElementException, IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameGridSet(String oldName, String newName) throws NoSuchElementException, IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canSave(GridSet gridset) {
        return false;
    }

    protected void addInternal(GridSet g) {
        this.gridSets.put(g.getName(), g);
    }

    protected void removeInternal(String name) {
        this.gridSets.remove(name);
    }

    @Override
    public void deinitialize() throws Exception {
        this.gridSets.clear();
    }
}

