/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import com.google.common.base.Preconditions;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.blobstore.file.DefaultFilePathGenerator;
import org.geowebcache.storage.blobstore.file.FileBlobStore;
import org.geowebcache.storage.blobstore.file.XYZFilePathGenerator;

public class FileBlobStoreInfo
extends BlobStoreInfo {
    private static final long serialVersionUID = -6470560864068854508L;
    private String baseDirectory;
    private int fileSystemBlockSize;
    private PathGeneratorType pathGeneratorType = PathGeneratorType.DEFAULT;

    public FileBlobStoreInfo() {
    }

    public FileBlobStoreInfo(String id) {
        super(id);
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public int getFileSystemBlockSize() {
        return this.fileSystemBlockSize;
    }

    public void setFileSystemBlockSize(int fileSystemBlockSize) {
        this.fileSystemBlockSize = fileSystemBlockSize;
    }

    public PathGeneratorType getPathGeneratorType() {
        return this.pathGeneratorType;
    }

    public void setPathGeneratorType(PathGeneratorType pathGeneratorType) {
        this.pathGeneratorType = pathGeneratorType;
    }

    @Override
    public String toString() {
        return "FileBlobStore[id:" + this.getName() + ", enabled:" + this.isEnabled() + ", baseDirectory:" + this.baseDirectory + ", fileSystemBlockSize:" + this.fileSystemBlockSize + ']';
    }

    @Override
    public BlobStore createInstance(TileLayerDispatcher layers, LockProvider lockProvider) throws StorageException {
        Preconditions.checkState((this.getName() != null ? 1 : 0) != 0, (Object)"id not set");
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"Can't call FileBlobStoreConfig.createInstance() is blob store is not enabled");
        Preconditions.checkState((this.baseDirectory != null ? 1 : 0) != 0, (Object)"baseDirectory not provided");
        Preconditions.checkState((this.fileSystemBlockSize >= 0 ? 1 : 0) != 0, (String)"fileSystemBlockSize must be a positive integer: %s", (int)this.fileSystemBlockSize);
        FileBlobStore fileBlobStore = this.pathGeneratorType == null || this.pathGeneratorType == PathGeneratorType.DEFAULT ? new FileBlobStore(this.baseDirectory, new DefaultFilePathGenerator(this.baseDirectory)) : (this.pathGeneratorType == PathGeneratorType.TMS ? new FileBlobStore(this.baseDirectory, new XYZFilePathGenerator(this.baseDirectory, layers, XYZFilePathGenerator.Convention.TMS)) : new FileBlobStore(this.baseDirectory, new XYZFilePathGenerator(this.baseDirectory, layers, XYZFilePathGenerator.Convention.XYZ)));
        if (this.fileSystemBlockSize > 0) {
            fileBlobStore.setBlockSize(this.fileSystemBlockSize);
        }
        return fileBlobStore;
    }

    @Override
    public String getLocation() {
        return this.getBaseDirectory();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.baseDirectory == null ? 0 : this.baseDirectory.hashCode());
        result = 31 * result + this.fileSystemBlockSize;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileBlobStoreInfo other = (FileBlobStoreInfo)obj;
        if (this.baseDirectory == null ? other.baseDirectory != null : !this.baseDirectory.equals(other.baseDirectory)) {
            return false;
        }
        return this.fileSystemBlockSize == other.fileSystemBlockSize;
    }

    public static enum PathGeneratorType {
        DEFAULT,
        TMS,
        SLIPPY;

    }
}

