/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheExtensions;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.core.Constants;
import org.springframework.util.PropertyPlaceholderHelper;

public class GeoWebCacheEnvironment {
    public static Logger LOGGER = Logging.getLogger((String)GeoWebCacheEnvironment.class.getName());
    private static final Constants constants = new Constants(PlaceholderConfigurerSupport.class);
    public static final boolean ALLOW_ENV_PARAMETRIZATION = Boolean.valueOf(GeoWebCacheExtensions.getProperty("ALLOW_ENV_PARAMETRIZATION"));
    private static final String nullValue = "null";
    private final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper(constants.asString("DEFAULT_PLACEHOLDER_PREFIX"), constants.asString("DEFAULT_PLACEHOLDER_SUFFIX"), constants.asString("DEFAULT_VALUE_SEPARATOR"), true);
    private final PropertyPlaceholderHelper.PlaceholderResolver resolver = placeholderName -> this.resolvePlaceholder(placeholderName);
    private Properties props;

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    protected String resolvePlaceholder(String placeholder) {
        String propVal = null;
        propVal = this.resolveSystemProperty(placeholder);
        if (this.props != null && propVal == null) {
            propVal = this.props.getProperty(placeholder);
        }
        return propVal;
    }

    protected String resolveSystemProperty(String key) {
        try {
            String value = GeoWebCacheExtensions.getProperty(key);
            if (value == null) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (Throwable ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not access system property '" + key + "': " + ex);
            }
            return null;
        }
    }

    protected String resolveStringValue(String strVal) throws BeansException {
        String resolved = this.helper.replacePlaceholders(strVal, this.resolver);
        return resolved.equals(nullValue) ? null : resolved;
    }

    public Object resolveValue(Object value) {
        if (value != null && value instanceof String) {
            return this.resolveStringValue((String)value);
        }
        return value;
    }

    private String resolveValueIfEnabled(String value) {
        if (ALLOW_ENV_PARAMETRIZATION) {
            return (String)this.resolveValue(value);
        }
        return value;
    }

    private boolean validateBoolean(String value) {
        return "true".equalsIgnoreCase(value = value.trim()) || "false".equalsIgnoreCase(value);
    }

    public <T> Optional<T> resolveValueIfEnabled(String value, Class<T> type) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        String resultValue = this.resolveValueIfEnabled(value);
        if (type.isAssignableFrom(String.class)) {
            return Optional.of(resultValue);
        }
        if (type.isAssignableFrom(Integer.class)) {
            try {
                Integer intValue = Integer.valueOf(resultValue);
                return Optional.of(intValue);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Illegal String parameter: Resolved value is not an integer.", ex);
            }
        }
        if (type.isAssignableFrom(Boolean.class)) {
            if (!this.validateBoolean(resultValue)) {
                throw new IllegalArgumentException("Illegal String parameter: Resolved value is not a boolean.");
            }
            Boolean boolValue = Boolean.valueOf(value);
            return Optional.of(boolValue);
        }
        throw new IllegalArgumentException("No type convertion available for " + type);
    }
}

