/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.impl.WFSDataAccessFactory;
import org.geotools.data.wfs.internal.URIs;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPConnectionPooling;
import org.geotools.ows.ServiceException;
import org.geotools.util.Version;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.opengis.feature.type.FeatureTypeFactory;

public class WFSDataStoreFactory
extends WFSDataAccessFactory
implements DataStoreFactorySpi {
    private static int GMLComplianceLevel = 0;

    public WFSDataStore createDataStore(Map<String, ?> params) throws IOException {
        WFSClient wfsClient;
        WFSConfig config = WFSConfig.fromParams(params);
        String user = config.getUser();
        String password = config.getPassword();
        if (user == null && password != null || config.getPassword() == null && config.getUser() != null) {
            throw new IOException("Cannot define only one of USERNAME or PASSWORD, must define both or neither");
        }
        URL capabilitiesURL = (URL)URL.lookUp(params);
        HTTPClient http = this.getHttpClient(params);
        http.setTryGzip(config.isTryGZIP());
        http.setUser(config.getUser());
        http.setPassword(config.getPassword());
        int timeoutMillis = config.getTimeoutMillis();
        http.setConnectTimeout(timeoutMillis / 1000);
        http.setReadTimeout(timeoutMillis / 1000);
        try {
            wfsClient = new WFSClient(capabilitiesURL, http, config);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
        WFSDataStore dataStore = new WFSDataStore(wfsClient);
        dataStore.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        dataStore.setGeometryFactory(new GeometryFactory((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY));
        dataStore.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        dataStore.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
        dataStore.setDataStoreFactory(this);
        dataStore.setNamespaceURI(config.getNamespaceOverride());
        return dataStore;
    }

    public HTTPClient getHttpClient(Map<String, ?> params) throws IOException {
        URL capabilitiesURL = (URL)URL.lookUp(params);
        WFSConfig config = WFSConfig.fromParams(params);
        if (config.isUseHttpConnectionPooling() && WFSDataStoreFactory.isHttp(capabilitiesURL)) {
            HTTPClient client = HTTPClientFinder.createClient((Class[])new Class[]{HTTPConnectionPooling.class});
            client.setReadTimeout(config.getTimeoutMillis() / 1000);
            client.setConnectTimeout(config.getTimeoutMillis() / 1000);
            ((HTTPConnectionPooling)client).setMaxConnections(config.getMaxConnectionPoolSize());
            return client;
        }
        return HTTPClientFinder.createClient();
    }

    private static boolean isHttp(URL capabilitiesURL) {
        return capabilitiesURL.getProtocol().toLowerCase().matches("http(s)?");
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        throw new UnsupportedOperationException("Operation not applicable to a WFS service");
    }

    @Override
    public String getDisplayName() {
        return "Web Feature Server (NG)";
    }

    @Override
    public String getDescription() {
        return "Provides access to the Features published a Web Feature Service, and the ability to perform transactions on the server (when supported / allowed).";
    }

    public boolean canProcess(Map params) {
        return super.canProcess(params, GMLComplianceLevel);
    }

    public static URL createGetCapabilitiesRequest(URL host, Version version) {
        if (host == null) {
            throw new NullPointerException("null url");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        HashMap<String, String> getCapsKvp = new HashMap<String, String>();
        getCapsKvp.put("SERVICE", "WFS");
        getCapsKvp.put("REQUEST", "GetCapabilities");
        getCapsKvp.put("VERSION", version.toString());
        return URIs.buildURL(host, getCapsKvp);
    }

    public static URL createGetCapabilitiesRequest(URL host) {
        Version defaultVersion;
        if (host == null) {
            throw new NullPointerException("url");
        }
        String queryString = host.getQuery();
        queryString = queryString == null || "".equals(queryString.trim()) ? "" : queryString.toUpperCase();
        Version requestVersion = defaultVersion = Versions.highest();
        if (queryString.length() > 0) {
            String version;
            String[] split;
            HashMap<String, String> params = new HashMap<String, String>();
            for (String kvp : split = queryString.split("&")) {
                int index = kvp.indexOf(61);
                String key = index > 0 ? kvp.substring(0, index) : kvp;
                String value = index > 0 ? kvp.substring(index + 1) : null;
                params.put(key, value);
            }
            String request = (String)params.get("REQUEST");
            if ("GETCAPABILITIES".equals(request) && (version = (String)params.get("VERSION")) != null && (requestVersion = Versions.find(version)) == null) {
                requestVersion = defaultVersion;
            }
        }
        return WFSDataStoreFactory.createGetCapabilitiesRequest(host, requestVersion);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

