/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.validation.UserGroupStoreValidationWrapper;
import org.geoserver.security.web.user.ConfirmRemovalUserPanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;

public class SelectionUserRemovalLink
extends AjaxLink<Object> {
    private static final long serialVersionUID = 1L;
    GeoServerTablePanel<GeoServerUser> users;
    GeoServerDialog dialog;
    boolean disassociateRoles;
    ConfirmRemovalUserPanel removePanel;
    GeoServerDialog.DialogDelegate delegate;
    String userGroupsServiceName;

    public SelectionUserRemovalLink(String userGroupsServiceName, String id, GeoServerTablePanel<GeoServerUser> users, GeoServerDialog dialog, boolean disassociateRoles) {
        super(id);
        this.users = users;
        this.dialog = dialog;
        this.disassociateRoles = disassociateRoles;
        this.userGroupsServiceName = userGroupsServiceName;
    }

    public void onClick(AjaxRequestTarget target) {
        final List selection = this.users.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.delegate = new GeoServerDialog.DialogDelegate(){

            protected Component getContents(String id) {
                Model model = new Model((Serializable)Boolean.valueOf(SelectionUserRemovalLink.this.disassociateRoles));
                SelectionUserRemovalLink.this.removePanel = new ConfirmRemovalUserPanel(id, model, selection){

                    @Override
                    protected IModel<String> canRemove(GeoServerUser user) {
                        return SelectionUserRemovalLink.this.canRemove(user);
                    }
                };
                return SelectionUserRemovalLink.this.removePanel;
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                UserGroupStoreValidationWrapper ugStore = null;
                try {
                    GeoServerUserGroupService ugService = GeoServerApplication.get().getSecurityManager().loadUserGroupService(SelectionUserRemovalLink.this.userGroupsServiceName);
                    ugStore = new UserGroupStoreValidationWrapper(ugService.createStore());
                    for (GeoServerUser user : SelectionUserRemovalLink.this.removePanel.getRoots()) {
                        ugStore.removeUser(user);
                    }
                    ugStore.store();
                }
                catch (IOException ex) {
                    try {
                        if (ugStore != null) {
                            ugStore.load();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new RuntimeException(ex);
                }
                GeoServerRoleStore gaStore = null;
                if (SelectionUserRemovalLink.this.disassociateRoles) {
                    try {
                        gaStore = GeoServerApplication.get().getSecurityManager().getActiveRoleService().createStore();
                        gaStore = new RoleStoreValidationWrapper(gaStore, new GeoServerUserGroupService[0]);
                        for (GeoServerUser user : SelectionUserRemovalLink.this.removePanel.getRoots()) {
                            ArrayList list = new ArrayList();
                            list.addAll(gaStore.getRolesForUser(user.getUsername()));
                            for (GeoServerRole role : list) {
                                gaStore.disAssociateRoleFromUser(role, user.getUsername());
                            }
                        }
                        gaStore.store();
                    }
                    catch (IOException ex) {
                        try {
                            if (gaStore != null) {
                                gaStore.load();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new RuntimeException(ex);
                    }
                }
                SelectionUserRemovalLink.this.users.clearSelection();
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (SelectionUserRemovalLink.this.users.getSelection().size() == 0) {
                    SelectionUserRemovalLink.this.setEnabled(false);
                    target.add(new Component[]{SelectionUserRemovalLink.this});
                    target.add(new Component[]{SelectionUserRemovalLink.this.users});
                }
            }
        };
        this.dialog.showOkCancel(target, this.delegate);
    }

    protected StringResourceModel canRemove(GeoServerUser user) {
        return null;
    }
}

