/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.IOException;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.logging.Level;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.validation.UserGroupStoreValidationWrapper;
import org.geoserver.security.web.user.AbstractUserPage;

public class EditUserPage
extends AbstractUserPage {
    public EditUserPage(String userGroupServiceName, GeoServerUser user) {
        super(userGroupServiceName, user);
        this.get("form:username").setEnabled(false);
    }

    @Override
    protected void onFormSubmit(GeoServerUser user) throws IOException, PasswordPolicyException {
        GeoServerUserGroupService ugService = this.getUserGroupService(this.ugServiceName);
        UserGroupStoreValidationWrapper ugStore = null;
        try {
            if (ugService.canCreateStore()) {
                ugStore = new UserGroupStoreValidationWrapper(ugService.createStore());
                SortedSet orig = ugStore.getGroupsForUser(user);
                HashSet<GeoServerUserGroup> add = new HashSet<GeoServerUserGroup>();
                HashSet<GeoServerUserGroup> remove = new HashSet<GeoServerUserGroup>();
                this.userGroupPalette.diff(orig, add, remove);
                ugStore.updateUser(user);
                for (GeoServerUserGroup g : add) {
                    ugStore.associateUserToGroup(user, g);
                }
                for (GeoServerUserGroup g : remove) {
                    ugStore.disAssociateUserFromGroup(user, g);
                }
                ugStore.store();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            try {
                if (ugStore != null) {
                    ugStore.load();
                }
            }
            catch (IOException add) {
                // empty catch block
            }
            throw ex;
        }
        catch (PasswordPolicyException ex) {
            try {
                ugStore.load();
            }
            catch (IOException add) {
                // empty catch block
            }
            throw ex;
        }
        GeoServerRoleStore roleStore = null;
        try {
            if (this.hasRoleStore(this.getSecurityManager().getActiveRoleService().getName())) {
                roleStore = this.getRoleStore(this.getSecurityManager().getActiveRoleService().getName());
                roleStore = new RoleStoreValidationWrapper(roleStore, new GeoServerUserGroupService[0]);
                SortedSet orig = roleStore.getRolesForUser(user.getUsername());
                HashSet<GeoServerRole> add = new HashSet<GeoServerRole>();
                HashSet<GeoServerRole> remove = new HashSet<GeoServerRole>();
                this.rolePalette.diff(orig, add, remove);
                for (GeoServerRole role : add) {
                    roleStore.associateRoleToUser(role, user.getUsername());
                }
                for (GeoServerRole role : remove) {
                    roleStore.disAssociateRoleFromUser(role, user.getUsername());
                }
                roleStore.store();
            }
        }
        catch (IOException ex) {
            try {
                if (roleStore != null) {
                    roleStore.load();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }
}

