/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.validation.AbstractSecurityException;
import org.geoserver.security.validation.RoleServiceValidationWrapper;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.web.role.ConfirmRemovalRolePanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;

public class SelectionRoleRemovalLink
extends AjaxLink<Object> {
    private static final long serialVersionUID = 1L;
    GeoServerTablePanel<GeoServerRole> roles;
    GeoServerDialog dialog;
    GeoServerDialog.DialogDelegate delegate;
    ConfirmRemovalRolePanel removePanel;
    String roleServiceName;

    public SelectionRoleRemovalLink(String roleServiceName, String id, GeoServerTablePanel<GeoServerRole> roles, GeoServerDialog dialog) {
        super(id);
        this.roles = roles;
        this.dialog = dialog;
        this.roleServiceName = roleServiceName;
    }

    public void onClick(AjaxRequestTarget target) {
        final List selection = this.roles.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.delegate = new GeoServerDialog.DialogDelegate(){
            private static final long serialVersionUID = 1L;

            protected Component getContents(String id) {
                SelectionRoleRemovalLink.this.removePanel = new ConfirmRemovalRolePanel(id, selection){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected IModel<String> canRemove(GeoServerRole role) {
                        return SelectionRoleRemovalLink.this.canRemove(role);
                    }
                };
                return SelectionRoleRemovalLink.this.removePanel;
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                RoleStoreValidationWrapper gaStore = null;
                try {
                    GeoServerRoleService gaService = GeoServerApplication.get().getSecurityManager().loadRoleService(SelectionRoleRemovalLink.this.roleServiceName);
                    gaStore = new RoleStoreValidationWrapper(gaService.createStore(), new GeoServerUserGroupService[0]);
                    for (GeoServerRole role : SelectionRoleRemovalLink.this.removePanel.getRoots()) {
                        gaStore.removeRole(role);
                    }
                    gaStore.store();
                }
                catch (IOException ex) {
                    try {
                        if (gaStore != null) {
                            gaStore.load();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new RuntimeException(ex);
                }
                SelectionRoleRemovalLink.this.roles.clearSelection();
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (SelectionRoleRemovalLink.this.roles.getSelection().size() == 0) {
                    SelectionRoleRemovalLink.this.setEnabled(false);
                    target.add(new Component[]{SelectionRoleRemovalLink.this});
                    target.add(new Component[]{SelectionRoleRemovalLink.this.roles});
                }
            }
        };
        this.dialog.showOkCancel(target, this.delegate);
    }

    protected IModel<String> canRemove(GeoServerRole role) {
        GeoServerRoleService gaService = null;
        try {
            gaService = GeoServerApplication.get().getSecurityManager().loadRoleService(this.roleServiceName);
            boolean isActive = GeoServerApplication.get().getSecurityManager().getActiveRoleService().getName().equals(this.roleServiceName);
            RoleServiceValidationWrapper valService = new RoleServiceValidationWrapper(gaService, isActive, new GeoServerUserGroupService[0]);
            valService.checkRoleIsMapped(role);
            valService.checkRoleIsUsed(role);
        }
        catch (IOException e) {
            if (e.getCause() instanceof AbstractSecurityException) {
                return new Model((Serializable)((Object)e.getCause().getMessage()));
            }
            throw new RuntimeException(e);
        }
        return null;
    }
}

