/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class RoleListProvider
extends GeoServerDataProvider<GeoServerRole> {
    protected String roleServiceName;
    public static final GeoServerDataProvider.Property<GeoServerRole> ROLENAME = new GeoServerDataProvider.BeanProperty("rolename", "authority");
    public static final String ParentPropertyName = "parentrolename";
    public static final GeoServerDataProvider.Property<GeoServerRole> HASROLEPARAMS = new GeoServerDataProvider.Property<GeoServerRole>(){

        public String getName() {
            return "hasroleparams";
        }

        public Object getPropertyValue(GeoServerRole item) {
            if (item.getProperties().size() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public IModel getModel(IModel<GeoServerRole> itemModel) {
            return new Model((Serializable)((Boolean)this.getPropertyValue((GeoServerRole)itemModel.getObject())));
        }

        public Comparator<GeoServerRole> getComparator() {
            return new GeoServerDataProvider.PropertyComparator((GeoServerDataProvider.Property)this);
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isSearchable() {
            return true;
        }
    };

    public RoleListProvider(String roleServiceName) {
        this.roleServiceName = roleServiceName;
    }

    protected List<GeoServerRole> getItems() {
        TreeSet roles = null;
        try {
            GeoServerRoleService service = null;
            if (this.roleServiceName != null) {
                service = GeoServerApplication.get().getSecurityManager().loadRoleService(this.roleServiceName);
            }
            roles = service == null ? new TreeSet() : service.getRoles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<GeoServerRole> roleList = new ArrayList<GeoServerRole>();
        roleList.addAll(roles);
        return roleList;
    }

    protected List<GeoServerDataProvider.Property<GeoServerRole>> getProperties() {
        ArrayList<GeoServerDataProvider.Property<GeoServerRole>> result = new ArrayList<GeoServerDataProvider.Property<GeoServerRole>>();
        result.add(ROLENAME);
        result.add(new ParentProperty());
        result.add(HASROLEPARAMS);
        return result;
    }

    public class ParentProperty
    implements GeoServerDataProvider.Property<GeoServerRole> {
        public String getName() {
            return RoleListProvider.ParentPropertyName;
        }

        public Object getPropertyValue(GeoServerRole item) {
            GeoServerRole parent = null;
            try {
                parent = GeoServerApplication.get().getSecurityManager().loadRoleService(RoleListProvider.this.roleServiceName).getParentRole(item);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (parent == null) {
                return "";
            }
            return parent.getAuthority();
        }

        public IModel getModel(IModel<GeoServerRole> itemModel) {
            return new Model((Serializable)((Object)((String)this.getPropertyValue((GeoServerRole)itemModel.getObject()))));
        }

        public Comparator<GeoServerRole> getComparator() {
            return new GeoServerDataProvider.PropertyComparator((GeoServerDataProvider.Property)this);
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isSearchable() {
            return true;
        }
    }
}

