/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.data.CatalogModeModel;
import org.geoserver.security.web.data.DataAccessRuleProvider;
import org.geoserver.security.web.data.EditDataAccessRulePage;
import org.geoserver.security.web.data.NewDataAccessRulePage;
import org.geoserver.security.web.data.SelectionDataRuleRemovalLink;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class DataSecurityPage
extends AbstractSecurityPage {
    static final List<CatalogMode> CATALOG_MODES = Arrays.asList(CatalogMode.HIDE, CatalogMode.MIXED, CatalogMode.CHALLENGE);
    private GeoServerTablePanel<DataAccessRule> rules;
    private SelectionDataRuleRemovalLink removal;
    private RadioChoice catalogModeChoice;

    public DataSecurityPage() {
        DataAccessRuleProvider provider = new DataAccessRuleProvider();
        Component[] componentArray = new Component[1];
        this.rules = new GeoServerTablePanel<DataAccessRule>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel<DataAccessRule> itemModel, GeoServerDataProvider.Property<DataAccessRule> property) {
                if (property == DataAccessRuleProvider.RULEKEY) {
                    return DataSecurityPage.this.editRuleLink(id, itemModel, property);
                }
                if (property == DataAccessRuleProvider.ROLES) {
                    return new Label(id, property.getModel(itemModel));
                }
                throw new RuntimeException("Uknown property " + property);
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                DataSecurityPage.this.removal.setEnabled(DataSecurityPage.this.rules.getSelection().size() > 0);
                target.add(new Component[]{DataSecurityPage.this.removal});
            }
        };
        componentArray[0] = this.rules;
        this.add(componentArray);
        this.rules.setOutputMarkupId(true);
        this.setHeaderPanel(this.headerPanel());
        Form form = new Form("catalogModeForm", (IModel)new CompoundPropertyModel((Object)new CatalogModeModel(DataAccessRuleDAO.get().getMode())));
        this.add(new Component[]{form});
        form.add(new Component[]{new HelpLink("catalogModeHelp").setDialog(this.dialog)});
        this.catalogModeChoice = new RadioChoice("catalogMode", CATALOG_MODES, (IChoiceRenderer)new CatalogModeRenderer());
        this.catalogModeChoice.setSuffix(" ");
        form.add(new Component[]{this.catalogModeChoice});
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                try {
                    DataAccessRuleDAO dao = DataAccessRuleDAO.get();
                    CatalogMode newMode = DataAccessRuleDAO.getByAlias((String)DataSecurityPage.this.catalogModeChoice.getValue());
                    dao.setCatalogMode(newMode);
                    dao.storeRules();
                    DataSecurityPage.this.doReturn();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error occurred while saving user", e);
                    this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}));
                }
            }
        }});
        form.add(new Component[]{new BookmarkablePageLink("cancel", GeoServerHomePage.class)});
    }

    Component editRuleLink(String id, IModel<DataAccessRule> itemModel, GeoServerDataProvider.Property<DataAccessRule> property) {
        return new SimpleAjaxLink<DataAccessRule>(id, itemModel, property.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new EditDataAccessRulePage((DataAccessRule)this.getModelObject()));
            }
        };
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", NewDataAccessRulePage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionDataRuleRemovalLink("removeSelected", this.rules, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    class CatalogModeRenderer
    extends ChoiceRenderer<CatalogMode> {
        CatalogModeRenderer() {
        }

        public Object getDisplayValue(CatalogMode object) {
            return new ParamResourceModel(object.name(), (Component)DataSecurityPage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(CatalogMode object, int index) {
            return object.name();
        }
    }
}

