/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.HtmlLoginFilterChain;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.ServiceLoginFilterChain;
import org.geoserver.security.VariableFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.web.auth.SecurityFilterChainPage;
import org.geoserver.security.web.auth.SecurityFilterChainProvider;
import org.geoserver.security.web.auth.SecurityVariableFilterChainPage;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class SecurityFilterChainsPanel
extends Panel {
    SecurityFilterChainTablePanel tablePanel;
    FeedbackPanel feedbackPanel;
    GeoServerDialog dialog;
    SecurityManagerConfig secMgrConfig;

    public SecurityFilterChainsPanel(String id, SecurityManagerConfig secMgrConfig) {
        super(id);
        this.secMgrConfig = secMgrConfig;
        boolean isAdmin = this.getSecurityManager().checkAuthenticationForAdminRole();
        this.add(new Component[]{new AjaxLink("addServiceChain"){

            public void onClick(AjaxRequestTarget target) {
                SecurityVariableFilterChainPage newPage = new SecurityVariableFilterChainPage((VariableFilterChain)new ServiceLoginFilterChain(new String[0]), SecurityFilterChainsPanel.this.secMgrConfig, true);
                newPage.setReturnPage(this.getPage());
                this.setResponsePage((IRequestablePage)newPage);
            }
        }.setEnabled(isAdmin)});
        this.add(new Component[]{new AjaxLink("addHtmlChain"){

            public void onClick(AjaxRequestTarget target) {
                SecurityVariableFilterChainPage newPage = new SecurityVariableFilterChainPage((VariableFilterChain)new HtmlLoginFilterChain(new String[0]), SecurityFilterChainsPanel.this.secMgrConfig, true);
                newPage.setReturnPage(this.getPage());
                this.setResponsePage((IRequestablePage)newPage);
            }
        }.setEnabled(isAdmin)});
        SecurityFilterChainProvider dataProvider = new SecurityFilterChainProvider(secMgrConfig);
        Component[] componentArray = new Component[1];
        this.tablePanel = new SecurityFilterChainTablePanel("table", dataProvider){
            private static final long serialVersionUID = 1L;
        };
        componentArray[0] = this.tablePanel;
        this.add(componentArray);
        this.tablePanel.setOutputMarkupId(true);
        this.tablePanel.setFilterable(false);
        this.tablePanel.setSortable(false);
        this.tablePanel.getTopPager().setVisible(false);
        this.add(new Component[]{this.tablePanel});
        Component[] componentArray2 = new Component[1];
        this.feedbackPanel = new FeedbackPanel("feedback");
        componentArray2[0] = this.feedbackPanel;
        this.add(componentArray2);
        this.feedbackPanel.setOutputMarkupId(true);
        Component[] componentArray3 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray3[0] = this.dialog;
        this.add(componentArray3);
    }

    public GeoServerSecurityManager getSecurityManager() {
        return GeoServerApplication.get().getSecurityManager();
    }

    void handleException(Exception e, Component target) {
        Serializable msg = null;
        if (e instanceof SecurityConfigException) {
            SecurityConfigException sce = (SecurityConfigException)e;
            msg = (Serializable)new StringResourceModel("security." + sce.getId()).setParameters(sce.getArgs()).getObject();
        } else {
            msg = e;
        }
        (target != null ? target : this.getPage()).error(msg);
    }

    Component removeLink(String id, IModel itemModel) {
        final RequestFilterChain chain = (RequestFilterChain)itemModel.getObject();
        if (!chain.canBeRemoved()) {
            ImageAjaxLink blankLink = new ImageAjaxLink(id, new PackageResourceReference(((Object)((Object)this)).getClass(), "../img/icons/blank.png")){

                protected void onClick(AjaxRequestTarget target) {
                }
            };
            blankLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new Model((Serializable)((Object)"")))});
            this.add(new Component[]{blankLink});
            return blankLink;
        }
        ImageAjaxLink link = new ImageAjaxLink(id, new PackageResourceReference(((Object)((Object)this)).getClass(), "../img/icons/silk/delete.png")){

            protected void onClick(AjaxRequestTarget target) {
                SecurityFilterChainsPanel.this.secMgrConfig.getFilterChain().getRequestChains().remove(chain);
                target.add(new Component[]{SecurityFilterChainsPanel.this.tablePanel});
            }
        };
        link.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("LayerGroupEditPage.th.remove", (Component)link, new Object[0]))});
        return link;
    }

    Component positionPanel(String id, IModel itemModel) {
        return new PositionPanel(id, (RequestFilterChain)itemModel.getObject());
    }

    class PositionPanel
    extends Panel {
        RequestFilterChain theChain;
        private ImageAjaxLink upLink;
        private ImageAjaxLink downLink;

        List<RequestFilterChain> getChains() {
            return SecurityFilterChainsPanel.this.secMgrConfig.getFilterChain().getRequestChains();
        }

        public PositionPanel(String id, RequestFilterChain chain) {
            super(id);
            this.theChain = chain;
            this.setOutputMarkupId(true);
            this.upLink = new ImageAjaxLink("up", new PackageResourceReference(((Object)((Object)this)).getClass(), "../img/icons/silk/arrow_up.png")){

                protected void onClick(AjaxRequestTarget target) {
                    int index = PositionPanel.this.getChains().indexOf(PositionPanel.this.theChain);
                    PositionPanel.this.getChains().remove(index);
                    PositionPanel.this.getChains().add(Math.max(0, index - 1), PositionPanel.this.theChain);
                    target.add(new Component[]{SecurityFilterChainsPanel.this.tablePanel});
                    target.add(new Component[]{this});
                    target.add(new Component[]{PositionPanel.this.downLink});
                    target.add(new Component[]{PositionPanel.this.upLink});
                }

                protected void onComponentTag(ComponentTag tag) {
                    if (PositionPanel.this.getChains().indexOf(PositionPanel.this.theChain) == 0) {
                        tag.put("style", (CharSequence)"visibility:hidden");
                    } else {
                        tag.put("style", (CharSequence)"visibility:visible");
                    }
                }
            };
            this.upLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("SecurityFilterChainsPanel.th.up", (Component)this.upLink, new Object[0]))});
            this.upLink.setOutputMarkupId(true);
            this.add(new Component[]{this.upLink});
            this.downLink = new ImageAjaxLink("down", new PackageResourceReference(((Object)((Object)this)).getClass(), "../img/icons/silk/arrow_down.png")){

                protected void onClick(AjaxRequestTarget target) {
                    int index = PositionPanel.this.getChains().indexOf(PositionPanel.this.theChain);
                    PositionPanel.this.getChains().remove(index);
                    PositionPanel.this.getChains().add(Math.min(PositionPanel.this.getChains().size(), index + 1), PositionPanel.this.theChain);
                    target.add(new Component[]{SecurityFilterChainsPanel.this.tablePanel});
                    target.add(new Component[]{this});
                    target.add(new Component[]{PositionPanel.this.downLink});
                    target.add(new Component[]{PositionPanel.this.upLink});
                }

                protected void onComponentTag(ComponentTag tag) {
                    if (PositionPanel.this.getChains().indexOf(PositionPanel.this.theChain) == PositionPanel.this.getChains().size() - 1) {
                        tag.put("style", (CharSequence)"visibility:hidden");
                    } else {
                        tag.put("style", (CharSequence)"visibility:visible");
                    }
                }
            };
            this.downLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("SecurityFilterChainsPanel.th.down", (Component)this.downLink, new Object[0]))});
            this.downLink.setOutputMarkupId(true);
            this.add(new Component[]{this.downLink});
        }
    }

    class SecurityFilterChainTablePanel
    extends GeoServerTablePanel<RequestFilterChain> {
        public SecurityFilterChainTablePanel(String id, SecurityFilterChainProvider dataProvider) {
            super(id, (GeoServerDataProvider)dataProvider, false);
        }

        Component createEditLink(String id, final IModel<RequestFilterChain> model, final GeoServerDataProvider.Property<RequestFilterChain> property) {
            IModel cast = property.getModel(model);
            return new SimpleAjaxLink<String>(id, cast){
                String chainName;
                {
                    super(x0, x1);
                    this.chainName = (String)property.getModel(model).getObject();
                }

                protected void onClick(AjaxRequestTarget target) {
                    RequestFilterChain chain = SecurityFilterChainsPanel.this.secMgrConfig.getFilterChain().getRequestChainByName(this.chainName);
                    SecurityFilterChainPage editPage = null;
                    editPage = chain instanceof VariableFilterChain ? new SecurityVariableFilterChainPage((VariableFilterChain)chain, SecurityFilterChainsPanel.this.secMgrConfig, false) : new SecurityFilterChainPage(chain, SecurityFilterChainsPanel.this.secMgrConfig, false);
                    editPage.setReturnPage(this.getPage());
                    this.setResponsePage((IRequestablePage)editPage);
                }
            };
        }

        protected Component getComponentForProperty(String id, IModel<RequestFilterChain> itemModel, GeoServerDataProvider.Property<RequestFilterChain> property) {
            if (property == SecurityFilterChainProvider.NAME) {
                return this.createEditLink(id, itemModel, property);
            }
            if (property == SecurityFilterChainProvider.POSITION) {
                return SecurityFilterChainsPanel.this.positionPanel(id, itemModel);
            }
            if (property == SecurityFilterChainProvider.REMOVE) {
                return SecurityFilterChainsPanel.this.removeLink(id, itemModel);
            }
            if (Boolean.TRUE.equals(property.getModel(itemModel).getObject())) {
                return new Icon(id, CatalogIconFactory.ENABLED_ICON);
            }
            if (Boolean.FALSE.equals(property.getModel(itemModel).getObject())) {
                return new Label(id, (Serializable)((Object)""));
            }
            return new Label(id, property.getModel(itemModel));
        }
    }
}

