/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.HTTPMethod;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.config.LogoutFilterConfig;
import org.geoserver.security.config.SSLFilterConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.auth.AuthenticationChainPalette;
import org.geoserver.security.web.auth.AuthenticationFiltersPanel;
import org.geoserver.security.web.auth.AuthenticationProvidersPanel;
import org.geoserver.security.web.auth.CommaSeparatedListConverter;
import org.geoserver.security.web.auth.SecurityFilterChainsPanel;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class AuthenticationPage
extends AbstractSecurityPage {
    Form<SecurityManagerConfig> form;
    LogoutFilterConfig logoutFilterConfig;
    SSLFilterConfig sslFilterConfig;
    SecurityManagerConfig config;
    AuthFilterChainPanel authFilterChainPanel;

    public AuthenticationPage() {
        this.initComponents();
    }

    void initComponents() {
        this.config = this.getSecurityManager().getSecurityConfig();
        ArrayList<RequestFilterChain> clones = new ArrayList<RequestFilterChain>();
        for (RequestFilterChain chain : this.config.getFilterChain().getRequestChains()) {
            try {
                clones.add((RequestFilterChain)chain.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        this.config.setFilterChain(new GeoServerSecurityFilterChain(clones));
        this.form = new Form("form", (IModel)new CompoundPropertyModel((Object)this.config));
        this.add(new Component[]{this.form});
        try {
            this.logoutFilterConfig = (LogoutFilterConfig)this.getSecurityManager().loadFilterConfig("formLogout");
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        this.form.add(new Component[]{new TextField("redirectURL", (IModel)new PropertyModel((Object)this, "logoutFilterConfig.redirectURL"))});
        try {
            this.sslFilterConfig = (SSLFilterConfig)this.getSecurityManager().loadFilterConfig("sslFilter");
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        this.form.add(new Component[]{new TextField("sslPort", (IModel)new PropertyModel((Object)this, "sslFilterConfig.sslPort"))});
        this.form.add(new Component[]{new CheckBox("bfEnabled", (IModel)new PropertyModel((Object)this, "config.bruteForcePrevention.enabled"))});
        final TextField bfMinDelay = new TextField("bfMinDelaySeconds", (IModel)new PropertyModel((Object)this, "config.bruteForcePrevention.minDelaySeconds"));
        bfMinDelay.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.form.add(new Component[]{bfMinDelay});
        final TextField bfMaxDelay = new TextField("bfMaxDelaySeconds", (IModel)new PropertyModel((Object)this, "config.bruteForcePrevention.maxDelaySeconds"));
        bfMaxDelay.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.form.add(new Component[]{bfMaxDelay});
        TextField<List<String>> netmasks = new TextField<List<String>>("bfWhitelistedNetmasks", (IModel)new PropertyModel((Object)this, "config.bruteForcePrevention.whitelistedMasks")){

            public <C> IConverter<C> getConverter(Class<C> type) {
                return new CommaSeparatedListConverter();
            }
        };
        netmasks.add((IValidator & Serializable)validatable -> {
            List masks = (List)validatable.getValue();
            for (String mask : masks) {
                try {
                    new IpAddressMatcher(mask);
                }
                catch (Exception e) {
                    this.form.error((Serializable)((Object)new ParamResourceModel("invalidMask", (Component)this.getPage(), new Object[]{mask}).getString()));
                }
            }
        });
        this.form.add(new Component[]{netmasks});
        this.form.add((IFormValidator)new AbstractFormValidator(){

            public void validate(Form<?> form) {
                Integer min = (Integer)bfMinDelay.getConvertedInput();
                Integer max = (Integer)bfMaxDelay.getConvertedInput();
                if (max < min) {
                    form.error((Serializable)((Object)new ParamResourceModel("bfInvalidMinMax", (Component)AuthenticationPage.this.getPage(), new Object[0]).getString()));
                }
            }

            public FormComponent<?>[] getDependentFormComponents() {
                return new FormComponent[]{bfMinDelay, bfMaxDelay};
            }
        });
        TextField bfMaxBlockedThreads = new TextField("bfMaxBlockedThreads", (IModel)new PropertyModel((Object)this, "config.bruteForcePrevention.maxBlockedThreads"));
        bfMaxBlockedThreads.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.form.add(new Component[]{bfMaxBlockedThreads});
        this.form.add(new Component[]{new AuthenticationFiltersPanel("authFilters")});
        this.form.add(new Component[]{new HelpLink("authFiltersHelp").setDialog(this.dialog)});
        this.form.add(new Component[]{new AuthenticationProvidersPanel("authProviders")});
        this.form.add(new Component[]{new HelpLink("authProvidersHelp").setDialog(this.dialog)});
        this.form.add(new Component[]{new SecurityFilterChainsPanel("authChains", this.config)});
        this.form.add(new Component[]{new HelpLink("authChainsHelp").setDialog(this.dialog)});
        Component[] componentArray = new Component[1];
        this.authFilterChainPanel = new AuthFilterChainPanel("filterChain", (IModel<GeoServerSecurityFilterChain>)new PropertyModel((Object)this.form.getModel(), "filterChain"));
        componentArray[0] = this.authFilterChainPanel;
        this.form.add(componentArray);
        this.form.add(new Component[]{new HelpLink("filterChainHelp").setDialog(this.dialog)});
        this.form.add(new Component[]{new AuthenticationChainPanel("providerChain")});
        this.form.add(new Component[]{new HelpLink("providerChainHelp").setDialog(this.dialog)});
        this.form.add(new Component[]{new SubmitLink("save", this.form){

            public void onSubmit() {
                try {
                    AuthenticationPage.this.getSecurityManager().saveSecurityConfig((SecurityManagerConfig)this.getForm().getModelObject());
                    AuthenticationPage.this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)AuthenticationPage.this.logoutFilterConfig);
                    AuthenticationPage.this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)AuthenticationPage.this.sslFilterConfig);
                    AuthenticationPage.this.doReturn();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error saving authentication config", e);
                    this.error(e);
                }
            }
        }});
        this.form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                AuthenticationPage.this.doReturn();
            }
        }});
    }

    public void updateChainComponents() {
        this.form.replace((Component)new SecurityFilterChainsPanel("authChains", this.config));
    }

    class AuthFilterChainPanel
    extends FormComponentPanel<GeoServerSecurityFilterChain> {
        DropDownChoice<HTTPMethod> httpMethodChoice;
        TextField<String> urlPathField;
        TextField<String> chainTestResultField;
        String urlPath;
        String chainTestResult;
        HTTPMethod httpMethod;

        public AuthFilterChainPanel(String id, IModel<GeoServerSecurityFilterChain> model) {
            super(id, (IModel)new Model());
            this.httpMethod = HTTPMethod.GET;
            this.setOutputMarkupId(true);
            Component[] componentArray = new Component[1];
            this.urlPathField = new TextField("urlPath", (IModel)new PropertyModel((Object)this, "urlPath"));
            componentArray[0] = this.urlPathField;
            this.add(componentArray);
            this.urlPathField.setOutputMarkupId(true);
            this.urlPathField.add(new Behavior[]{new OnChangeAjaxBehavior(){

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
            Component[] componentArray2 = new Component[1];
            this.chainTestResultField = new TextField("chainTestResult", (IModel)new PropertyModel((Object)this, "chainTestResult"));
            componentArray2[0] = this.chainTestResultField;
            this.add(componentArray2);
            this.chainTestResultField.setEnabled(false);
            this.chainTestResultField.setOutputMarkupId(true);
            Component[] componentArray3 = new Component[1];
            this.httpMethodChoice = new DropDownChoice("httpMethod", (IModel)new PropertyModel((Object)this, "httpMethod"), Arrays.asList(HTTPMethod.values()));
            componentArray3[0] = this.httpMethodChoice;
            this.add(componentArray3);
            this.httpMethodChoice.setOutputMarkupId(true);
            this.httpMethodChoice.setNullValid(false);
            this.httpMethodChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
            this.add(new Component[]{new AjaxSubmitLink("chainTest"){

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    try {
                        String result = "NONE";
                        HttpServletRequest request = this.getHttpRequest();
                        for (RequestFilterChain chain : AuthenticationPage.this.config.getFilterChain().getRequestChains()) {
                            if (AuthFilterChainPanel.this.httpMethod == null || AuthFilterChainPanel.this.urlPath == null || !this.getProxy().matcherForChain(chain).matches(request)) continue;
                            result = chain.getName();
                            break;
                        }
                        AuthFilterChainPanel.this.chainTestResultField.getModel().setObject((Object)result);
                        target.add(new Component[]{AuthFilterChainPanel.this.chainTestResultField});
                    }
                    catch (Exception e) {
                        this.error(e);
                        LOGGER.log(Level.WARNING, "Connection error", e);
                        AuthenticationPage.this.addFeedbackPanels(target);
                    }
                }

                protected GeoServerSecurityFilterChainProxy getProxy() {
                    return (GeoServerSecurityFilterChainProxy)GeoServerExtensions.bean(GeoServerSecurityFilterChainProxy.class);
                }

                HttpServletRequest getHttpRequest() {
                    return new HttpServletRequest(){

                        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
                        }

                        public void setAttribute(String name, Object o) {
                        }

                        public void removeAttribute(String name) {
                        }

                        public boolean isSecure() {
                            return false;
                        }

                        public int getServerPort() {
                            return 0;
                        }

                        public String getServerName() {
                            return null;
                        }

                        public String getScheme() {
                            return null;
                        }

                        public RequestDispatcher getRequestDispatcher(String path) {
                            return null;
                        }

                        public int getRemotePort() {
                            return 0;
                        }

                        public String getRemoteHost() {
                            return null;
                        }

                        public String getRemoteAddr() {
                            return null;
                        }

                        public String getRealPath(String path) {
                            return null;
                        }

                        public BufferedReader getReader() throws IOException {
                            return null;
                        }

                        public String getProtocol() {
                            return null;
                        }

                        public String[] getParameterValues(String name) {
                            return null;
                        }

                        public Enumeration<String> getParameterNames() {
                            return null;
                        }

                        public Map<String, String[]> getParameterMap() {
                            return null;
                        }

                        public String getParameter(String name) {
                            return null;
                        }

                        public Enumeration<Locale> getLocales() {
                            return null;
                        }

                        public Locale getLocale() {
                            return null;
                        }

                        public int getLocalPort() {
                            return 0;
                        }

                        public ServletContext getServletContext() {
                            return null;
                        }

                        public AsyncContext startAsync() throws IllegalStateException {
                            return null;
                        }

                        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
                            return null;
                        }

                        public boolean isAsyncStarted() {
                            return false;
                        }

                        public boolean isAsyncSupported() {
                            return false;
                        }

                        public AsyncContext getAsyncContext() {
                            return null;
                        }

                        public DispatcherType getDispatcherType() {
                            return null;
                        }

                        public String getLocalName() {
                            return null;
                        }

                        public String getLocalAddr() {
                            return null;
                        }

                        public ServletInputStream getInputStream() throws IOException {
                            return null;
                        }

                        public String getContentType() {
                            return null;
                        }

                        public int getContentLength() {
                            return 0;
                        }

                        public String getCharacterEncoding() {
                            return null;
                        }

                        public Enumeration<String> getAttributeNames() {
                            return null;
                        }

                        public Object getAttribute(String name) {
                            return null;
                        }

                        public boolean isUserInRole(String role) {
                            return false;
                        }

                        public boolean isRequestedSessionIdValid() {
                            return false;
                        }

                        public boolean isRequestedSessionIdFromUrl() {
                            return false;
                        }

                        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
                            return false;
                        }

                        public void login(String username, String password) throws ServletException {
                        }

                        public void logout() throws ServletException {
                        }

                        public Collection<Part> getParts() throws IOException, ServletException {
                            return null;
                        }

                        public Part getPart(String name) throws IOException, ServletException {
                            return null;
                        }

                        public boolean isRequestedSessionIdFromURL() {
                            return false;
                        }

                        public boolean isRequestedSessionIdFromCookie() {
                            return false;
                        }

                        public Principal getUserPrincipal() {
                            return null;
                        }

                        public HttpSession getSession(boolean create) {
                            return null;
                        }

                        public HttpSession getSession() {
                            return null;
                        }

                        public String getServletPath() {
                            return "";
                        }

                        public String getRequestedSessionId() {
                            return null;
                        }

                        public StringBuffer getRequestURL() {
                            return null;
                        }

                        public String getRequestURI() {
                            return null;
                        }

                        public String getRemoteUser() {
                            return null;
                        }

                        public String getQueryString() {
                            if (AuthFilterChainPanel.this.urlPath == null || AuthFilterChainPanel.this.urlPath.indexOf("?") == -1) {
                                return null;
                            }
                            return AuthFilterChainPanel.this.urlPath.substring(AuthFilterChainPanel.this.urlPath.indexOf("?") + 1);
                        }

                        public String getPathTranslated() {
                            return null;
                        }

                        public String getPathInfo() {
                            if (AuthFilterChainPanel.this.urlPath == null || AuthFilterChainPanel.this.urlPath.indexOf("?") == -1) {
                                return AuthFilterChainPanel.this.urlPath;
                            }
                            return AuthFilterChainPanel.this.urlPath.substring(0, AuthFilterChainPanel.this.urlPath.indexOf("?"));
                        }

                        public String getMethod() {
                            return AuthFilterChainPanel.this.httpMethod.toString();
                        }

                        public int getIntHeader(String name) {
                            return 0;
                        }

                        public Enumeration<String> getHeaders(String name) {
                            return null;
                        }

                        public Enumeration<String> getHeaderNames() {
                            return null;
                        }

                        public String getHeader(String name) {
                            return null;
                        }

                        public long getDateHeader(String name) {
                            return 0L;
                        }

                        public Cookie[] getCookies() {
                            return null;
                        }

                        public String getContextPath() {
                            return null;
                        }

                        public String getAuthType() {
                            return null;
                        }
                    };
                }
            }.setDefaultFormProcessing(false)});
        }
    }

    class AuthenticationChainPanel
    extends FormComponentPanel<SecurityManagerConfig> {
        public AuthenticationChainPanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new AuthenticationChainPalette("authProviderNames")});
        }
    }
}

