/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.ConfirmRemovalNamedServicePanel;
import org.geoserver.security.web.SecurityNamedServiceEditPage;
import org.geoserver.security.web.SecurityNamedServiceNewPage;
import org.geoserver.security.web.SecurityNamedServicePanelInfo;
import org.geoserver.security.web.SecurityNamedServiceProvider;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public abstract class SecurityNamedServicesPanel<T extends SecurityNamedServiceConfig>
extends Panel {
    SecurityNamedServiceTablePanel<T> tablePanel;
    AjaxLink removeLink;
    FeedbackPanel feedbackPanel;
    GeoServerDialog dialog;

    public SecurityNamedServicesPanel(String id, SecurityNamedServiceProvider<T> dataProvider) {
        super(id);
        final boolean isAdmin = this.getSecurityManager().checkAuthenticationForAdminRole();
        this.add(new Component[]{new AjaxLink("add"){

            public void onClick(AjaxRequestTarget target) {
                SecurityNamedServiceNewPage newPage = new SecurityNamedServiceNewPage(SecurityNamedServicesPanel.this.getServiceClass());
                newPage.setReturnPage(this.getPage());
                this.setResponsePage((IRequestablePage)newPage);
            }
        }.setEnabled(isAdmin)});
        Component[] componentArray = new Component[1];
        this.removeLink = new RemoveLink();
        componentArray[0] = this.removeLink;
        this.add(componentArray);
        this.removeLink.setEnabled(false);
        Component[] componentArray2 = new Component[1];
        this.tablePanel = new SecurityNamedServiceTablePanel<T>("table", dataProvider){

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                if (isAdmin) {
                    target.add(new Component[]{SecurityNamedServicesPanel.this.removeLink.setEnabled(!this.getSelection().isEmpty())});
                }
            }
        };
        componentArray2[0] = this.tablePanel;
        this.add(componentArray2);
        this.tablePanel.setOutputMarkupId(true);
        this.tablePanel.getTopPager().setVisible(false);
        this.add(new Component[]{this.tablePanel});
        Component[] componentArray3 = new Component[1];
        this.feedbackPanel = new FeedbackPanel("feedback");
        componentArray3[0] = this.feedbackPanel;
        this.add(componentArray3);
        this.feedbackPanel.setOutputMarkupId(true);
        Component[] componentArray4 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray4[0] = this.dialog;
        this.add(componentArray4);
    }

    public GeoServerSecurityManager getSecurityManager() {
        return GeoServerApplication.get().getSecurityManager();
    }

    void handleException(Exception e, Component target) {
        (target != null ? target : this.getPage()).error((Serializable)e);
    }

    protected abstract Class<?> getServiceClass();

    protected abstract void validateRemoveConfig(T var1) throws SecurityConfigException;

    protected abstract void removeConfig(T var1) throws Exception;

    SecurityNamedServicePanelInfo lookupPageInfo(SecurityNamedServiceConfig config) {
        Class<?> serviceClass = null;
        try {
            serviceClass = Class.forName(config.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ArrayList<SecurityNamedServicePanelInfo> pageInfos = new ArrayList<SecurityNamedServicePanelInfo>();
        for (SecurityNamedServicePanelInfo pageInfo : GeoServerApplication.get().getBeansOfType(SecurityNamedServicePanelInfo.class)) {
            Class<?> pageClass = pageInfo.getServiceClass();
            if (!pageClass.isAssignableFrom(serviceClass)) continue;
            pageInfos.add(pageInfo);
        }
        if (pageInfos.isEmpty()) {
            throw new RuntimeException("Unable to find page info for service config: " + config + ", service class: " + serviceClass);
        }
        if (pageInfos.size() > 1) {
            ArrayList l = new ArrayList(pageInfos);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                if (((SecurityNamedServicePanelInfo)((Object)it.next())).getServiceClass().equals(serviceClass)) continue;
                it.remove();
            }
            if (l.size() == 1) {
                return (SecurityNamedServicePanelInfo)((Object)l.get(0));
            }
            throw new RuntimeException("Found multiple page infos for service config: " + config + ", service class: " + serviceClass);
        }
        return (SecurityNamedServicePanelInfo)((Object)pageInfos.get(0));
    }

    void goToPage(SecurityNamedServicePanelInfo pageInfo, IModel model) {
        try {
            Class cc = pageInfo.getComponentClass();
            AbstractSecurityPage editPage = (AbstractSecurityPage)((Object)cc.getConstructor(IModel.class).newInstance(model));
            editPage.setReturnPage(this.getPage());
            this.setResponsePage((IRequestablePage)editPage);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create page for page info: " + (Object)((Object)pageInfo), e);
        }
    }

    protected void onBeforeRender() {
        this.tablePanel.clearSelection();
        this.removeLink.setEnabled(false);
        super.onBeforeRender();
    }

    private class RemoveLink
    extends AjaxLink {
        public RemoveLink() {
            super("remove");
        }

        public void onClick(AjaxRequestTarget target) {
            boolean ok = true;
            for (SecurityNamedServiceConfig config : SecurityNamedServicesPanel.this.tablePanel.getSelection()) {
                try {
                    SecurityNamedServicesPanel.this.validateRemoveConfig(config);
                }
                catch (Exception e) {
                    SecurityNamedServicesPanel.this.handleException(e, null);
                    ok = false;
                }
            }
            if (ok) {
                GeoServerDialog.DialogDelegate delegate = new GeoServerDialog.DialogDelegate(){

                    protected Component getContents(String id) {
                        return new ConfirmRemovalNamedServicePanel(id, SecurityNamedServicesPanel.this.tablePanel.getSelection());
                    }

                    protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                        for (SecurityNamedServiceConfig config : SecurityNamedServicesPanel.this.tablePanel.getSelection()) {
                            try {
                                SecurityNamedServicesPanel.this.removeConfig(config);
                                SecurityNamedServicesPanel.this.feedbackPanel.info((Serializable)((Object)(config.getName() + " removed")));
                                SecurityNamedServicesPanel.this.tablePanel.clearSelection();
                            }
                            catch (Exception e) {
                                SecurityNamedServicesPanel.this.handleException(e, (Component)SecurityNamedServicesPanel.this.feedbackPanel);
                            }
                        }
                        return true;
                    }

                    public void onClose(AjaxRequestTarget target) {
                        target.add(new Component[]{SecurityNamedServicesPanel.this.tablePanel});
                        target.add(new Component[]{SecurityNamedServicesPanel.this.feedbackPanel});
                    }
                };
                SecurityNamedServicesPanel.this.dialog.showOkCancel(target, delegate);
            }
            target.add(new Component[]{SecurityNamedServicesPanel.this.feedbackPanel});
        }
    }

    class SecurityNamedServiceTablePanel<T extends SecurityNamedServiceConfig>
    extends GeoServerTablePanel<T> {
        public SecurityNamedServiceTablePanel(String id, SecurityNamedServiceProvider<T> dataProvider) {
            super(id, dataProvider, true);
        }

        protected Component getComponentForProperty(String id, IModel<T> itemModel, GeoServerDataProvider.Property<T> property) {
            Object val;
            if (property == SecurityNamedServiceProvider.NAME) {
                return this.createEditLink(id, itemModel, property);
            }
            if (property instanceof SecurityNamedServiceProvider.ResourceBeanProperty && (val = property.getModel(itemModel).getObject()) != null) {
                return new Label(id, (IModel)new ResourceModel(val.toString(), val.toString()));
            }
            return new Label(id, property.getModel(itemModel));
        }

        Component createEditLink(String id, final IModel<T> model, GeoServerDataProvider.Property<T> property) {
            IModel cast = property.getModel(model);
            return new SimpleAjaxLink<Object>(id, cast){

                protected void onClick(AjaxRequestTarget target) {
                    SecurityNamedServiceEditPage editPage = new SecurityNamedServiceEditPage(model);
                    editPage.setReturnPage(this.getPage());
                    this.setResponsePage((IRequestablePage)editPage);
                }
            };
        }
    }
}

