/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityNamedServicePanel;
import org.geoserver.security.web.SecurityNamedServicePanelInfo;
import org.geotools.util.logging.Logging;

public class SecurityNamedServicePage<T extends SecurityNamedServiceConfig>
extends AbstractSecurityPage {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.security");
    protected SecurityNamedServicePanel<T> panel;

    protected StringResourceModel createTitleModel(Class<?> serviceClass) {
        return new StringResourceModel(serviceClass.getName() + ".title", (IModel)new Model());
    }

    protected StringResourceModel createTitleModel(SecurityNamedServicePanelInfo panelInfo) {
        return new StringResourceModel(panelInfo.getTitleKey(), (IModel)new Model());
    }

    protected StringResourceModel createDescriptionModel(SecurityNamedServicePanelInfo panelInfo) {
        return new StringResourceModel(panelInfo.getDescriptionKey(), (IModel)new Model());
    }

    protected StringResourceModel createShortTitleModel(SecurityNamedServicePanelInfo panelInfo) {
        return new StringResourceModel(panelInfo.getShortTitleKey(), (IModel)new Model());
    }

    protected SecurityNamedServicePanel<T> createPanel(String id, SecurityNamedServicePanelInfo panelInfo, IModel<T> config) {
        try {
            SecurityNamedServicePanel panel = (SecurityNamedServicePanel)((Object)panelInfo.getComponentClass().getConstructor(String.class, IModel.class).newInstance(id, config));
            return panel;
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    protected void handleSubmit(Form<?> form) {
        SecurityNamedServiceConfig config = (SecurityNamedServiceConfig)form.getModelObject();
        try {
            this.panel.doSave(config);
            this.doReturn();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error saving config", e);
            this.error(e);
        }
    }
}

