/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.GeoServerSecurityService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.web.SecurityNamedServicePage;
import org.geoserver.security.web.SecurityNamedServicePanelInfo;
import org.geoserver.web.GeoServerApplication;

public class SecurityNamedServiceNewPage<S extends GeoServerSecurityService, T extends SecurityNamedServiceConfig>
extends SecurityNamedServicePage<T> {
    Form<T> form;
    WebMarkupContainer panelContainer;

    public SecurityNamedServiceNewPage(Class<S> serviceClass) {
        this.add(new Component[]{new Label("title1", (Serializable)((Object)this.createTitleModel(serviceClass).getString()))});
        this.add(new Component[]{new Label("title2", (Serializable)((Object)this.createTitleModel(serviceClass).getString()))});
        List<SecurityNamedServicePanelInfo> panelInfos = this.lookupPanelInfos(serviceClass);
        AjaxLinkGroup<SecurityNamedServicePanelInfo> serviceLinks = new AjaxLinkGroup<SecurityNamedServicePanelInfo>("services", panelInfos){

            protected void populateItem(ListItem<SecurityNamedServicePanelInfo> item) {
                SecurityNamedServicePanelInfo panelInfo = (SecurityNamedServicePanelInfo)((Object)item.getModelObject());
                item.add(new Component[]{this.newLink("link", item.getModel()).add(new Component[]{new Label("title", (IModel)SecurityNamedServiceNewPage.this.createShortTitleModel(panelInfo))}).setEnabled(item.getIndex() > 0)});
                item.add(new Component[]{new Label("description", (IModel)SecurityNamedServiceNewPage.this.createDescriptionModel(panelInfo))});
            }

            @Override
            protected void onClick(AjaxLink<SecurityNamedServicePanelInfo> link, AjaxRequestTarget target) {
                SecurityNamedServiceNewPage.this.updatePanel((SecurityNamedServicePanelInfo)((Object)link.getModelObject()), target);
            }
        };
        this.add(new Component[]{new WebMarkupContainer("servicesContainer").add(new Component[]{serviceLinks}).setOutputMarkupId(true)});
        Component[] componentArray = new Component[1];
        this.form = new Form("form");
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.panelContainer = new WebMarkupContainer("panel");
        componentArray2[0] = this.panelContainer;
        this.form.add(componentArray2);
        this.panelContainer.setOutputMarkupId(true);
        this.form.add(new Component[]{new SubmitLink("save", this.form){

            public void onSubmit() {
                SecurityNamedServiceNewPage.this.handleSubmit(this.getForm());
            }
        }});
        this.form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                SecurityNamedServiceNewPage.this.doReturn();
            }
        }});
        this.updatePanel(panelInfos.get(0), null);
    }

    void updatePanel(SecurityNamedServicePanelInfo panelInfo, AjaxRequestTarget target) {
        T config = this.getConfig(panelInfo);
        config.setClassName(panelInfo.getServiceClass().getCanonicalName());
        this.form.setModel((IModel)new CompoundPropertyModel(config));
        this.panel = this.createPanel("content", panelInfo, new Model(config));
        if (this.panelContainer.get("content") != null) {
            this.panelContainer.remove("content");
        }
        this.panelContainer.add(new Component[]{this.panel});
        if (target != null) {
            target.add(new Component[]{this.panelContainer});
        }
    }

    private T getConfig(SecurityNamedServicePanelInfo panelInfo) {
        try {
            return (T)((SecurityNamedServiceConfig)panelInfo.getServiceConfigClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Unable to create config class: " + panelInfo.getServiceConfigClass(), (Throwable)e);
        }
    }

    List<SecurityNamedServicePanelInfo> lookupPanelInfos(Class<S> serviceClass) {
        ArrayList<SecurityNamedServicePanelInfo> panelInfos = new ArrayList<SecurityNamedServicePanelInfo>();
        for (SecurityNamedServicePanelInfo pageInfo : GeoServerApplication.get().getBeansOfType(SecurityNamedServicePanelInfo.class)) {
            if (!serviceClass.isAssignableFrom(pageInfo.getServiceClass())) continue;
            panelInfos.add(pageInfo);
        }
        if (panelInfos.isEmpty()) {
            throw new RuntimeException("Unable to find panel info for service class: " + serviceClass);
        }
        return panelInfos;
    }

    static abstract class AjaxLinkGroup<T>
    extends ListView<T> {
        public AjaxLinkGroup(String id, List<T> list) {
            super(id, list);
            this.setOutputMarkupId(true);
        }

        public AjaxLinkGroup(String id) {
            super(id);
            this.setOutputMarkupId(true);
        }

        protected AjaxLink<T> newLink(String id, IModel<T> model) {
            AjaxLink result = new AjaxLink<T>(id, model){

                public void onClick(AjaxRequestTarget target) {
                    this.visitChildren(AjaxLink.class, (component, visit) -> {
                        component.setEnabled(true);
                        target.add(new Component[]{component});
                        visit.dontGoDeeper();
                    });
                    this.setEnabled(false);
                    target.add(new Component[]{this});
                    this.onClick(this, target);
                }
            };
            result.setOutputMarkupId(true);
            return result;
        }

        protected abstract void onClick(AjaxLink<T> var1, AjaxRequestTarget var2);
    }
}

