/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.head.CssUrlReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptUrlReferenceHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.crs.DynamicCrsMapResource;
import org.geoserver.web.demo.ReprojectPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;
import org.geoserver.wms.WMS;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.util.Version;
import org.locationtech.jts.geom.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class SRSDescriptionPage
extends GeoServerBasePage
implements IHeaderContributor {
    private String jsSrs;
    private String jsBbox;
    private String jsUnit;
    private double jsMaxResolution;

    public void renderHead(IHeaderResponse headerResponse) {
        super.renderHead(headerResponse);
        String onLoadJsCall = "initMap('" + StringEscapeUtils.escapeEcmaScript((String)this.jsSrs) + "', '" + this.jsUnit + "', " + this.jsBbox + ", " + this.jsMaxResolution + ")";
        headerResponse.render((HeaderItem)new OnDomReadyHeaderItem((CharSequence)onLoadJsCall));
    }

    public SRSDescriptionPage(PageParameters params) {
        this.add(new Behavior[]{new Behavior(){

            public void renderHead(Component component, IHeaderResponse response) {
                HttpServletRequest req = SRSDescriptionPage.this.getGeoServerApplication().servletRequest(SRSDescriptionPage.this.getRequest());
                String baseUrl = ResponseUtils.baseURL((HttpServletRequest)req);
                response.render((HeaderItem)new CssUrlReferenceHeaderItem(ResponseUtils.buildURL((String)baseUrl, (String)"openlayers3/ol.css", null, (URLMangler.URLType)URLMangler.URLType.RESOURCE), null, null));
                response.render((HeaderItem)new JavaScriptUrlReferenceHeaderItem(ResponseUtils.buildURL((String)baseUrl, (String)"openlayers3/ol.js", null, (URLMangler.URLType)URLMangler.URLType.RESOURCE), null, false, "UTF-8", null));
            }
        }});
        Locale locale = this.getLocale();
        String code = params.get("code").toString();
        this.add(new Component[]{new Label("code", (Serializable)((Object)code))});
        String name = "";
        try {
            name = CRS.getAuthorityFactory((boolean)true).getDescriptionText(code).toString(this.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String wkt = "";
        String epsgWkt = "";
        this.add(new Component[]{new Label("crsName", (Serializable)((Object)name))});
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)code);
            wkt = crs.toString();
        }
        catch (Exception e) {
            wkt = "Error decoding CRS: " + e.getMessage();
        }
        try {
            String epsgOrderCode = WMS.toInternalSRS((String)code, (Version)new Version("1.3.0"));
            CoordinateReferenceSystem epsgCrs = CRS.decode((String)epsgOrderCode);
            epsgWkt = epsgCrs.toString();
        }
        catch (Exception e) {
            epsgWkt = "Error decoding CRS: " + e.getMessage();
        }
        InternationalString scope = null;
        InternationalString remarks = null;
        StringBuilder aovCoords = new StringBuilder();
        String areaOfValidity = "";
        this.jsBbox = "null";
        this.jsSrs = code;
        this.jsUnit = crs instanceof ProjectedCRS ? "m" : "degrees";
        CoordinateReferenceSystem mapCrs = crs;
        if (crs != null) {
            try {
                String unit = crs.getCoordinateSystem().getAxis(0).getUnit().toString();
                if ("ft".equals(unit) || "feets".equals(unit)) {
                    this.jsUnit = "feet";
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error trying to determine unit of measure", e);
            }
            scope = crs.getScope();
            remarks = crs.getRemarks();
            Extent domainOfValidity = crs.getDomainOfValidity();
            if (domainOfValidity != null) {
                double maxres;
                String bbox;
                double y2;
                double x2;
                double y1;
                double x1;
                areaOfValidity = domainOfValidity.getDescription() == null ? "" : domainOfValidity.getDescription().toString(locale);
                Collection geographicElements = domainOfValidity.getGeographicElements();
                for (GeographicExtent ex : geographicElements) {
                    aovCoords.append(" ").append(ex);
                }
                GeographicBoundingBox box = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)crs);
                double westBoundLongitude = box.getWestBoundLongitude();
                double eastBoundLongitude = box.getEastBoundLongitude();
                double southBoundLatitude = box.getSouthBoundLatitude();
                double northBoundLatitude = box.getNorthBoundLatitude();
                try {
                    Envelope envelope = new Envelope(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude);
                    MathTransform tr = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326"), (CoordinateReferenceSystem)crs, (boolean)true);
                    Envelope destEnvelope = JTS.transform((Envelope)envelope, null, (MathTransform)tr, (int)10);
                    x1 = destEnvelope.getMinX();
                    y1 = destEnvelope.getMinY();
                    x2 = destEnvelope.getMaxX();
                    y2 = destEnvelope.getMaxY();
                }
                catch (Exception e1) {
                    x1 = westBoundLongitude;
                    y1 = southBoundLatitude;
                    x2 = eastBoundLongitude;
                    y2 = northBoundLatitude;
                    this.jsSrs = "EPSG:4326";
                    try {
                        mapCrs = CRS.decode((String)"EPSG:4326");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.jsBbox = bbox = "[" + x1 + "," + y1 + "," + x2 + "," + y2 + "]";
                double width = x2 - x1;
                double height = y2 - y1;
                this.jsMaxResolution = maxres = this.getMaxResolution(width, height);
            }
        }
        this.add(new Component[]{new Label("crsScope", (Serializable)((Object)(scope == null ? "-" : scope.toString(locale))))});
        this.add(new Component[]{new Label("crsRemarks", (Serializable)((Object)(remarks == null ? "-" : remarks.toString(locale))))});
        ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        final String finalEpsgWkt = epsgWkt;
        tabs.add(new AbstractTab((IModel)new ParamResourceModel("epsgOrder", (Component)this, new Object[0])){

            public WebMarkupContainer getPanel(String panelId) {
                return new WKTPanel(panelId, (IModel<String>)new ParamResourceModel("epsgOrderDescription", (Component)SRSDescriptionPage.this, new Object[0]), (IModel<String>)new Model((Serializable)((Object)finalEpsgWkt)));
            }
        });
        final String finalWkt = wkt;
        tabs.add(new AbstractTab((IModel)new ParamResourceModel("internalOrder", (Component)this, new Object[0])){

            public WebMarkupContainer getPanel(String panelId) {
                return new WKTPanel(panelId, (IModel<String>)new ParamResourceModel("internalOrderDescription", (Component)SRSDescriptionPage.this, new Object[0]), (IModel<String>)new Model((Serializable)((Object)finalWkt)));
            }
        });
        TabbedPanel<ITab> wktTabs = new TabbedPanel<ITab>("wktTabs", tabs){

            protected String getTabContainerCssClass() {
                return "tab-row tab-row-compact";
            }
        };
        this.add(new Component[]{wktTabs});
        this.add(new Component[]{new Label("aovCoords", (Serializable)((Object)aovCoords.toString()))});
        this.add(new Component[]{new Label("aovDescription", (Serializable)((Object)areaOfValidity))});
        Image aovMap = new Image("aovMap", (IResource)new DynamicCrsMapResource(mapCrs), new IResource[0]);
        this.add(new Component[]{aovMap});
        this.add(new Component[]{new SimpleBookmarkableLink("reprojectFrom", ReprojectPage.class, (IModel)new ParamResourceModel("reprojectFrom", (Component)this, new Object[]{code}), new String[]{"fromSRS", code})});
        this.add(new Component[]{new SimpleBookmarkableLink("reprojectTo", ReprojectPage.class, (IModel)new ParamResourceModel("reprojectTo", (Component)this, new Object[]{code}), new String[]{"toSRS", code})});
    }

    private double getMaxResolution(double w, double h) {
        return 4.0 * ((w > h ? w : h) / 256.0);
    }

    class WKTPanel
    extends Panel {
        public WKTPanel(String id, IModel<String> wktDescriptionModel, IModel<String> wktModel) {
            super(id);
            Label wktDescription = new Label("wktDescription", wktDescriptionModel);
            this.add(new Component[]{wktDescription});
            MultiLineLabel wkt = new MultiLineLabel("wkt", wktModel);
            this.add(new Component[]{wkt});
        }
    }
}

