/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequest;
import org.geoserver.web.demo.DemoRequestResponse;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geotools.util.logging.Logging;

public class DemoRequestsPage
extends GeoServerBasePage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.demo");
    final Resource demoDir;
    private TextField<String> urlTextField;
    private CodeMirrorEditor body;
    private TextField<String> username;
    private PasswordTextField password;

    public DemoRequestsPage() {
        try {
            GeoServerResourceLoader loader = this.getGeoServer().getCatalog().getResourceLoader();
            this.demoDir = Resources.serializable((Resource)loader.get("demo"));
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Can't access demo requests directory: " + e.getMessage());
        }
        DemoRequest request = new DemoRequest(this.demoDir.path());
        this.setDefaultModel((IModel)new Model((Serializable)request));
        this.setUpDemoRequestsForm(this.demoDir);
    }

    DemoRequestsPage(Resource demoDir) {
        this.demoDir = Resources.serializable((Resource)demoDir);
        DemoRequest model = new DemoRequest(demoDir.path());
        this.setDefaultModel((IModel)new Model((Serializable)model));
        this.setUpDemoRequestsForm(demoDir);
    }

    private String getFileContents(String reqFileName) throws IOException {
        Resource file = this.demoDir.get(reqFileName);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.in()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private void setUpDemoRequestsForm(Resource demoDir) {
        IModel requestModel = this.getDefaultModel();
        Form demoRequestsForm = new Form("demoRequestsForm");
        demoRequestsForm.setOutputMarkupId(true);
        demoRequestsForm.setModel(requestModel);
        this.add(new Component[]{demoRequestsForm});
        List<String> demoList = this.getDemoList(demoDir);
        PropertyModel reqFileNameModel = new PropertyModel((Object)requestModel, "requestFileName");
        Select2DropDownChoice demoRequestsList = new Select2DropDownChoice("demoRequestsList", (IModel)reqFileNameModel, demoList, (IChoiceRenderer)new ChoiceRenderer<String>(){

            public String getIdValue(String obj, int index) {
                return obj;
            }

            public Object getDisplayValue(String obj) {
                return obj;
            }
        });
        demoRequestsForm.add(new Component[]{demoRequestsList});
        demoRequestsList.add(new Behavior[]{new AjaxFormSubmitBehavior(demoRequestsForm, "change", (DropDownChoice)demoRequestsList){
            final /* synthetic */ DropDownChoice val$demoRequestsList;
            {
                this.val$demoRequestsList = dropDownChoice;
                super(x0, x1);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                String contents;
                GeoServer gs;
                String reqFileName = this.val$demoRequestsList.getModelValue();
                HttpServletRequest httpServletRequest = DemoRequestsPage.this.getGeoServerApplication().servletRequest(DemoRequestsPage.this.getRequest());
                String proxyBaseUrl = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL");
                String baseUrl = StringUtils.isEmpty((CharSequence)proxyBaseUrl) ? (StringUtils.isEmpty((CharSequence)(proxyBaseUrl = (gs = DemoRequestsPage.this.getGeoServer()).getGlobal().getSettings().getProxyBaseUrl())) ? ResponseUtils.baseURL((HttpServletRequest)httpServletRequest) : proxyBaseUrl) : proxyBaseUrl;
                try {
                    contents = DemoRequestsPage.this.getFileContents(reqFileName);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Can't load demo file " + reqFileName, e);
                    throw new WicketRuntimeException("Can't load demo file " + reqFileName, (Throwable)e);
                }
                boolean demoRequestIsHttpGet = reqFileName.endsWith(".url");
                String service = reqFileName.substring(0, reqFileName.indexOf(95)).toLowerCase();
                if (demoRequestIsHttpGet) {
                    String url = ResponseUtils.appendPath((String[])new String[]{baseUrl, contents});
                    DemoRequestsPage.this.urlTextField.setModelObject((Object)url);
                    DemoRequestsPage.this.body.setModelObject((Object)"");
                } else {
                    String serviceUrl = ResponseUtils.appendPath((String[])new String[]{baseUrl, service});
                    DemoRequestsPage.this.urlTextField.setModelObject((Object)serviceUrl);
                    DemoRequestsPage.this.body.setModelObject((Object)contents);
                }
                DemoRequestsPage.this.setResponsePage((IRequestablePage)DemoRequestsPage.this);
            }

            protected void onError(AjaxRequestTarget target) {
            }
        }});
        this.urlTextField = new TextField("url", (IModel)new PropertyModel((Object)requestModel, "requestUrl"));
        this.urlTextField.setMarkupId("requestUrl");
        this.urlTextField.setOutputMarkupId(true);
        demoRequestsForm.add(new Component[]{this.urlTextField});
        this.body = new CodeMirrorEditor("body", (IModel)new PropertyModel((Object)requestModel, "requestBody"));
        this.body.setTextAreaMarkupId("requestBody");
        demoRequestsForm.add(new Component[]{this.body});
        this.username = new TextField("username", (IModel)new PropertyModel((Object)requestModel, "userName"));
        demoRequestsForm.add(new Component[]{this.username});
        this.password = new PasswordTextField("password", (IModel)new PropertyModel((Object)requestModel, "password"));
        this.password.setRequired(false);
        demoRequestsForm.add(new Component[]{this.password});
        final ModalWindow responseWindow = new ModalWindow("responseWindow");
        this.add(new Component[]{responseWindow});
        responseWindow.setCookieName("demoResponse");
        responseWindow.setPageCreator((ModalWindow.PageCreator & Serializable)() -> new DemoRequestResponse(requestModel));
        demoRequestsForm.add(new Component[]{new AjaxSubmitLink("submit", demoRequestsForm){

            public void onSubmit(AjaxRequestTarget target, Form testWfsPostForm) {
                responseWindow.show((IPartialPageRequestHandler)target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(new AjaxCallListener(){

                    public CharSequence getBeforeHandler(Component component) {
                        return "document.getElementById('requestBody').value = document.gsEditors.requestBody.getValue();";
                    }
                });
            }
        }});
    }

    private List<String> getDemoList(Resource demoDir) {
        ArrayList<String> demoList = new ArrayList<String>();
        for (Resource file : demoDir.list()) {
            if (file.getType() == Resource.Type.DIRECTORY) continue;
            String name = file.name();
            if (name.endsWith(".url") || name.endsWith(".xml")) {
                demoList.add(name);
                continue;
            }
            LOGGER.warning("Ignoring file " + name + " in demo requests directory, only .url and .xml files allowed");
        }
        Collections.sort(demoList);
        return demoList;
    }
}

