/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.catalogstresstool;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.catalog.impl.WMSStoreInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.ToolPage;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;

public class CatalogStressTester
extends GeoServerSecuredPage {
    static final Logger LOGGER = Logging.getLogger(CatalogStressTester.class);
    DropDownChoice<Tuple> workspace;
    DropDownChoice<Tuple> store;
    DropDownChoice<Tuple> resourceAndLayer;
    TextField<Integer> duplicateCount;
    TextField<String> sufix;
    Label progress;
    AjaxButton startLink;
    private CheckBox recursive;

    public CatalogStressTester() {
        this.setDefaultModel((IModel)new Model());
        Form form = new Form("form", (IModel)new Model());
        this.add(new Component[]{form});
        WorkspacesTestModel wsModel = new WorkspacesTestModel();
        this.workspace = new DropDownChoice("workspace", (IModel)new Model(), (IModel)wsModel, (IChoiceRenderer)new TupleChoiceRenderer());
        this.workspace.setNullValid(true);
        this.workspace.setOutputMarkupId(true);
        this.workspace.setRequired(true);
        form.add(new Component[]{this.workspace});
        this.workspace.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = -5613056077847641106L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{CatalogStressTester.this.store});
                target.add(new Component[]{CatalogStressTester.this.resourceAndLayer});
            }
        }});
        StoresTestModel storesModel = new StoresTestModel();
        this.store = new DropDownChoice("store", (IModel)new Model(), (IModel)storesModel, (IChoiceRenderer)new TupleChoiceRenderer());
        this.store.setNullValid(true);
        this.store.setOutputMarkupId(true);
        this.store.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = -5333344688588590014L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{CatalogStressTester.this.resourceAndLayer});
            }
        }});
        form.add(new Component[]{this.store});
        ResourcesTestModel resourcesModel = new ResourcesTestModel();
        this.resourceAndLayer = new DropDownChoice("resourceAndLayer", (IModel)new Model(), (IModel)resourcesModel, (IChoiceRenderer)new TupleChoiceRenderer());
        this.resourceAndLayer.setNullValid(true);
        this.resourceAndLayer.setOutputMarkupId(true);
        form.add(new Component[]{this.resourceAndLayer});
        this.recursive = new CheckBox("recursive", (IModel)new Model((Serializable)Boolean.FALSE));
        form.add(new Component[]{this.recursive});
        this.duplicateCount = new TextField("duplicateCount", (IModel)new Model((Serializable)Integer.valueOf(100)), Integer.class);
        this.duplicateCount.setRequired(true);
        this.duplicateCount.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100000)));
        form.add(new Component[]{this.duplicateCount});
        this.sufix = new TextField("sufix", (IModel)new Model((Serializable)((Object)"-copy-")));
        this.sufix.setRequired(true);
        form.add(new Component[]{this.sufix});
        this.progress = new Label("progress", (IModel)new Model((Serializable)((Object)"0/0")));
        this.progress.setOutputMarkupId(true);
        form.add(new Component[]{this.progress});
        form.add(new Component[]{new AjaxButton("cancel"){
            private static final long serialVersionUID = 5767430648099432407L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                this.setResponsePage(ToolPage.class);
            }
        }});
        this.startLink = new AjaxButton("submit", form){
            private static final long serialVersionUID = -4087484089208211355L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                CatalogStressTester.this.progress.setDefaultModelObject((Object)"");
                CatalogStressTester.this.startLink.setVisible(false);
                target.add(new Component[]{CatalogStressTester.this.startLink});
                target.add(new Component[]{CatalogStressTester.this.progress});
                try {
                    CatalogStressTester.this.startCopy(target, form);
                }
                catch (Exception e) {
                    try {
                        form.error((Serializable)((Object)e.getMessage()));
                        target.add(new Component[]{form});
                    }
                    catch (Throwable throwable) {
                        CatalogStressTester.this.startLink.setVisible(true);
                        target.add(new Component[]{CatalogStressTester.this.startLink});
                        target.add(new Component[]{CatalogStressTester.this.progress});
                        throw throwable;
                    }
                    CatalogStressTester.this.startLink.setVisible(true);
                    target.add(new Component[]{CatalogStressTester.this.startLink});
                    target.add(new Component[]{CatalogStressTester.this.progress});
                }
                CatalogStressTester.this.startLink.setVisible(true);
                target.add(new Component[]{CatalogStressTester.this.startLink});
                target.add(new Component[]{CatalogStressTester.this.progress});
            }
        };
        form.add(new Component[]{this.startLink});
        this.startLink.setOutputMarkupId(true);
    }

    private void startCopy(AjaxRequestTarget target, Form<?> form) {
        ResourceInfo original;
        Session.get().getFeedbackMessages().clear();
        this.addFeedbackPanels(target);
        boolean recursive = (Boolean)this.recursive.getModelObject();
        int numCopies = (Integer)this.duplicateCount.getModelObject();
        String s = (String)this.sufix.getModelObject();
        LayerInfo layer = null;
        Tuple modelObject = (Tuple)this.resourceAndLayer.getModelObject();
        if (modelObject != null) {
            original = this.getCatalog().getResource(modelObject.id, ResourceInfo.class);
            List layers = this.getCatalog().getLayers(original);
            if (!layers.isEmpty()) {
                layer = (LayerInfo)layers.get(0);
            }
        } else {
            modelObject = (Tuple)this.store.getModelObject();
            if (modelObject != null) {
                original = this.getCatalog().getStore(modelObject.id, StoreInfo.class);
            } else {
                modelObject = (Tuple)this.workspace.getModelObject();
                if (modelObject != null) {
                    original = this.getCatalog().getWorkspace(modelObject.id);
                } else {
                    throw new IllegalStateException();
                }
            }
        }
        LOGGER.info("Creating " + numCopies + " copies of " + original + " with sufix " + s);
        Catalog catalog = this.getCatalog();
        Class<CatalogInfo> clazz = this.interfaceOf((CatalogInfo)original);
        Stopwatch globalTime = Stopwatch.createUnstarted();
        Stopwatch sw = Stopwatch.createUnstarted();
        sw.start();
        int padLength = (int)Math.ceil(Math.log10(numCopies));
        for (int curr = 0; curr < numCopies; ++curr) {
            String paddedIndex = Strings.padStart((String)String.valueOf(curr), (int)padLength, (char)'0');
            String nameSuffix = s + paddedIndex;
            this.copyOne(catalog, (CatalogInfo)original, clazz, layer, nameSuffix, globalTime, recursive, null);
            if ((curr + 1) % 100 != 0) continue;
            sw.stop();
            LOGGER.info(String.format("inserted %s so far in %s (last 100 in %s)\n", curr + 1, globalTime, sw));
            sw.reset();
            sw.start();
        }
        String localizerString = this.getLocalizer().getString("CatalogStressTester.progressStatusMessage", (Component)this, "Inserted {0} copies of {1} in {2}");
        String progressMessage = MessageFormat.format(localizerString, numCopies, original, globalTime);
        LOGGER.info(progressMessage);
        this.progress.setDefaultModelObject((Object)progressMessage);
        target.add(new Component[]{this.progress});
    }

    private Class<? extends CatalogInfo> interfaceOf(CatalogInfo original) {
        Class[] interfaces;
        for (Class c : interfaces = new Class[]{LayerGroupInfo.class, LayerInfo.class, NamespaceInfo.class, WorkspaceInfo.class, StyleInfo.class, CoverageStoreInfo.class, DataStoreInfo.class, WMSStoreInfo.class, CoverageInfo.class, FeatureTypeInfo.class, WMSLayerInfo.class}) {
            if (!c.isAssignableFrom(original.getClass())) continue;
            return c;
        }
        throw new IllegalArgumentException();
    }

    private void copyOne(Catalog catalog, CatalogInfo original, Class<CatalogInfo> clazz, LayerInfo layer, String nameSuffix, Stopwatch sw, boolean recursive, CatalogInfo parent) {
        CatalogInfo prototype = this.prototype(original, catalog);
        try {
            OwsUtils.set((Object)prototype, (String)"id", null);
            OwsUtils.copy((Object)clazz.cast(original), (Object)clazz.cast(prototype), clazz);
            String newName = OwsUtils.get((Object)prototype, (String)"name") + nameSuffix;
            OwsUtils.set((Object)prototype, (String)"name", (Object)newName);
            if (prototype instanceof WorkspaceInfo) {
                sw.start();
                catalog.add((WorkspaceInfo)prototype);
                sw.stop();
                String originalWsName = ((WorkspaceInfo)original).getName();
                NamespaceInfo ns = catalog.getNamespaceByPrefix(originalWsName);
                NamespaceInfoImpl ns2 = new NamespaceInfoImpl();
                ns2.setPrefix(newName);
                ns2.setURI(ns.getURI() + newName);
                sw.start();
                catalog.add((NamespaceInfo)ns2);
                sw.stop();
                if (recursive) {
                    for (StoreInfo store : catalog.getStoresByWorkspace((WorkspaceInfo)original, StoreInfo.class)) {
                        this.copyOne(catalog, (CatalogInfo)store, this.interfaceOf((CatalogInfo)store), null, nameSuffix, sw, true, prototype);
                    }
                }
            } else if (prototype instanceof StoreInfo) {
                sw.start();
                StoreInfo ps = (StoreInfo)prototype;
                if (parent != null) {
                    ps.setWorkspace((WorkspaceInfo)parent);
                }
                catalog.getResourcePool().dispose();
                catalog.add(ps);
                sw.stop();
                if (recursive) {
                    for (ResourceInfo resource : catalog.getResourcesByStore((StoreInfo)original, ResourceInfo.class)) {
                        LayerInfo resourceLayer = catalog.getLayerByName(resource.prefixedName());
                        this.copyOne(catalog, (CatalogInfo)resource, this.interfaceOf((CatalogInfo)resource), resourceLayer, nameSuffix, sw, true, prototype);
                    }
                }
            } else if (prototype instanceof ResourceInfo) {
                ((ResourceInfo)prototype).setNativeName(((ResourceInfo)original).getNativeName());
                ((ResourceInfo)prototype).setName(newName);
                if (parent != null) {
                    ResourceInfo ri = (ResourceInfo)prototype;
                    StoreInfo store = (StoreInfo)parent;
                    ri.setStore(store);
                    ri.setNamespace(catalog.getNamespaceByPrefix(store.getWorkspace().getName()));
                }
                sw.start();
                catalog.add((ResourceInfo)prototype);
                sw.stop();
                String id = prototype.getId();
                prototype = catalog.getResource(id, ResourceInfo.class);
                if (layer == null) {
                    return;
                }
                LayerInfoImpl layerCopy = new LayerInfoImpl();
                OwsUtils.copy(LayerInfo.class.cast(layer), (Object)layerCopy, LayerInfo.class);
                layerCopy.setResource((ResourceInfo)prototype);
                layerCopy.setId(null);
                sw.start();
                catalog.add((LayerInfo)layerCopy);
                sw.stop();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private CatalogInfo prototype(CatalogInfo original, Catalog catalog) {
        WorkspaceInfoImpl prototype;
        if (original instanceof WorkspaceInfo) {
            prototype = new WorkspaceInfoImpl();
        } else if (original instanceof DataStoreInfo) {
            prototype = new DataStoreInfoImpl(catalog);
        } else if (original instanceof CoverageStoreInfo) {
            prototype = new CoverageStoreInfoImpl(catalog);
        } else if (original instanceof WMSStoreInfo) {
            prototype = new WMSStoreInfoImpl((Catalog)((CatalogImpl)SecureCatalogImpl.unwrap((Object)catalog)));
        } else if (original instanceof FeatureTypeInfo) {
            prototype = new FeatureTypeInfoImpl(catalog);
        } else if (original instanceof CoverageInfo) {
            prototype = new CoverageInfoImpl(catalog);
        } else if (original instanceof WMSLayerInfo) {
            prototype = new WMSLayerInfoImpl((Catalog)((CatalogImpl)SecureCatalogImpl.unwrap((Object)catalog)));
        } else {
            throw new IllegalArgumentException(original.toString());
        }
        return prototype;
    }

    private class StoresTestModel
    extends LoadableDetachableModel<List<Tuple>> {
        private static final long serialVersionUID = 1L;

        private StoresTestModel() {
        }

        protected List<Tuple> load() {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            Tuple ws = (Tuple)CatalogStressTester.this.workspace.getModelObject();
            if (ws == null) {
                return Lists.newArrayList();
            }
            Filter filter = Predicates.equal((String)"workspace.id", (Object)ws.id);
            int limit = 100;
            try (CloseableIterator iter = catalog.list(StoreInfo.class, filter, null, Integer.valueOf(limit), null);){
                ArrayList stores = Lists.newArrayList((Iterator)Iterators.transform((Iterator)iter, input -> new Tuple(input.getId(), input.getName())));
                Collections.sort(stores);
                ArrayList arrayList = stores;
                return arrayList;
            }
        }
    }

    private class ResourcesTestModel
    extends LoadableDetachableModel<List<Tuple>> {
        private static final long serialVersionUID = 1L;

        private ResourcesTestModel() {
        }

        protected List<Tuple> load() {
            Catalog catalog = CatalogStressTester.this.getCatalog();
            Tuple storeInfo = (Tuple)CatalogStressTester.this.store.getModelObject();
            if (storeInfo == null) {
                return Lists.newArrayList();
            }
            Integer limit = 100;
            Filter filter = Predicates.equal((String)"store.id", (Object)storeInfo.id);
            try (CloseableIterator iter = catalog.list(ResourceInfo.class, filter, null, limit, null);){
                ArrayList resources = Lists.newArrayList((Iterator)Iterators.transform((Iterator)iter, input -> new Tuple(input.getId(), input.getName())));
                Collections.sort(resources);
                ArrayList arrayList = resources;
                return arrayList;
            }
        }
    }

    private static class WorkspacesTestModel
    extends LoadableDetachableModel<List<Tuple>> {
        private static final long serialVersionUID = 1L;

        private WorkspacesTestModel() {
        }

        protected List<Tuple> load() {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            Filter filter = Predicates.acceptAll();
            try (CloseableIterator list = catalog.list(WorkspaceInfo.class, filter, null, Integer.valueOf(4000), null);){
                ArrayList workspaces = Lists.newArrayList((Iterator)Iterators.transform((Iterator)list, input -> new Tuple(input.getId(), input.getName())));
                Collections.sort(workspaces);
                ArrayList arrayList = workspaces;
                return arrayList;
            }
        }
    }

    private static class TupleChoiceRenderer
    extends ChoiceRenderer<Tuple> {
        private static final long serialVersionUID = 1L;

        private TupleChoiceRenderer() {
        }

        public Object getDisplayValue(Tuple object) {
            return object.name;
        }

        public String getIdValue(Tuple object, int index) {
            return object.id;
        }
    }

    private static final class Tuple
    implements Serializable,
    Comparable<Tuple> {
        private static final long serialVersionUID = 1L;
        final String id;
        final String name;

        public Tuple(String id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public int compareTo(Tuple o) {
            return this.name.compareTo(o.name);
        }
    }
}

