/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config.wms;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.geotools.http.HTTPClientFinder;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.xml.Dimension;
import org.geotools.ows.wms.xml.Extent;
import org.geotools.util.PreventLocalEntityResolver;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.DefaultingConfiguration;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.legends.LegendRawInfo;
import org.geowebcache.config.legends.LegendsRawInfo;
import org.geowebcache.config.wms.parameters.NaiveWMSDimensionFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class GetCapabilitiesConfiguration
implements TileLayerConfiguration,
GridSetConfiguration {
    private static Logger log = Logging.getLogger((String)GetCapabilitiesConfiguration.class.getName());
    private static final Pattern LEGEND_WIDTH_PATTERN = Pattern.compile(".*width=(\\d+).*", 2);
    private static final Pattern LEGEND_HEIGHT_PATTERN = Pattern.compile(".*height=(\\d+).*", 2);
    private static final Pattern LEGEND_FORMAT_PATTERN = Pattern.compile(".*format=([^&]+).*", 2);
    private GridSetBroker gridSetBroker;
    private String url = null;
    private int backendTimeout = 120;
    private String mimeTypes = null;
    private String metaTiling = null;
    private String vendorParameters = null;
    private Map<String, String> cachedParameters = null;
    private boolean allowCacheBypass = false;
    private final HashMap<String, TileLayer> layers;
    private DefaultingConfiguration primaryConfig;
    private Map<String, GridSet> generatedGridSets = new HashMap<String, GridSet>();

    public GetCapabilitiesConfiguration(GridSetBroker gridSetBroker, String url, String mimeTypes, String metaTiling, String allowCacheBypass) {
        this.gridSetBroker = gridSetBroker;
        this.url = url;
        this.mimeTypes = mimeTypes;
        this.metaTiling = metaTiling;
        this.layers = new HashMap();
        if (Boolean.parseBoolean(allowCacheBypass)) {
            this.allowCacheBypass = true;
        }
        log.info("Constructing from url " + url);
    }

    public GetCapabilitiesConfiguration(GridSetBroker gridSetBroker, String url, String mimeTypes, String metaTiling, String vendorParameters, String allowCacheBypass) {
        this.gridSetBroker = gridSetBroker;
        this.url = url;
        this.mimeTypes = mimeTypes;
        this.metaTiling = metaTiling;
        this.vendorParameters = vendorParameters;
        this.layers = new HashMap();
        if (Boolean.parseBoolean(allowCacheBypass)) {
            this.allowCacheBypass = true;
        }
        log.info("Constructing from url " + url);
    }

    public GetCapabilitiesConfiguration(GridSetBroker gridSetBroker, String url, String mimeTypes, String metaTiling, String vendorParameters, Map<String, String> cachedParameters, String allowCacheBypass) {
        this(gridSetBroker, url, mimeTypes, metaTiling, vendorParameters, allowCacheBypass);
        this.cachedParameters = cachedParameters;
    }

    public void setBackendTimeout(int backendTimeout) {
        this.backendTimeout = backendTimeout;
    }

    public String getIdentifier() {
        return this.url;
    }

    private synchronized List<TileLayer> getTileLayers(boolean reload) throws GeoWebCacheException {
        WebMapServer wms;
        try {
            wms = this.getWMS();
        }
        catch (IOException | ServiceException e) {
            throw new ConfigurationException("Could not retrieve (or parse) GetCapaibilities " + this.url + " :" + e.getMessage(), e);
        }
        String wmsUrl = this.getWMSUrl(wms);
        log.info("Using GetCapabilities " + wmsUrl + " to generate URLs for WMS requests");
        String urlVersion = this.parseVersion(this.url);
        List<TileLayer> layers = this.getLayers(wms, wmsUrl, urlVersion);
        if (layers == null || layers.isEmpty()) {
            log.log(Level.SEVERE, "Unable to find any layers based on " + this.url);
        } else {
            log.info("Loaded " + layers.size() + " layers from " + this.url);
        }
        return layers;
    }

    private String getWMSUrl(WebMapServer wms) {
        String preQuery;
        String wmsUrl = wms.getCapabilities().getRequest().getGetCapabilities().getGet().toString();
        int queryStart = wmsUrl.lastIndexOf("?");
        if (queryStart > 0 && (preQuery = wmsUrl.substring(queryStart)).equalsIgnoreCase("?service=wms&")) {
            wmsUrl = wmsUrl.substring(0, wmsUrl.lastIndexOf("?"));
        }
        return wmsUrl;
    }

    private List<TileLayer> getLayers(WebMapServer wms, String wmsUrl, String urlVersion) throws GeoWebCacheException {
        LinkedList<TileLayer> layers = new LinkedList<TileLayer>();
        WMSCapabilities capabilities = wms.getCapabilities();
        if (capabilities == null) {
            throw new ConfigurationException("Unable to get capabitilies from " + wmsUrl);
        }
        WMSHttpHelper sourceHelper = new WMSHttpHelper();
        List layerList = capabilities.getLayerList();
        for (Layer layer : layerList) {
            String name = layer.getName();
            String stylesStr = "";
            String title = layer.getTitle();
            String description = layer.get_abstract();
            LayerMetaInformation layerMetaInfo = null;
            if (title != null || description != null) {
                layerMetaInfo = new LayerMetaInformation(title, description, null, null);
            }
            boolean queryable = layer.isQueryable();
            if (name == null) continue;
            LinkedList<ParameterFilter> paramFilters = new LinkedList<ParameterFilter>();
            List styles = layer.getStyles();
            StringBuffer buf = new StringBuffer();
            if (styles != null) {
                Iterator iter = styles.iterator();
                boolean hasOne = false;
                while (iter.hasNext()) {
                    if (hasOne) {
                        buf.append(",");
                    }
                    buf.append(((StyleImpl)iter.next()).getName());
                    hasOne = true;
                }
                stylesStr = buf.toString();
                StringParameterFilter stylesParameterFilter = new StringParameterFilter();
                stylesParameterFilter.setKey("STYLES");
                stylesParameterFilter.setValues(styles.stream().map(StyleImpl::getName).collect(Collectors.toList()));
                paramFilters.add((ParameterFilter)stylesParameterFilter);
            }
            double minX = layer.getLatLonBoundingBox().getMinX();
            double minY = layer.getLatLonBoundingBox().getMinY();
            double maxX = layer.getLatLonBoundingBox().getMaxX();
            double maxY = layer.getLatLonBoundingBox().getMaxY();
            BoundingBox bounds4326 = new BoundingBox(minX, minY, maxX, maxY);
            log.info("Found layer: " + layer.getName() + " with LatLon bbox " + bounds4326.toString());
            BoundingBox bounds3785 = new BoundingBox(this.longToSphericalMercatorX(minX), this.latToSphericalMercatorY(minY), this.longToSphericalMercatorX(maxX), this.latToSphericalMercatorY(maxY));
            String[] wmsUrls = new String[]{wmsUrl};
            for (Dimension dimension : layer.getDimensions().values()) {
                Extent dimExtent = layer.getExtent(dimension.getName());
                paramFilters.add(new NaiveWMSDimensionFilter(dimension, dimExtent));
            }
            if (this.cachedParameters != null) {
                for (Map.Entry entry : this.cachedParameters.entrySet()) {
                    if ("".equals(entry.getKey())) continue;
                    RegexParameterFilter f = new RegexParameterFilter();
                    f.setRegex(".*");
                    f.setKey((String)entry.getKey());
                    f.setDefaultValue((String)entry.getValue());
                    paramFilters.add((ParameterFilter)f);
                }
            }
            WMSLayer wmsLayer = null;
            try {
                wmsLayer = this.getLayer(name, wmsUrls, bounds4326, bounds3785, stylesStr, queryable, layer.getBoundingBoxes(), paramFilters);
            }
            catch (GeoWebCacheException geoWebCacheException) {
                log.log(Level.SEVERE, "Error creating " + layer.getName() + ": " + geoWebCacheException.getMessage());
            }
            if (wmsLayer == null) continue;
            wmsLayer.setCacheBypassAllowed(this.allowCacheBypass);
            wmsLayer.setBackendTimeout(this.backendTimeout);
            wmsLayer.setMetaInformation(layerMetaInfo);
            if (urlVersion != null) {
                wmsLayer.setVersion(urlVersion);
            } else {
                String string = capabilities.getVersion();
                if (string != null && string.length() > 0) {
                    wmsLayer.setVersion(string);
                }
            }
            wmsLayer.setSourceHelper((WMSSourceHelper)sourceHelper);
            List list = layer.getMetadataURL();
            if (list != null && !list.isEmpty()) {
                ArrayList<MetadataURL> convertedMetadataURLs = new ArrayList<MetadataURL>();
                for (org.geotools.ows.wms.xml.MetadataURL metadataURL : list) {
                    convertedMetadataURLs.add(new MetadataURL(metadataURL.getType(), metadataURL.getFormat(), metadataURL.getUrl()));
                }
                wmsLayer.setMetadataURLs(convertedMetadataURLs);
            }
            wmsLayer.setLegends(this.extractLegendsInfo(styles));
            layers.add((TileLayer)wmsLayer);
        }
        return layers;
    }

    private LegendsRawInfo extractLegendsInfo(List<StyleImpl> styles) {
        LegendsRawInfo legendsRawInfo = new LegendsRawInfo();
        legendsRawInfo.setDefaultWidth(Integer.valueOf(20));
        legendsRawInfo.setDefaultHeight(Integer.valueOf(20));
        legendsRawInfo.setDefaultFormat("image/png");
        for (StyleImpl style : styles) {
            LegendRawInfo legendRawInfo = new LegendRawInfo();
            legendRawInfo.setStyle(style.getName());
            List legendUrls = style.getLegendURLs();
            if (legendUrls != null && !legendUrls.isEmpty()) {
                String legendUrl = (String)legendUrls.get(0);
                legendRawInfo.setWidth(this.extractIntegerParameter(legendUrl, LEGEND_WIDTH_PATTERN));
                legendRawInfo.setHeight(this.extractIntegerParameter(legendUrl, LEGEND_HEIGHT_PATTERN));
                legendRawInfo.setFormat(this.extractParameter(legendUrl, LEGEND_FORMAT_PATTERN));
                legendRawInfo.setCompleteUrl(legendUrl);
            }
            legendsRawInfo.addLegendRawInfo(legendRawInfo);
        }
        return legendsRawInfo;
    }

    private String extractParameter(String url, Pattern pattern) {
        Matcher matcher = pattern.matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private Integer extractIntegerParameter(String url, Pattern pattern) {
        String value = this.extractParameter(url, pattern);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    private WMSLayer getLayer(String name, String[] wmsurl, BoundingBox bounds4326, BoundingBox bounds3785, String stylesStr, boolean queryable, Map<String, CRSEnvelope> additionalBounds, List<ParameterFilter> paramFilters) throws GeoWebCacheException {
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>(2);
        grids.put(this.gridSetBroker.getWorldEpsg4326().getName(), GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bounds4326, (Integer)0, (Integer)30));
        grids.put(this.gridSetBroker.getWorldEpsg3857().getName(), GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg3857(), (BoundingBox)bounds3785, (Integer)0, (Integer)30));
        if (additionalBounds != null && !additionalBounds.isEmpty()) {
            for (CRSEnvelope env : additionalBounds.values()) {
                SRS srs = null;
                if (env.getEPSGCode() != null) {
                    srs = SRS.getSRS((String)env.getEPSGCode());
                }
                if (srs == null) {
                    log.log(Level.SEVERE, env.toString() + " has no EPSG code");
                    continue;
                }
                if (srs.getNumber() == 4326 || srs.getNumber() == 900913 || srs.getNumber() == 3857) {
                    log.fine("Skipping " + srs.toString() + " for " + name);
                    continue;
                }
                String gridSetName = name + ":" + srs.toString();
                BoundingBox extent = new BoundingBox(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
                GridSet gridSet = GridSetFactory.createGridSet((String)gridSetName, (SRS)srs, (BoundingBox)extent, (boolean)false, (int)25, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
                grids.put(gridSetName, GridSubsetFactory.createGridSubSet((GridSet)gridSet));
            }
        }
        ArrayList<Object> mimeFormats = null;
        if (this.mimeTypes != null) {
            SRS mimeFormatArray = this.mimeTypes.split(",");
            mimeFormats = new ArrayList(((String[])mimeFormatArray).length);
            for (SRS s : mimeFormatArray) {
                mimeFormats.add(s);
            }
        } else {
            mimeFormats = new ArrayList<Object>(3);
            mimeFormats.add("image/png");
            mimeFormats.add("image/png8");
            mimeFormats.add("image/jpeg");
        }
        String[] metaStrings = this.metaTiling.split("x");
        int[] metaWidthHeight = new int[]{Integer.parseInt(metaStrings[0]), Integer.parseInt(metaStrings[1])};
        return new WMSLayer(name, wmsurl, stylesStr, name, mimeFormats, grids, paramFilters, metaWidthHeight, this.vendorParameters, queryable, null);
    }

    WebMapServer getWMS() throws IOException, ServiceException {
        HashMap<String, PreventLocalEntityResolver> hints = new HashMap<String, PreventLocalEntityResolver>();
        hints.put("org.xml.sax.EntityResolver", PreventLocalEntityResolver.INSTANCE);
        return new WebMapServer(new URL(this.url), HTTPClientFinder.createClient(), hints);
    }

    private String parseVersion(String url) {
        String tmp = url.toLowerCase();
        int start = tmp.indexOf("version=");
        if (start == -1) {
            return null;
        }
        int stop = tmp.indexOf("&", start += "version=".length());
        if (stop > 0) {
            return tmp.substring(start, stop);
        }
        return tmp.substring(start);
    }

    private double longToSphericalMercatorX(double x) {
        return x / 180.0 * 2.003750834E7;
    }

    private double latToSphericalMercatorY(double y) {
        if (y > 85.05112) {
            y = 85.05112;
        }
        if (y < -85.05112) {
            y = -85.05112;
        }
        y = Math.PI / 180 * y;
        double tmp = 0.7853981633974483 + y / 2.0;
        return 2.003750834E7 * Math.log(Math.tan(tmp)) / Math.PI;
    }

    public void afterPropertiesSet() throws GeoWebCacheException {
        List<TileLayer> tileLayers = this.getTileLayers(true);
        Set brokerNames = this.gridSetBroker.getGridSetNames();
        for (TileLayer layer : tileLayers) {
            layer.initialize(this.gridSetBroker);
            if (this.primaryConfig != null) {
                this.primaryConfig.setDefaultValues(layer);
            } else if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "GetCapabilitiesConfiguration could not initialize a layer with default values as it does not have a global configuration to delegate to.");
            }
            this.layers.put(layer.getName(), layer);
            Map generatedForLayer = Sets.difference((Set)layer.getGridSubsets(), (Set)brokerNames).stream().map(arg_0 -> ((TileLayer)layer).getGridSubset(arg_0)).map(GridSubset::getGridSet).collect(Collectors.toMap(GridSet::getName, UnaryOperator.identity()));
            this.generatedGridSets.putAll(generatedForLayer);
        }
    }

    public Collection<? extends TileLayer> getLayers() {
        return Collections.unmodifiableList(new ArrayList<TileLayer>(this.layers.values()));
    }

    public Set<String> getLayerNames() {
        return new HashSet<String>(this.layers.keySet());
    }

    public boolean containsLayer(String layerName) {
        return this.getLayer(layerName) != null;
    }

    public Optional<TileLayer> getLayer(String layerName) {
        return Optional.ofNullable(this.layers.get(layerName));
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public void removeLayer(String layerName) throws NoSuchElementException {
        if (this.layers.remove(layerName) == null) {
            throw new NoSuchElementException("Layer " + layerName + " does not exist");
        }
    }

    public void modifyLayer(TileLayer tl) throws NoSuchElementException {
        throw new UnsupportedOperationException("modifyLayer is not supported by " + this.getClass().getSimpleName());
    }

    public void renameLayer(String oldName, String newName) throws NoSuchElementException, IllegalArgumentException {
        throw new UnsupportedOperationException("renameLayer is not supported by " + this.getClass().getSimpleName());
    }

    public boolean canSave(TileLayer tl) {
        return false;
    }

    public void addLayer(TileLayer tl) throws IllegalArgumentException {
        if (tl == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("This is a read only configuration object, can't add tile layer " + tl.getName());
    }

    protected DefaultingConfiguration getPrimaryConfig() {
        return this.primaryConfig;
    }

    public void setPrimaryConfig(DefaultingConfiguration primaryConfig) {
        this.primaryConfig = primaryConfig;
    }

    public String getLocation() {
        return this.url;
    }

    public void addGridSet(GridSet gridSet) throws IllegalArgumentException {
        if (gridSet == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException("This is a read only configuration object, can't add gridset " + gridSet.getName());
    }

    public void removeGridSet(String gridSetName) {
        throw new UnsupportedOperationException("This is a read only configuration object, can't add gridset " + gridSetName);
    }

    public Optional<GridSet> getGridSet(String name) throws NoSuchElementException {
        return Optional.ofNullable(this.generatedGridSets.get(name)).map(GridSet::new);
    }

    public Collection<GridSet> getGridSets() {
        return this.generatedGridSets.values().stream().map(GridSet::new).collect(Collectors.toList());
    }

    public void modifyGridSet(GridSet gridSet) throws NoSuchElementException, IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void renameGridSet(String oldName, String newName) throws NoSuchElementException, IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean canSave(GridSet gridset) {
        return false;
    }

    @Autowired
    public void setGridSetBroker(@Qualifier(value="gwcGridSetBroker") GridSetBroker broker) {
        this.gridSetBroker = broker;
    }

    public void deinitialize() throws Exception {
        this.generatedGridSets.clear();
        this.layers.clear();
    }
}

