/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import com.google.common.collect.Streams;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.util.logging.Logging;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.opengis.filter.Filter;

class UnconfiguredCachedLayersProvider
extends GeoServerDataProvider<TileLayer> {
    private static final long serialVersionUID = -8599398086587516574L;
    private static final Logger LOGGER = Logging.getLogger(UnconfiguredCachedLayersProvider.class);
    static final GeoServerDataProvider.Property<TileLayer> TYPE = new GeoServerDataProvider.AbstractProperty<TileLayer>("type"){
        private static final long serialVersionUID = 3215255763580377079L;

        public GWCIconFactory.CachedLayerType getPropertyValue(TileLayer item) {
            return GWCIconFactory.getCachedLayerType(item);
        }

        public Comparator<TileLayer> getComparator() {
            return (o1, o2) -> {
                GWCIconFactory.CachedLayerType r1 = this.getPropertyValue((TileLayer)o1);
                GWCIconFactory.CachedLayerType r2 = this.getPropertyValue((TileLayer)o2);
                return r1.compareTo(r2);
            };
        }
    };
    static final GeoServerDataProvider.Property<TileLayer> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    static final GeoServerDataProvider.Property<TileLayer> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    static final List<GeoServerDataProvider.Property<TileLayer>> PROPERTIES = Collections.unmodifiableList(Arrays.asList(TYPE, NAME, ENABLED));
    private GWCConfig defaults;
    private CachedSize cachedSize = new CachedSize();

    public UnconfiguredCachedLayersProvider() {
        this.defaults = GWC.get().getConfig().saneConfig().clone();
        this.defaults.setCacheLayersByDefault(true);
    }

    public Iterator<TileLayer> iterator(long first, long count) {
        Stream<TileLayer> stream = this.tileLayerStream(first, count);
        return new CloseableIteratorAdapter(stream.iterator(), () -> stream.close());
    }

    private Stream<TileLayer> tileLayerStream(long first, long count) {
        Stream<TileLayer> stream;
        SortParam sort = this.getSort();
        Filter filter = this.getFilter();
        if (sort == null) {
            stream = this.unconfiguredLayers(filter).skip(first).limit(count).map(this::createUnconfiguredTileLayer);
        } else {
            Comparator<TileLayer> comparator = this.getComparator(sort);
            stream = this.unconfiguredLayers(filter).map(this::createUnconfiguredTileLayer).sorted(comparator).skip(first).limit(count);
        }
        return stream;
    }

    public int fullSize() {
        return this.size(Predicates.acceptAll());
    }

    public long size() {
        return this.cachedSize.get();
    }

    private int size(Filter filter) {
        int size;
        try (Stream<PublishedInfo> unconfigured = this.unconfiguredLayers(filter);){
            size = (int)unconfigured.count();
        }
        return size;
    }

    protected List<TileLayer> getFilteredItems() {
        LOGGER.info("Should not be called, iterator() overridden");
        return this.tileLayerStream(0L, Long.MAX_VALUE).collect(Collectors.toList());
    }

    protected List<TileLayer> getItems() {
        LOGGER.info("should not be called, fullSize() and iterator() overridden");
        return this.unconfiguredLayers(Predicates.acceptAll()).map(this::createUnconfiguredTileLayer).collect(Collectors.toList());
    }

    private TileLayer createUnconfiguredTileLayer(PublishedInfo info) {
        return new GeoServerTileLayer(info, this.defaults, GWC.get().getGridSetBroker());
    }

    private Stream<PublishedInfo> unconfiguredLayers(Filter filter) {
        Catalog catalog = this.getCatalog();
        CloseableIterator layers = catalog.list(LayerInfo.class, filter);
        CloseableIterator groups = catalog.list(LayerGroupInfo.class, filter);
        Stream all = Stream.concat(Streams.stream((Iterator)layers), Streams.stream((Iterator)groups));
        all = (Stream)all.filter(this::isUnconfigured).onClose(() -> {
            layers.close();
            groups.close();
        });
        return all;
    }

    private boolean isUnconfigured(PublishedInfo info) {
        return !GWC.get().hasTileLayer((CatalogInfo)info);
    }

    protected List<GeoServerDataProvider.Property<TileLayer>> getProperties() {
        return PROPERTIES;
    }

    public IModel<TileLayer> newModel(TileLayer tileLayer) {
        return new UnconfiguredTileLayerDetachableModel(tileLayer.getName());
    }

    protected Comparator<TileLayer> getComparator(SortParam<?> sort) {
        return super.getComparator(sort);
    }

    private class UnconfiguredTileLayerDetachableModel
    extends LoadableDetachableModel<TileLayer> {
        private static final long serialVersionUID = -8920290470035166218L;
        private String name;

        public UnconfiguredTileLayerDetachableModel(String layerOrGroupName) {
            this.name = layerOrGroupName;
        }

        protected TileLayer load() {
            GWC gwc = GWC.get();
            GridSetBroker gridsets = gwc.getGridSetBroker();
            Catalog catalog = UnconfiguredCachedLayersProvider.this.getCatalog();
            LayerInfo layer = catalog.getLayerByName(this.name);
            if (layer != null) {
                return new GeoServerTileLayer((PublishedInfo)layer, UnconfiguredCachedLayersProvider.this.defaults, gridsets);
            }
            LayerGroupInfo layerGroup = catalog.getLayerGroupByName(this.name);
            return new GeoServerTileLayer((PublishedInfo)layerGroup, UnconfiguredCachedLayersProvider.this.defaults, gridsets);
        }
    }

    private class CachedSize
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final long NOT_CACHED = Long.MIN_VALUE;
        private String[] cachedSizeKeywords;
        private long cachedSize = Long.MIN_VALUE;

        private CachedSize() {
        }

        public long get() {
            if (this.cachedSize == Long.MIN_VALUE || !Arrays.equals(UnconfiguredCachedLayersProvider.this.keywords, this.cachedSizeKeywords)) {
                long size;
                this.cachedSize = size = (long)UnconfiguredCachedLayersProvider.this.size(UnconfiguredCachedLayersProvider.this.getFilter());
                this.cachedSizeKeywords = UnconfiguredCachedLayersProvider.this.keywords == null ? null : Arrays.copyOf(UnconfiguredCachedLayersProvider.this.keywords, UnconfiguredCachedLayersProvider.this.keywords.length);
                return size;
            }
            return this.cachedSize;
        }
    }
}

