/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.gwc.web.gridset.GridSetInfo;
import org.geoserver.web.wicket.DecimalTextField;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;

public class TileMatrixSetEditor
extends FormComponentPanel<List<Grid>> {
    private static final long serialVersionUID = 5098470663723800345L;
    private ListView<Grid> grids;
    private WebMarkupContainer table;
    private boolean readOnly;
    private IModel<GridSetInfo> info;

    public TileMatrixSetEditor(String id, IModel<GridSetInfo> info) {
        super(id, (IModel)new PropertyModel(info, "levels"));
        this.add(new TileMatrixSetValidator());
        IModel list = this.getModel();
        Preconditions.checkNotNull((Object)list.getObject());
        this.info = info;
        this.readOnly = ((GridSetInfo)info.getObject()).isInternal();
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        PropertyModel preserveesolutionsModel = new PropertyModel(info, "resolutionsPreserved");
        final RadioGroup resolutionsOrScales = new RadioGroup("useResolutionsOrScalesGroup", (IModel)preserveesolutionsModel);
        container.add(new Component[]{resolutionsOrScales});
        Radio preserveResolutions = new Radio("preserveResolutions", (IModel)new Model((Serializable)Boolean.TRUE));
        Radio preserveScales = new Radio("preserveScales", (IModel)new Model((Serializable)Boolean.FALSE));
        resolutionsOrScales.add(new Component[]{preserveResolutions});
        resolutionsOrScales.add(new Component[]{preserveScales});
        resolutionsOrScales.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                resolutionsOrScales.processInput();
                boolean useResolutions = (Boolean)resolutionsOrScales.getModelObject();
                for (ListItem next : TileMatrixSetEditor.this.grids) {
                    next.get("resolution").setEnabled(useResolutions);
                    next.get("scale").setEnabled(!useResolutions);
                }
                target.add(new Component[]{TileMatrixSetEditor.this.table});
            }
        }});
        this.table = new WebMarkupContainer("table");
        this.table.setOutputMarkupId(true);
        this.table.add(new Component[]{this.thLabel("level")});
        this.table.add(new Component[]{this.thLabel("resolution")});
        this.table.add(new Component[]{this.thLabel("scale")});
        this.table.add(new Component[]{this.thLabel("name")});
        this.table.add(new Component[]{this.thLabel("tiles")});
        container.add(new Component[]{this.table});
        this.grids = new GridLevelsListView((IModel<List<Grid>>)list, container, (IModel<Boolean>)preserveesolutionsModel);
        this.grids.setOutputMarkupId(true);
        this.grids.setReuseItems(true);
        this.table.add(new Component[]{this.grids});
    }

    private Component thLabel(String id) {
        Label label = new Label(id, (IModel)new ResourceModel(id));
        label.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel(id + ".title", ""))});
        return label;
    }

    public void convertInput() {
        List info = this.grids.getModelObject();
        if (info == null || info.isEmpty()) {
            this.setConvertedInput(new ArrayList(2));
            return;
        }
        this.setConvertedInput(info);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }

    public void addZoomLevel(ReferencedEnvelope bbox, int tileWidth, int tileHeight) {
        List list = this.grids.getModelObject();
        Grid newGrid = new Grid();
        if (list.isEmpty()) {
            BoundingBox extent = new BoundingBox(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
            boolean levels = true;
            GridSet tmpGridset = GridSetFactory.createGridSet((String)"stub", (SRS)SRS.getEPSG4326(), (BoundingBox)extent, (boolean)false, (int)1, (Double)1.0, (double)2.8E-4, (int)tileWidth, (int)tileHeight, (boolean)false);
            Grid grid = tmpGridset.getGrid(0);
            newGrid.setResolution(grid.getResolution());
            newGrid.setScaleDenominator(grid.getScaleDenominator());
        } else {
            Grid prev = (Grid)list.get(list.size() - 1);
            newGrid.setResolution(prev.getResolution() / 2.0);
            newGrid.setScaleDenominator(prev.getScaleDenominator() / 2.0);
        }
        list.add(newGrid);
        this.grids.setModelObject(list);
    }

    private class GridLevelsListView
    extends ListView<Grid> {
        private static final long serialVersionUID = 1L;
        private final WebMarkupContainer container;
        private final IModel<Boolean> preserveesolutionsModel;

        public GridLevelsListView(IModel<List<Grid>> list, WebMarkupContainer container, IModel<Boolean> preserveesolutionsModel) {
            super("gridLevels", new ArrayList((Collection)list.getObject()));
            this.container = container;
            this.preserveesolutionsModel = preserveesolutionsModel;
        }

        protected void onBeforeRender() {
            super.onBeforeRender();
        }

        protected void populateItem(ListItem<Grid> item) {
            Object removeLink;
            int index = item.getIndex();
            item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(index % 2 == 0 ? "even" : "odd")))});
            item.add(new Component[]{new Label("zoomLevel", (Serializable)((Object)String.valueOf(index)))});
            DecimalTextField resolution = new DecimalTextField("resolution", (IModel)new PropertyModel((Object)item.getModel(), "resolution"));
            resolution.setOutputMarkupId(true);
            item.add(new Component[]{resolution});
            DecimalTextField scale = new DecimalTextField("scale", (IModel)new PropertyModel((Object)item.getModel(), "scaleDenom"));
            scale.setOutputMarkupId(true);
            item.add(new Component[]{scale});
            TextField name = new TextField("name", (IModel)new PropertyModel((Object)item.getModel(), "name"));
            item.add(new Component[]{name});
            TilesModel tilesModel = new TilesModel((TextField<Double>)resolution);
            Label tiles = new Label("tiles", (IModel)tilesModel);
            tiles.setOutputMarkupId(true);
            item.add(new Component[]{tiles});
            if (TileMatrixSetEditor.this.readOnly) {
                removeLink = new Label("removeLink", (Serializable)((Object)""));
            } else {
                removeLink = new ImageAjaxLink<Void>("removeLink", GWCIconFactory.DELETE_ICON){
                    private static final long serialVersionUID = 1L;

                    protected void onClick(AjaxRequestTarget target) {
                        ArrayList list = new ArrayList(TileMatrixSetEditor.this.grids.getModelObject());
                        int index = (Integer)this.getDefaultModelObject();
                        list.remove(index);
                        TileMatrixSetEditor.this.grids.setModelObject(list);
                        target.add(new Component[]{GridLevelsListView.this.container});
                    }
                };
                removeLink.setDefaultModel((IModel)new Model((Serializable)Integer.valueOf(index)));
                removeLink.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel("TileMatrixSetEditor.removeLink"))});
            }
            item.add(new Component[]{removeLink});
            boolean isResolutionsPreserved = (Boolean)this.preserveesolutionsModel.getObject();
            resolution.setEnabled(isResolutionsPreserved);
            scale.setEnabled(!isResolutionsPreserved);
            resolution.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur", (TextField)resolution, (TextField)scale, tiles){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ TextField val$resolution;
                final /* synthetic */ TextField val$scale;
                final /* synthetic */ Label val$tiles;
                {
                    this.val$resolution = textField;
                    this.val$scale = textField2;
                    this.val$tiles = label;
                    super(x0);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    GridSetInfo gridSetInfo;
                    Double metersPerUnit;
                    this.val$resolution.processInput();
                    Double res = (Double)this.val$resolution.getModelObject();
                    Double scaleDenominator = null;
                    if (null != res && (metersPerUnit = (gridSetInfo = (GridSetInfo)TileMatrixSetEditor.this.info.getObject()).getMetersPerUnit()) != null) {
                        scaleDenominator = res * metersPerUnit / 2.8E-4;
                    }
                    this.val$scale.setModelObject(scaleDenominator);
                    target.add(new Component[]{this.val$resolution});
                    target.add(new Component[]{this.val$scale});
                    target.add(new Component[]{this.val$tiles});
                }
            }});
            scale.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur", (TextField)scale, (TextField)resolution, tiles){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ TextField val$scale;
                final /* synthetic */ TextField val$resolution;
                final /* synthetic */ Label val$tiles;
                {
                    this.val$scale = textField;
                    this.val$resolution = textField2;
                    this.val$tiles = label;
                    super(x0);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    this.val$scale.processInput();
                    Double scaleDenominator = (Double)this.val$scale.getModelObject();
                    Double res = null;
                    if (null != scaleDenominator) {
                        GridSetInfo gridSetInfo = (GridSetInfo)TileMatrixSetEditor.this.info.getObject();
                        double pixelSize = gridSetInfo.getPixelSize();
                        Double metersPerUnit = gridSetInfo.getMetersPerUnit();
                        if (metersPerUnit != null) {
                            res = pixelSize * scaleDenominator / metersPerUnit;
                        }
                    }
                    this.val$resolution.setModelObject(res);
                    target.add(new Component[]{this.val$resolution});
                    target.add(new Component[]{this.val$scale});
                    target.add(new Component[]{this.val$tiles});
                }
            }});
        }
    }

    private class TilesModel
    implements IModel<String> {
        private static final long serialVersionUID = 1L;
        private final TextField<Double> resolution;

        public TilesModel(TextField<Double> resolution) {
            this.resolution = resolution;
        }

        public String getObject() {
            Double res = (Double)this.resolution.getModelObject();
            GridSetInfo gridSetInfo = (GridSetInfo)TileMatrixSetEditor.this.info.getObject();
            ReferencedEnvelope extent = gridSetInfo.getBounds();
            if (res == null || extent == null) {
                return "--";
            }
            int tileWidth = gridSetInfo.getTileWidth();
            int tileHeight = gridSetInfo.getTileHeight();
            double mapUnitWidth = (double)tileWidth * res;
            double mapUnitHeight = (double)tileHeight * res;
            long tilesWide = (long)Math.ceil((extent.getWidth() - mapUnitWidth * 0.01) / mapUnitWidth);
            long tilesHigh = (long)Math.ceil((extent.getHeight() - mapUnitHeight * 0.01) / mapUnitHeight);
            NumberFormat nf = NumberFormat.getIntegerInstance();
            String tilesStr = nf.format(tilesWide) + " x " + nf.format(tilesHigh);
            return tilesStr;
        }

        public void detach() {
        }

        public void setObject(String object) {
        }
    }

    private static class TileMatrixSetValidator
    implements IValidator<List<Grid>> {
        private static final long serialVersionUID = 1L;

        private TileMatrixSetValidator() {
        }

        public void validate(IValidatable<List<Grid>> validatable) {
            List grids = (List)validatable.getValue();
            if (grids == null || grids.isEmpty()) {
                ValidationError error = new ValidationError();
                error.setMessage(new ResourceModel("TileMatrixSetEditor.validation.empty").getObject());
                validatable.error((IValidationError)error);
                return;
            }
            for (int i = 1; i < grids.size(); ++i) {
                Grid prev = (Grid)grids.get(i - 1);
                Grid curr = (Grid)grids.get(i);
                if (curr.getResolution() >= prev.getResolution()) {
                    ValidationError error = new ValidationError();
                    String message = "Each resolution should be lower than it's prior one. Res[" + i + "] == " + curr.getResolution() + ", Res[" + (i - 1) + "] == " + prev.getResolution() + ".";
                    error.setMessage(message);
                    validatable.error((IValidationError)error);
                    return;
                }
                if (!(curr.getScaleDenominator() >= prev.getScaleDenominator())) continue;
                ValidationError error = new ValidationError();
                String message = "Each scale denominator should be lower than it's prior one. Scale[" + i + "] == " + curr.getScaleDenominator() + ", Scale[" + (i - 1) + "] == " + prev.getScaleDenominator() + ".";
                error.setMessage(message);
                validatable.error((IValidationError)error);
                return;
            }
        }
    }
}

