/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.diskquota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteTextRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;

public class JDBCConnectionPoolPanel
extends Panel {
    private static final long serialVersionUID = -1579697287836672528L;

    public JDBCConnectionPoolPanel(String id, IModel<JDBCConfiguration.ConnectionPoolConfiguration> model) {
        super(id, model);
        TextField driver = new TextField("jdbcDriver", (IModel)new PropertyModel(model, "driver"));
        driver.setRequired(true);
        AutoCompleteSettings as = new AutoCompleteSettings();
        as.setPreselect(true).setShowListOnEmptyInput(true).setShowCompleteListOnFocusGain(true);
        driver.add(new Behavior[]{new ContainsAutoCompleteBehavior("org.postgresql.Driver", "oracle.jdbc.driver.OracleDriver", "org.h2.Driver")});
        this.add(new Component[]{driver});
        TextField url = new TextField("jdbcUrl", (IModel)new PropertyModel(model, "url"));
        url.setRequired(true);
        url.add(new Behavior[]{new ContainsAutoCompleteBehavior("jdbc:h2://{server}:{9092}/{db-name}", "jdbc:postgresql:[{//host}[:{5432}/]]{database}", "jdbc:oracle:thin:@{server}[:{1521}]:{database_name}")});
        this.add(new Component[]{url});
        TextField user = new TextField("jdbcUser", (IModel)new PropertyModel(model, "username"));
        this.add(new Component[]{user});
        PasswordTextField password = new PasswordTextField("jdbcPassword", (IModel)new PropertyModel(model, "password"));
        password.setResetPassword(false);
        this.add(new Component[]{password});
        TextField minConnections = new TextField("jdbcMinConnections", (IModel)new PropertyModel(model, "minConnections"));
        minConnections.setRequired(true);
        minConnections.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.add(new Component[]{minConnections});
        TextField maxConnections = new TextField("jdbcMaxConnections", (IModel)new PropertyModel(model, "maxConnections"));
        maxConnections.setRequired(true);
        maxConnections.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        this.add(new Component[]{maxConnections});
        TextField connectionTimeout = new TextField("jdbcConnectionTimeout", (IModel)new PropertyModel(model, "connectionTimeout"));
        connectionTimeout.setRequired(true);
        connectionTimeout.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        this.add(new Component[]{connectionTimeout});
        TextField validationQuery = new TextField("jdbcValidationQuery", (IModel)new PropertyModel(model, "validationQuery"));
        this.add(new Component[]{validationQuery});
        TextField maxOpenPreparedStatements = new TextField("jdbcMaxOpenPreparedStatements", (IModel)new PropertyModel(model, "maxOpenPreparedStatements"));
        maxOpenPreparedStatements.setRequired(true);
        maxOpenPreparedStatements.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        this.add(new Component[]{maxOpenPreparedStatements});
    }

    private static class ContainsAutoCompleteBehavior
    extends AutoCompleteBehavior<String> {
        private static final long serialVersionUID = 993566054116148859L;
        private List<String> choices;

        public ContainsAutoCompleteBehavior(List<String> choices) {
            super((IAutoCompleteRenderer)new AbstractAutoCompleteTextRenderer<String>(){
                private static final long serialVersionUID = 3192368880726583011L;

                protected String getTextValue(String object) {
                    return object;
                }
            });
            this.settings.setPreselect(true).setShowListOnEmptyInput(true).setShowCompleteListOnFocusGain(true);
            this.choices = new ArrayList<String>(choices);
        }

        public ContainsAutoCompleteBehavior(String ... choices) {
            this(Arrays.asList(choices));
        }

        protected Iterator<String> getChoices(String input) {
            String ucInput = input.toUpperCase();
            ArrayList<String> result = new ArrayList<String>();
            for (String choice : this.choices) {
                if (!choice.toUpperCase().contains(ucInput)) continue;
                result.add(choice);
            }
            return result.iterator();
        }
    }
}

