/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.diskquota;

import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.gwc.ConfigurableQuotaStoreProvider;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.diskquota.DiskQuotaConfigPanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.image.io.ImageIOExt;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.storage.StorageUnit;

public class DiskQuotaSettingsPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 75816375328629448L;

    public DiskQuotaSettingsPage() throws Exception {
        JDBCConfiguration jdbcQuotaConfiguration;
        DiskQuotaConfig diskQuotaConfig;
        GWC gwc = this.getGWC();
        final boolean diskQuotaModuleDisabled = gwc.getDiskQuotaConfig() == null;
        ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)GeoServerApplication.get().getBeanOfType(ConfigurableQuotaStoreProvider.class);
        if (provider.getException() != null) {
            ParamResourceModel rm = new ParamResourceModel("GWC.diskQuotaLoadFailed", null, new Object[]{provider.getException().getMessage()});
            this.error((Serializable)((Object)rm.getString()));
        }
        if (diskQuotaModuleDisabled) {
            diskQuotaConfig = new DiskQuotaConfig();
            diskQuotaConfig.setDefaults();
        } else {
            diskQuotaConfig = gwc.getDiskQuotaConfig().clone();
        }
        if (gwc.getJDBCDiskQuotaConfig() == null) {
            jdbcQuotaConfiguration = new JDBCConfiguration();
            JDBCConfiguration.ConnectionPoolConfiguration configuration = new JDBCConfiguration.ConnectionPoolConfiguration();
            configuration.setMinConnections(1);
            configuration.setMaxConnections(10);
            configuration.setConnectionTimeout(10000);
            configuration.setMaxOpenPreparedStatements(50);
            jdbcQuotaConfiguration.setConnectionPool(configuration);
        } else {
            jdbcQuotaConfiguration = gwc.getJDBCDiskQuotaConfig();
        }
        final Form form = new Form("form");
        this.add(new Component[]{form});
        Model diskQuotaModel = new Model((Serializable)diskQuotaConfig);
        Model jdbcQuotaModel = new Model((Serializable)jdbcQuotaConfiguration);
        final DiskQuotaConfigPanel diskQuotaConfigPanel = new DiskQuotaConfigPanel("diskQuotaPanel", (IModel<DiskQuotaConfig>)diskQuotaModel, (IModel<JDBCConfiguration>)jdbcQuotaModel);
        if (diskQuotaModuleDisabled) {
            diskQuotaConfigPanel.setEnabled(false);
            super.warn((Serializable)((Object)new ResourceModel("DiskQuotaSettingsPage.disabledWarning").getObject()));
        }
        form.add(new Component[]{diskQuotaConfigPanel});
        form.add(new Component[]{new Button("submit", (IModel)diskQuotaModel, (IModel)jdbcQuotaModel){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$diskQuotaModel;
            final /* synthetic */ IModel val$jdbcQuotaModel;
            {
                this.val$diskQuotaModel = iModel;
                this.val$jdbcQuotaModel = iModel2;
                super(x0);
            }

            public void onSubmit() {
                GWC gwc = DiskQuotaSettingsPage.this.getGWC();
                if (!diskQuotaModuleDisabled) {
                    Double chosenQuota;
                    StorageUnit chosenUnit = diskQuotaConfigPanel.getStorageUnit();
                    String chosenQuotaStr = String.valueOf(diskQuotaConfigPanel.getQuotaValue());
                    try {
                        chosenQuota = Double.valueOf(chosenQuotaStr);
                    }
                    catch (NumberFormatException e) {
                        form.error((Serializable)((Object)(chosenQuotaStr + " is not a valid floating point number")));
                        return;
                    }
                    if (chosenQuota <= 0.0) {
                        form.error((Serializable)((Object)"Quota has to be > 0"));
                        return;
                    }
                    DiskQuotaConfig dqConfig = (DiskQuotaConfig)this.val$diskQuotaModel.getObject();
                    JDBCConfiguration jdbcConfig = (JDBCConfiguration)this.val$jdbcQuotaModel.getObject();
                    if (dqConfig.getQuotaStore() != null && dqConfig.getQuotaStore().equals("JDBC")) {
                        try {
                            gwc.testQuotaConfiguration(jdbcConfig);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "Error instantiating the JDBC configuration", e);
                            this.error((Serializable)((Object)("Failure occurred while saving the JDBC configuration" + e.getMessage() + " (see the logs for a full stack trace)")));
                            return;
                        }
                    }
                    dqConfig.getGlobalQuota().setValue(chosenQuota.doubleValue(), chosenUnit);
                    try {
                        gwc.saveDiskQuotaConfig(dqConfig, jdbcConfig.clone(false));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Failed to save the JDBC configuration", e);
                        this.error((Serializable)((Object)("Failure occurred while saving the JDBC configuration" + e.getMessage() + " (see the logs for a full stack trace)")));
                        return;
                    }
                }
                DiskQuotaSettingsPage.this.doReturn();
            }
        }});
        form.add(new Component[]{new GeoServerAjaxFormLink("cancel"){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                DiskQuotaSettingsPage.this.doReturn();
            }
        }});
        this.checkWarnings();
    }

    private void checkWarnings() {
        Long imageIOFileCachingThreshold = ImageIOExt.getFilesystemThreshold();
        if (null == imageIOFileCachingThreshold || 0L >= imageIOFileCachingThreshold) {
            String warningMsg = new ResourceModel("GWC.ImageIOFileCachingThresholdUnsetWarning").getObject();
            super.warn((Serializable)((Object)warningMsg));
        }
    }

    private GWC getGWC() {
        GWC gwc = (GWC)this.getGeoServerApplication().getBean("gwcFacade");
        gwc.getGwcSynchEnv().syncEnv();
        return gwc;
    }

    static CheckBox checkbox(String id, IModel<Boolean> model, String titleKey) {
        CheckBox checkBox = new CheckBox(id, model);
        if (null != titleKey) {
            AttributeModifier attributeModifier = new AttributeModifier("title", (IModel)new StringResourceModel(titleKey, null, null));
            checkBox.add(new Behavior[]{attributeModifier});
        }
        return checkBox;
    }
}

