/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.blob.BlobStoreTypes;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geowebcache.config.BlobStoreInfo;

public class BlobStoresProvider
extends GeoServerDataProvider<BlobStoreInfo> {
    private static final long serialVersionUID = 4400431816195261839L;
    public static final GeoServerDataProvider.Property<BlobStoreInfo> ID = new GeoServerDataProvider.BeanProperty("id", "id");
    public static final GeoServerDataProvider.Property<BlobStoreInfo> TYPE = new GeoServerDataProvider.BeanProperty("type", "class");
    public static final GeoServerDataProvider.Property<BlobStoreInfo> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    public static final GeoServerDataProvider.Property<BlobStoreInfo> DEFAULT = new GeoServerDataProvider.BeanProperty("default", "default");

    protected List<GeoServerDataProvider.Property<BlobStoreInfo>> getProperties() {
        return Arrays.asList(ID, TYPE, ENABLED, DEFAULT);
    }

    protected Comparator<BlobStoreInfo> getComparator(SortParam<?> sort) {
        if (sort != null && sort.getProperty().equals(TYPE.getName())) {
            return (o1, o2) -> {
                int r = BlobStoreTypes.getFromClass(o1.getClass()).toString().compareTo(BlobStoreTypes.getFromClass(o2.getClass()).toString());
                return sort.isAscending() ? r : -r;
            };
        }
        return super.getComparator(sort);
    }

    protected List<BlobStoreInfo> getItems() {
        return GWC.get().getBlobStores();
    }
}

