/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.blob.BlobStoreType;
import org.geoserver.gwc.web.blob.BlobStoreTypes;
import org.geoserver.gwc.web.blob.BlobStoresPage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.layer.TileLayer;

public class BlobStorePage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = -59024268194792891L;
    private DropDownChoice<BlobStoreType> typeOfBlobStore;
    private WebMarkupContainer blobConfigContainer;
    private Form<BlobStoreInfo> blobStoreForm;
    private TextField<String> tfId;
    private CheckBox cbDefault;
    private CheckBox cbEnabled;
    private GeoServerDialog dialog;

    public BlobStorePage() {
        this(null);
    }

    public BlobStorePage(final BlobStoreInfo originalStore) {
        ArrayList<String> assignedLayers = new ArrayList<String>();
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("confirmDisableDialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmDisableDialog.title", (Component)this.getPage(), new Object[0]));
        this.dialog.setInitialHeight(200);
        this.typeOfBlobStore = new DropDownChoice("typeOfBlobStore", (IModel)new Model(), BlobStoreTypes.getAll());
        this.typeOfBlobStore.setOutputMarkupId(true);
        this.typeOfBlobStore.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 359589121400814043L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean visible = BlobStorePage.this.typeOfBlobStore.getModelObject() != null;
                BlobStorePage.this.blobStoreForm.setVisible(visible);
                if (visible) {
                    BlobStorePage.this.blobStoreForm.getModel().setObject(((BlobStoreType)BlobStorePage.this.typeOfBlobStore.getModelObject()).newConfigObject());
                    BlobStorePage.this.blobStoreForm.addOrReplace(new Component[]{((BlobStoreType)BlobStorePage.this.typeOfBlobStore.getModelObject()).createPanel("blobSpecificPanel", BlobStorePage.this.blobStoreForm.getModel())});
                }
                target.add(new Component[]{BlobStorePage.this.blobConfigContainer});
            }
        }});
        this.typeOfBlobStore.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel("typeOfBlobStore.title"))});
        Form selector = new Form("selector");
        selector.add(new Component[]{this.typeOfBlobStore});
        this.add(new Component[]{selector});
        this.blobConfigContainer = new WebMarkupContainer("blobConfigContainer");
        this.blobConfigContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.blobConfigContainer});
        this.blobStoreForm = new Form("blobStoreForm", (IModel)new CompoundPropertyModel(originalStore == null ? null : (BlobStoreInfo)originalStore.clone()));
        this.blobConfigContainer.add(new Component[]{this.blobStoreForm});
        this.blobStoreForm.setVisible(originalStore != null);
        Component[] componentArray2 = new Component[1];
        this.tfId = new TextField("name");
        componentArray2[0] = this.tfId.setRequired(true);
        this.blobStoreForm.add(componentArray2);
        this.tfId.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel("name.title"))});
        Component[] componentArray3 = new Component[1];
        this.cbEnabled = new CheckBox("enabled");
        componentArray3[0] = this.cbEnabled;
        this.blobStoreForm.add(componentArray3);
        this.cbEnabled.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel("enabled.title"))});
        Component[] componentArray4 = new Component[1];
        this.cbDefault = new CheckBox("default");
        componentArray4[0] = this.cbDefault;
        this.blobStoreForm.add(componentArray4);
        this.cbDefault.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel("default.title"))});
        if (originalStore != null) {
            this.typeOfBlobStore.getModel().setObject(BlobStoreTypes.getFromClass(originalStore.getClass()));
            this.blobStoreForm.addOrReplace(new Component[]{((BlobStoreType)this.typeOfBlobStore.getModelObject()).createPanel("blobSpecificPanel", this.blobStoreForm.getModel())});
            this.typeOfBlobStore.setEnabled(false);
            for (TileLayer layer : GWC.get().getTileLayers()) {
                if (!originalStore.getName().equals(layer.getBlobStoreId())) continue;
                assignedLayers.add(layer.getName());
            }
        }
        this.blobStoreForm.add((IFormValidator)new AbstractFormValidator(){
            private static final long serialVersionUID = 5240602030478856537L;

            public FormComponent<?>[] getDependentFormComponents() {
                return new FormComponent[]{BlobStorePage.this.cbDefault, BlobStorePage.this.cbEnabled};
            }

            public void validate(Form<?> form) {
                BlobStoreInfo blobStore = (BlobStoreInfo)form.getModelObject();
                if (blobStore.isDefault() && !((Boolean)BlobStorePage.this.cbDefault.getConvertedInput()).booleanValue()) {
                    form.error((Serializable)((Object)new ParamResourceModel("defaultError", (Component)BlobStorePage.this.getPage(), new Object[0]).getString()));
                } else if (((Boolean)BlobStorePage.this.cbDefault.getConvertedInput()).booleanValue() && !((Boolean)BlobStorePage.this.cbEnabled.getConvertedInput()).booleanValue()) {
                    form.error((Serializable)((Object)new ParamResourceModel("enabledError", (Component)BlobStorePage.this.getPage(), new Object[0]).getString()));
                }
            }
        });
        this.blobStoreForm.add((IFormValidator)new AbstractFormValidator(){
            private static final long serialVersionUID = 5240602030478856537L;

            public FormComponent<?>[] getDependentFormComponents() {
                return new FormComponent[]{BlobStorePage.this.tfId};
            }

            public void validate(Form<?> form) {
                for (BlobStoreInfo otherBlobStore : GWC.get().getBlobStores()) {
                    if (otherBlobStore.equals((Object)originalStore) || !otherBlobStore.getName().equals(BlobStorePage.this.tfId.getConvertedInput())) continue;
                    form.error((Serializable)((Object)new ParamResourceModel("duplicateIdError", (Component)BlobStorePage.this.getPage(), new Object[0]).getString()));
                }
            }
        });
        this.blobStoreForm.add(new Component[]{new SaveLink(originalStore, assignedLayers)});
        this.blobStoreForm.add(new Component[]{new BookmarkablePageLink("cancel", BlobStoresPage.class)});
    }

    protected void save(BlobStoreInfo originalStore, BlobStoreInfo blobStore, List<String> assignedLayers) throws ConfigurationException {
        BlobStoreInfo defaultStore = null;
        if (blobStore.isDefault() && (originalStore == null || !originalStore.isDefault()) && (defaultStore = GWC.get().getDefaultBlobStore()) != null) {
            defaultStore.setDefault(false);
            GWC.get().modifyBlobStore(defaultStore.getName(), defaultStore);
        }
        try {
            if (originalStore == null) {
                GWC.get().addBlobStore(blobStore);
            } else {
                GWC.get().modifyBlobStore(originalStore.getName(), blobStore);
            }
        }
        catch (ConfigurationException e) {
            if (defaultStore != null) {
                defaultStore.setDefault(true);
                GWC.get().modifyBlobStore(defaultStore.getName(), defaultStore);
            }
            throw e;
        }
        if (originalStore != null) {
            boolean disable;
            boolean updateId = !blobStore.getName().equals(originalStore.getName());
            boolean bl = disable = originalStore.isEnabled() && !blobStore.isEnabled();
            if (updateId || disable) {
                for (String layerName : assignedLayers) {
                    TileLayer layer = GWC.get().getTileLayerByName(layerName);
                    if (updateId) {
                        layer.setBlobStoreId(blobStore.getName());
                    }
                    if (disable) {
                        layer.setEnabled(false);
                    }
                    GWC.get().save(layer);
                }
            }
        }
    }

    private class SaveLink
    extends AjaxSubmitLink {
        private static final long serialVersionUID = 3735176778941168701L;
        private final BlobStoreInfo originalStore;
        private final List<String> assignedLayers;

        public SaveLink(BlobStoreInfo originalStore, List<String> assignedLayers) {
            super("save");
            this.originalStore = originalStore;
            this.assignedLayers = assignedLayers;
        }

        public void onSubmit(AjaxRequestTarget target, Form<?> form) {
            final BlobStoreInfo blobStore = (BlobStoreInfo)this.getForm().getModelObject();
            if (this.originalStore != null && this.originalStore.isEnabled() && !blobStore.isEnabled() && !this.assignedLayers.isEmpty()) {
                BlobStorePage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                    private static final long serialVersionUID = 5257987095800108993L;
                    private boolean success;
                    private String error = null;

                    protected Component getContents(String id) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(new ParamResourceModel("confirmDisableDialog.content", (Component)SaveLink.this.getPage(), new Object[0]).getString());
                        for (String layer : SaveLink.this.assignedLayers) {
                            sb.append("\n&nbsp;&nbsp;");
                            sb.append(StringEscapeUtils.escapeHtml4((String)layer));
                        }
                        return new MultiLineLabel("userPanel", sb.toString()).setEscapeModelStrings(false);
                    }

                    protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                        try {
                            BlobStorePage.this.save(SaveLink.this.originalStore, blobStore, SaveLink.this.assignedLayers);
                            this.success = true;
                        }
                        catch (ConfigurationException e) {
                            this.error = e.getMessage();
                        }
                        return true;
                    }

                    public void onClose(AjaxRequestTarget target) {
                        if (this.success) {
                            BlobStorePage.this.doReturn(BlobStoresPage.class);
                        } else if (this.error != null) {
                            SaveLink.this.error((Serializable)((Object)this.error));
                            BlobStorePage.this.addFeedbackPanels(target);
                        }
                    }
                });
            } else {
                try {
                    BlobStorePage.this.save(this.originalStore, blobStore, this.assignedLayers);
                    BlobStorePage.this.doReturn(BlobStoresPage.class);
                }
                catch (ConfigurationException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    BlobStorePage.this.addFeedbackPanels(target);
                }
            }
        }

        protected void onError(AjaxRequestTarget target, Form<?> form) {
            BlobStorePage.this.addFeedbackPanels(target);
        }
    }
}

