/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.gwc.ConfigurableBlobStore;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;

public class InMemoryBlobStorePanel
extends Panel {
    public static final String KEY_MISS_RATE = "missRate";
    public static final String KEY_HIT_RATE = "hitRate";
    public static final String KEY_EVICTED = "evicted";
    public static final String KEY_MISS_COUNT = "missCount";
    public static final String KEY_HIT_COUNT = "hitCount";
    public static final String KEY_TOTAL_COUNT = "totalCount";
    public static final String KEY_CURRENT_MEM = "currentMemory";
    public static final String KEY_SIZE = "cacheSize";
    private HashMap<String, String> values = new HashMap();

    public InMemoryBlobStorePanel(String id, IModel<GWCConfig> gwcConfigModel) {
        super(id, gwcConfigModel);
        DropDownChoice choice;
        PropertyModel innerCachingEnabled = new PropertyModel(gwcConfigModel, "innerCachingEnabled");
        final CheckBox innerCachingEnabledChoice = new CheckBox("innerCachingEnabled", (IModel)innerCachingEnabled);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true).setEnabled(true);
        CacheConfigContainerWrapper cacheConfigContainer = new CacheConfigContainerWrapper("cacheConfContainer", ((GWCConfig)gwcConfigModel.getObject()).getCacheProviderClass(), gwcConfigModel);
        cacheConfigContainer.setOutputMarkupId(true);
        PropertyModel persistenceEnabled = new PropertyModel(gwcConfigModel, "persistenceEnabled");
        CheckBox persistenceEnabledChoice = new CheckBox("persistenceEnabled", (IModel)persistenceEnabled);
        boolean visible = innerCachingEnabledChoice.getModelObject() == null ? false : (Boolean)innerCachingEnabledChoice.getModelObject();
        container.setVisible(visible);
        ConfigurableBlobStore store = (ConfigurableBlobStore)GeoServerExtensions.bean(ConfigurableBlobStore.class);
        if (store != null) {
            Map cacheProviders = store.getCacheProvidersNames();
            PropertyModel providerClass = new PropertyModel(gwcConfigModel, "cacheProviderClass");
            CacheProviderRenderer renderer = new CacheProviderRenderer(cacheProviders);
            choice = new DropDownChoice("caches", (IModel)providerClass, new ArrayList(cacheProviders.keySet()), (IChoiceRenderer)renderer);
            choice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (IModel)providerClass, cacheConfigContainer, gwcConfigModel){
                final /* synthetic */ IModel val$providerClass;
                final /* synthetic */ CacheConfigContainerWrapper val$cacheConfigContainer;
                final /* synthetic */ IModel val$gwcConfigModel;
                {
                    this.val$providerClass = iModel;
                    this.val$cacheConfigContainer = cacheConfigContainerWrapper;
                    this.val$gwcConfigModel = iModel2;
                    super(x0);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    ConfigurableBlobStore store = (ConfigurableBlobStore)GeoServerExtensions.bean(ConfigurableBlobStore.class);
                    String cacheClass = (String)this.val$providerClass.getObject();
                    boolean immutable = false;
                    if (store != null) {
                        immutable = ((CacheProvider)store.getCacheProviders().get(cacheClass)).isImmutable();
                    }
                    this.val$cacheConfigContainer.setEnabled(!immutable);
                    if (!immutable) {
                        if (!((GWCConfig)this.val$gwcConfigModel.getObject()).getCacheConfigurations().containsKey(cacheClass)) {
                            ((GWCConfig)this.val$gwcConfigModel.getObject()).getCacheConfigurations().put(cacheClass, new CacheConfiguration());
                        }
                        this.val$cacheConfigContainer.setMapKey(cacheClass, (IModel<GWCConfig>)this.val$gwcConfigModel);
                    }
                    target.add(new Component[]{this.val$cacheConfigContainer});
                }
            }});
            cacheConfigContainer.setEnabled(!((CacheProvider)store.getCacheProviders().get(providerClass.getObject())).isImmutable());
        } else {
            choice = new DropDownChoice("caches", new ArrayList());
        }
        container.add(new Component[]{choice});
        persistenceEnabledChoice.setOutputMarkupId(true).setEnabled(true);
        container.add(new Component[]{cacheConfigContainer});
        innerCachingEnabledChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean isVisible = innerCachingEnabledChoice.getModelObject() == null ? false : (Boolean)innerCachingEnabledChoice.getModelObject();
                container.setVisible(isVisible);
                target.add(new Component[]{container.getParent()});
            }
        }});
        this.add(new Component[]{innerCachingEnabledChoice});
        container.add(new Component[]{persistenceEnabledChoice});
        this.add(new Component[]{container});
        Button clearCache = new Button("cacheClear"){

            public void onSubmit() {
                ConfigurableBlobStore store = (ConfigurableBlobStore)GeoServerExtensions.bean(ConfigurableBlobStore.class);
                if (store != null) {
                    store.clearCache();
                }
            }
        };
        container.add(new Component[]{clearCache});
        final WebMarkupContainer statsContainer = new WebMarkupContainer("statsContainer");
        statsContainer.setOutputMarkupId(true);
        Label totalCountLabel = new Label(KEY_TOTAL_COUNT, (IModel)new MapModel(this.values, KEY_TOTAL_COUNT));
        Label hitCountLabel = new Label(KEY_HIT_COUNT, (IModel)new MapModel(this.values, KEY_HIT_COUNT));
        Label missCountLabel = new Label(KEY_MISS_COUNT, (IModel)new MapModel(this.values, KEY_MISS_COUNT));
        Label missRateLabel = new Label(KEY_MISS_RATE, (IModel)new MapModel(this.values, KEY_MISS_RATE));
        Label hitRateLabel = new Label(KEY_HIT_RATE, (IModel)new MapModel(this.values, KEY_HIT_RATE));
        Label evictedLabel = new Label(KEY_EVICTED, (IModel)new MapModel(this.values, KEY_EVICTED));
        Label currentMemoryLabel = new Label(KEY_CURRENT_MEM, (IModel)new MapModel(this.values, KEY_CURRENT_MEM));
        Label cacheSizeLabel = new Label(KEY_SIZE, (IModel)new MapModel(this.values, KEY_SIZE));
        statsContainer.add(new Component[]{totalCountLabel});
        statsContainer.add(new Component[]{hitCountLabel});
        statsContainer.add(new Component[]{missCountLabel});
        statsContainer.add(new Component[]{missRateLabel});
        statsContainer.add(new Component[]{hitRateLabel});
        statsContainer.add(new Component[]{evictedLabel});
        statsContainer.add(new Component[]{currentMemoryLabel});
        statsContainer.add(new Component[]{cacheSizeLabel});
        AjaxButton statistics = new AjaxButton("statistics"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    ConfigurableBlobStore store = (ConfigurableBlobStore)GeoServerExtensions.bean(ConfigurableBlobStore.class);
                    if (store != null) {
                        CacheStatistics stats = store.getCacheStatistics();
                        long hitCount = stats.getHitCount();
                        long missCount = stats.getMissCount();
                        long total = stats.getRequestCount();
                        double hitRate = stats.getHitRate();
                        double missRate = stats.getMissRate();
                        long evicted = stats.getEvictionCount();
                        double currentMem = stats.getCurrentMemoryOccupation();
                        long byteToMb = 0x100000L;
                        double actualSize = (double)((long)(100.0 * ((double)stats.getActualSize() * 1.0) / (double)byteToMb)) / 100.0;
                        double totalSize = (double)((long)(100.0 * ((double)stats.getTotalSize() * 1.0) / (double)byteToMb)) / 100.0;
                        InMemoryBlobStorePanel.this.values.put(InMemoryBlobStorePanel.KEY_MISS_RATE, missRate >= 0.0 ? missRate + " %" : "Unavailable");
                        InMemoryBlobStorePanel.this.values.put(InMemoryBlobStorePanel.KEY_HIT_RATE, hitRate >= 0.0 ? hitRate + " %" : "Unavailable");
                        InMemoryBlobStorePanel.this.values.put(InMemoryBlobStorePanel.KEY_EVICTED, evicted >= 0L ? evicted + "" : "Unavailable");
                        InMemoryBlobStorePanel.this.values.put(InMemoryBlobStorePanel.KEY_TOTAL_COUNT, total >= 0L ? total + "" : "Unavailable");
                        InMemoryBlobStorePanel.this.values.put(InMemoryBlobStorePanel.KEY_MISS_COUNT, missCount >= 0L ? missCount + "" : "Unavailable");
                        InMemoryBlobStorePanel.this.values.put(InMemoryBlobStorePanel.KEY_HIT_COUNT, hitCount >= 0L ? hitCount + "" : "Unavailable");
                        InMemoryBlobStorePanel.this.values.put(InMemoryBlobStorePanel.KEY_CURRENT_MEM, currentMem >= 0.0 ? currentMem + " %" : "Unavailable");
                        InMemoryBlobStorePanel.this.values.put(InMemoryBlobStorePanel.KEY_SIZE, currentMem >= 0.0 && actualSize >= 0.0 ? actualSize + " / " + totalSize + " Mb" : "Unavailable");
                    }
                }
                catch (Throwable t) {
                    this.error(t);
                }
                target.add(new Component[]{statsContainer});
            }
        };
        container.add(new Component[]{statsContainer});
        container.add(new Component[]{statistics});
    }

    static class CacheConfigContainerWrapper
    extends WebMarkupContainer {
        public CacheConfigContainerWrapper(String id, String key, IModel<GWCConfig> gwcConfigModel) {
            super(id);
            this.setMapKey(key, gwcConfigModel);
        }

        public void setMapKey(String key, IModel<GWCConfig> gwcConfigModel) {
            this.removeAll();
            PropertyModel cacheConfigurations = new PropertyModel(gwcConfigModel, "cacheConfigurations");
            MapModel cacheConfiguration = new MapModel((IModel)cacheConfigurations, key);
            PropertyModel hardMemoryLimit = new PropertyModel((Object)cacheConfiguration, "hardMemoryLimit");
            PropertyModel evictionTimeValue = new PropertyModel((Object)cacheConfiguration, "evictionTime");
            PropertyModel policy = new PropertyModel((Object)cacheConfiguration, "policy");
            PropertyModel concurrencyLevel = new PropertyModel((Object)cacheConfiguration, "concurrencyLevel");
            TextField hardMemory = new TextField("hardMemoryLimit", (IModel)hardMemoryLimit);
            hardMemory.setType(Long.class).setOutputMarkupId(true).setEnabled(true);
            hardMemory.add((IValidator)new MinimumLongValidator("BlobStorePanel.invalidHardMemory"));
            TextField evictionTime = new TextField("evictionTime", (IModel)evictionTimeValue);
            evictionTime.setType(Long.class).setOutputMarkupId(true).setEnabled(true);
            List evictionPolicies = Arrays.asList(CacheConfiguration.EvictionPolicy.values());
            ConfigurableBlobStore store = (ConfigurableBlobStore)GeoServerExtensions.bean(ConfigurableBlobStore.class);
            if (store != null) {
                CacheProvider cache = (CacheProvider)store.getCacheProviders().get(key);
                evictionPolicies = cache.getSupportedPolicies();
            }
            DropDownChoice policyDropDown = new DropDownChoice("policy", (IModel)policy, evictionPolicies);
            policyDropDown.setOutputMarkupId(true).setEnabled(true);
            TextField textConcurrency = new TextField("concurrencyLevel", (IModel)concurrencyLevel);
            textConcurrency.setType(Integer.class).setOutputMarkupId(true).setEnabled(true);
            textConcurrency.add((IValidator)new MinimumConcurrencyValidator());
            this.add(new Component[]{hardMemory});
            this.add(new Component[]{policyDropDown});
            this.add(new Component[]{textConcurrency});
            this.add(new Component[]{evictionTime});
        }
    }

    static class CacheProviderRenderer
    extends ChoiceRenderer<String> {
        private Map<String, String> map;

        public CacheProviderRenderer(Map<String, String> map) {
            this.map = map;
        }

        public Object getDisplayValue(String object) {
            return this.map.get(object);
        }

        public String getIdValue(String object, int index) {
            return object;
        }
    }

    static class MinimumConcurrencyValidator
    implements IValidator<Integer> {
        MinimumConcurrencyValidator() {
        }

        public void validate(IValidatable<Integer> iv) {
            if ((Integer)iv.getValue() <= 0) {
                ValidationError error = new ValidationError();
                error.setMessage((String)new ParamResourceModel("BlobStorePanel.invalidConcurrency", null, new Object[]{""}).getObject());
                iv.error((IValidationError)error);
            }
        }
    }

    static class MinimumLongValidator
    implements IValidator<Long> {
        private String errorKey;

        public MinimumLongValidator(String error) {
            this.errorKey = error;
        }

        public void validate(IValidatable<Long> iv) {
            if ((Long)iv.getValue() <= 0L) {
                ValidationError error = new ValidationError();
                error.setMessage((String)new ParamResourceModel(this.errorKey, null, new Object[]{""}).getObject());
                iv.error((IValidationError)error);
            }
        }
    }
}

